/*
 * Decompiled with CFR 0.152.
 */
package jmetest.intersection;

import com.jme.animation.SkinNode;
import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingCapsule;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Capsule;
import com.jme.scene.shape.Teapot;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.WireframeState;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import com.jmex.model.collada.ColladaImporter;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import jmetest.renderer.loader.TestColladaLoading;

public class TestBoundingCapsule
extends SimpleGame {
    private Quaternion rotQuat = new Quaternion();
    private float angle = 0.0f;
    private Vector3f axis = new Vector3f(0.0f, 1.0f, 0.0f);
    private Spatial s;
    private Box t;
    private float tInc = -40.0f;
    private Capsule c;

    public static void main(String[] stringArray) {
        LoggingSystem.getLogger().setLevel(Level.OFF);
        TestBoundingCapsule testBoundingCapsule = new TestBoundingCapsule();
        testBoundingCapsule.setDialogBehaviour(2);
        testBoundingCapsule.start();
    }

    protected void simpleUpdate() {
        if (this.timer.getTimePerFrame() < 1.0f) {
            this.angle += this.timer.getTimePerFrame() * 1.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle, this.axis);
        this.t.setLocalRotation(this.rotQuat);
        this.t.getLocalTranslation().y += this.tInc * this.timer.getTimePerFrame();
        if (this.t.getLocalTranslation().y > 40.0f) {
            this.t.getLocalTranslation().y = 40.0f;
            this.tInc *= -1.0f;
        } else if (this.t.getLocalTranslation().y < -40.0f) {
            this.t.getLocalTranslation().y = -40.0f;
            this.tInc *= -1.0f;
        }
        if (this.t.hasCollision(this.s, false)) {
            System.out.println("hasCollision reports true");
        }
        BoundingCapsule boundingCapsule = (BoundingCapsule)this.t.getWorldBound();
        BoundingCapsule boundingCapsule2 = (BoundingCapsule)this.s.getWorldBound();
        this.c.reconstruct(boundingCapsule.getLineSegment().getOrigin(), boundingCapsule2.getLineSegment().getOrigin(), 1.0f);
    }

    protected void simpleInitGame() {
        this.display.setTitle("jME - Bounding Capsule");
        URL uRL = TestColladaLoading.class.getClassLoader().getResource("jmetest/data/model/collada/");
        InputStream inputStream = TestColladaLoading.class.getClassLoader().getResourceAsStream("jmetest/data/model/collada/man.dae");
        if (inputStream == null) {
            System.out.println("Unable to find file, did you include jme-test.jar in classpath?");
            System.exit(0);
        }
        ColladaImporter.load((InputStream)inputStream, (URL)uRL, (String)"model");
        SkinNode skinNode = ColladaImporter.getSkinNode((String)((String)ColladaImporter.getSkinNodeNames().get(0)));
        ColladaImporter.cleanUp();
        skinNode.setModelBound((BoundingVolume)new BoundingCapsule());
        skinNode.updateModelBound();
        this.s = new Teapot("Teapot");
        this.rootNode.attachChild(this.s);
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis(2.0f, new Vector3f(1.0f, 23.0f, 1.0f));
        this.s.setLocalRotation(quaternion);
        this.s.setLocalTranslation(new Vector3f(10.0f, 2.0f, 1.0f));
        this.s.setModelBound((BoundingVolume)new BoundingCapsule());
        this.s.updateModelBound();
        this.t = new Box("box", new Vector3f(0.0f, 0.0f, 0.0f), 10.0f, 2.0f, 2.0f);
        this.t.getBatch(0).translatePoints(2.5f, 10.0f, 1.0f);
        this.t.setModelBound((BoundingVolume)new BoundingCapsule());
        this.t.setLocalTranslation(new Vector3f(15.0f, 0.0f, 10.0f));
        this.t.setLocalScale(new Vector3f(1.0f, 2.0f, 1.0f));
        this.t.updateModelBound();
        this.rootNode.attachChild((Spatial)this.t);
        this.c = new Capsule("c", 20, 20, 20, 1.0f, 1.0f);
        WireframeState wireframeState = this.display.getRenderer().createWireframeState();
        wireframeState.setEnabled(true);
        this.c.setRenderState((RenderState)wireframeState);
        this.c.clearRenderState(6);
        this.c.setTextureCombineMode(0);
        this.c.setLightCombineMode(0);
        this.c.setDefaultColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        this.rootNode.attachChild((Spatial)this.c);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestBoundingCapsule.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1));
        this.rootNode.setRenderState((RenderState)textureState);
        this.rootNode.updateGeometricState(0.0f, true);
        System.out.println(this.rootNode.getWorldBound());
    }
}

