/*
 * Decompiled with CFR 0.152.
 */
package jmetest.intersection;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingCapsule;
import com.jme.bounding.BoundingVolume;
import com.jme.intersection.BoundingCollisionResults;
import com.jme.intersection.CollisionResults;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Box;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import java.net.URL;

public class TestCollision
extends SimpleGame {
    private TriMesh t;
    private TriMesh t2;
    private Text text;
    private Node scene;
    private Quaternion rotQuat = new Quaternion();
    private float angle = 0.0f;
    private Vector3f axis = new Vector3f(1.0f, 0.0f, 0.0f);
    private float tInc = -40.0f;
    private float t2Inc = -10.0f;
    private CollisionResults results;
    private Node n1;
    private Node n2;

    public static void main(String[] stringArray) {
        TestCollision testCollision = new TestCollision();
        testCollision.setDialogBehaviour(2);
        testCollision.start();
    }

    protected void simpleUpdate() {
        if (this.timer.getTimePerFrame() < 1.0f) {
            this.angle += this.timer.getTimePerFrame() * 1.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle, this.axis);
        this.t.setLocalRotation(this.rotQuat);
        this.t.getLocalTranslation().y += this.tInc * this.timer.getTimePerFrame();
        this.t2.getLocalTranslation().x += this.t2Inc * this.timer.getTimePerFrame();
        if (this.t.getLocalTranslation().y > 40.0f) {
            this.t.getLocalTranslation().y = 40.0f;
            this.tInc *= -1.0f;
        } else if (this.t.getLocalTranslation().y < -40.0f) {
            this.t.getLocalTranslation().y = -40.0f;
            this.tInc *= -1.0f;
        }
        if (this.t2.getLocalTranslation().x > 40.0f) {
            this.t2.getLocalTranslation().x = 40.0f;
            this.t2Inc *= -1.0f;
        } else if (this.t2.getLocalTranslation().x < -40.0f) {
            this.t2.getLocalTranslation().x = -40.0f;
            this.t2Inc *= -1.0f;
        }
        this.results.clear();
        this.n1.calculateCollisions((Spatial)this.scene, this.results);
        if (this.n1.hasCollision((Spatial)this.scene, false)) {
            System.out.println("hasCollision also reports true");
        }
    }

    protected void simpleInitGame() {
        this.results = new BoundingCollisionResults(){

            public void processCollisions() {
                if (this.getNumber() > 0) {
                    TestCollision.this.text.print("Collision: YES");
                } else {
                    TestCollision.this.text.print("Collision: NO");
                }
            }
        };
        this.display.setTitle("Collision Detection");
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 75.0f));
        this.cam.update();
        this.text = new Text("Text Label", "Collision: No");
        this.text.setLocalTranslation(new Vector3f(1.0f, 60.0f, 0.0f));
        this.fpsNode.attachChild((Spatial)this.text);
        this.scene = new Node("3D Scene Root");
        Vector3f vector3f = new Vector3f(5.0f, 5.0f, 5.0f);
        Vector3f vector3f2 = new Vector3f(-5.0f, -5.0f, -5.0f);
        this.n1 = new Node("Node 1");
        this.n2 = new Node("Node 2");
        this.t = new Box("Box 1", vector3f2, vector3f);
        this.t.setModelBound((BoundingVolume)new BoundingCapsule());
        this.t.updateModelBound();
        this.t.setLocalTranslation(new Vector3f(0.0f, 30.0f, 0.0f));
        this.t.setLocalScale(new Vector3f(1.0f, 2.0f, 3.0f));
        this.t2 = new Box("Box 2", vector3f2, vector3f);
        this.t2.setModelBound((BoundingVolume)new BoundingCapsule());
        this.t2.updateModelBound();
        this.t2.setLocalTranslation(new Vector3f(30.0f, 0.0f, 0.0f));
        this.n1.attachChild((Spatial)this.t);
        this.n2.attachChild((Spatial)this.t2);
        this.scene.attachChild((Spatial)this.n1);
        this.scene.attachChild((Spatial)this.n2);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestCollision.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1));
        this.scene.setRenderState((RenderState)textureState);
        this.rootNode.attachChild((Spatial)this.scene);
    }
}

