/*
 * Decompiled with CFR 0.152.
 */
package jmetest.intersection;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingCapsule;
import com.jme.bounding.BoundingVolume;
import com.jme.input.action.MouseInputAction;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Line;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.util.TextureKey;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.model.XMLparser.Converters.MilkToJme;
import com.jmex.model.animation.JointController;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import jmetest.intersection.MousePick;
import jmetest.renderer.loader.TestMilkJmeWrite;

public class TestPick
extends SimpleGame {
    private Node model;

    public static void main(String[] stringArray) {
        TestPick testPick = new TestPick();
        testPick.setDialogBehaviour(2);
        testPick.start();
    }

    protected void simpleInitGame() {
        this.display.setTitle("Mouse Pick");
        this.cam.setLocation(new Vector3f(0.0f, 50.0f, 100.0f));
        this.cam.update();
        Text text = Text.createDefaultTextLabel((String)"Test Label", (String)"Hits: 0 Shots: 0");
        text.setCullMode(3);
        text.setTextureCombineMode(5);
        text.setLocalTranslation(new Vector3f(1.0f, 60.0f, 0.0f));
        Text text2 = Text.createDefaultTextLabel((String)"Cross hairs", (String)"+");
        text2.setCullMode(3);
        text2.setTextureCombineMode(5);
        text2.setLocalTranslation(new Vector3f((float)this.display.getWidth() / 2.0f - 8.0f, (float)this.display.getHeight() / 2.0f - 8.0f, 0.0f));
        this.fpsNode.attachChild((Spatial)text);
        this.fpsNode.attachChild((Spatial)text2);
        MilkToJme milkToJme = new MilkToJme();
        URL uRL = TestMilkJmeWrite.class.getClassLoader().getResource("jmetest/data/model/msascii/run.ms3d");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            milkToJme.convert(uRL.openStream(), (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            System.out.println("IO problem writting the file!!!");
            System.out.println(iOException.getMessage());
            System.exit(0);
        }
        this.model = null;
        try {
            TextureKey.setOverridingLocation((URL)TestMilkJmeWrite.class.getClassLoader().getResource("jmetest/data/model/msascii/"));
            this.model = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            this.model.setModelBound((BoundingVolume)new BoundingCapsule());
            this.model.updateModelBound();
        }
        catch (IOException iOException) {
            System.out.println("darn exceptions:" + iOException.getMessage());
        }
        ((JointController)this.model.getController(0)).setActive(false);
        Vector3f[] vector3fArray = new Vector3f[1000];
        ColorRGBA[] colorRGBAArray = new ColorRGBA[1000];
        for (int i = 0; i < 1000; ++i) {
            vector3fArray[i] = new Vector3f();
            vector3fArray[i].x = FastMath.nextRandomFloat() * -100.0f - 50.0f;
            vector3fArray[i].y = FastMath.nextRandomFloat() * 50.0f - 25.0f;
            vector3fArray[i].z = FastMath.nextRandomFloat() * 50.0f - 25.0f;
            colorRGBAArray[i] = ColorRGBA.randomColor();
        }
        Line line = new Line("Line Group", vector3fArray, null, colorRGBAArray, null);
        line.setModelBound((BoundingVolume)new BoundingBox());
        line.updateModelBound();
        line.setLightCombineMode(0);
        this.rootNode.attachChild((Spatial)line);
        this.rootNode.attachChild((Spatial)this.model);
        MousePick mousePick = new MousePick(this.cam, this.rootNode, text);
        this.input.addAction((MouseInputAction)mousePick);
    }
}

