/*
 * Decompiled with CFR 0.152.
 */
package jmetest.intersection;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.AbsoluteMouse;
import com.jme.input.MouseInput;
import com.jme.intersection.PickData;
import com.jme.intersection.PickResults;
import com.jme.intersection.TrianglePickResults;
import com.jme.math.Quaternion;
import com.jme.math.Ray;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Line;
import com.jme.scene.Point;
import com.jme.scene.Spatial;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.util.TextureManager;
import com.jme.util.export.binary.BinaryImporter;
import com.jme.util.geom.BufferUtils;
import com.jmex.model.XMLparser.Converters.ObjToJme;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.FloatBuffer;
import java.util.ArrayList;

public class TestTrianglePick
extends SimpleGame {
    AbsoluteMouse am;
    private Point pointSelection;
    Spatial maggie;
    private Line[] selection;
    TrianglePickResults results = new TrianglePickResults(){

        public void processPick() {
            int n;
            int n2 = 0;
            for (n = 0; n < this.getNumber(); ++n) {
                n2 += this.getPickData(n).getTargetTris().size();
            }
            TestTrianglePick.this.createSelectionTriangles(n2);
            if (this.getNumber() > 0) {
                n = 0;
                for (int i = 0; i < this.getNumber(); ++i) {
                    PickData pickData = this.getPickData(i);
                    ArrayList arrayList = pickData.getTargetTris();
                    TriangleBatch triangleBatch = (TriangleBatch)pickData.getTargetMesh();
                    for (int j = 0; j < arrayList.size(); ++j) {
                        int n3 = (Integer)arrayList.get(j);
                        Vector3f[] vector3fArray = new Vector3f[3];
                        triangleBatch.getTriangle(n3, vector3fArray);
                        FloatBuffer floatBuffer = TestTrianglePick.this.selection[j + n].getVertexBuffer(0);
                        for (int k = 0; k < vector3fArray.length; ++k) {
                            vector3fArray[k].multLocal(triangleBatch.getParentGeom().getWorldScale());
                            triangleBatch.getParentGeom().getWorldRotation().mult(vector3fArray[k], vector3fArray[k]);
                            vector3fArray[k].addLocal(triangleBatch.getParentGeom().getWorldTranslation());
                        }
                        BufferUtils.setInBuffer((Vector3f)vector3fArray[0], (FloatBuffer)floatBuffer, (int)0);
                        BufferUtils.setInBuffer((Vector3f)vector3fArray[1], (FloatBuffer)floatBuffer, (int)1);
                        BufferUtils.setInBuffer((Vector3f)vector3fArray[2], (FloatBuffer)floatBuffer, (int)2);
                        BufferUtils.setInBuffer((Vector3f)vector3fArray[0], (FloatBuffer)floatBuffer, (int)3);
                        if (i != 0 || j != 0) continue;
                        TestTrianglePick.this.selection[j + n].setSolidColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
                        Vector3f vector3f = new Vector3f();
                        pickData.getRay().intersectWhere(vector3fArray[0], vector3fArray[1], vector3fArray[2], vector3f);
                        BufferUtils.setInBuffer((Vector3f)vector3f, (FloatBuffer)TestTrianglePick.this.pointSelection.getVertexBuffer(0), (int)0);
                    }
                    n = arrayList.size();
                }
            }
        }
    };

    public static void main(String[] stringArray) {
        TestTrianglePick testTrianglePick = new TestTrianglePick();
        testTrianglePick.setDialogBehaviour(2);
        testTrianglePick.start();
    }

    protected void simpleInitGame() {
        ObjToJme objToJme;
        this.am = new AbsoluteMouse("The Mouse", this.display.getWidth(), this.display.getHeight());
        TextureState textureState = this.display.getRenderer().createTextureState();
        URL uRL = TestTrianglePick.class.getClassLoader().getResource("jmetest/data/cursor/cursor1.png");
        Texture texture = TextureManager.loadTexture((URL)uRL, (int)2, (int)1);
        textureState.setTexture(texture);
        this.am.setRenderState((RenderState)textureState);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        this.am.setRenderState((RenderState)alphaState);
        this.am.setLocalTranslation(new Vector3f((float)(this.display.getWidth() / 2), (float)(this.display.getHeight() / 2), 0.0f));
        this.am.registerWithInputHandler(this.input);
        URL uRL2 = TestTrianglePick.class.getClassLoader().getResource("jmetest/data/model/maggie.obj");
        try {
            objToJme = new ObjToJme();
            objToJme.setProperty("mtllib", (Object)uRL2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            objToJme.convert(uRL2.openStream(), (OutputStream)byteArrayOutputStream);
            this.maggie = (Spatial)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            this.maggie.setLocalScale(0.1f);
            this.maggie.setLocalTranslation(new Vector3f(3.0f, 1.0f, -5.0f));
            Quaternion quaternion = new Quaternion();
            quaternion.fromAngleAxis(0.5f, new Vector3f(0.0f, 1.0f, 0.0f));
            this.maggie.setLocalRotation(quaternion);
        }
        catch (IOException iOException) {
            System.out.println("Damn exceptions!" + iOException);
            iOException.printStackTrace();
            System.exit(0);
        }
        this.maggie.setModelBound((BoundingVolume)new BoundingSphere());
        this.maggie.updateModelBound();
        this.rootNode.attachChild(this.maggie);
        this.rootNode.attachChild((Spatial)this.am);
        this.maggie.lockBounds();
        this.maggie.lockTransforms();
        this.results.setCheckDistance(true);
        this.pointSelection = new Point("selected triangle", new Vector3f[1], null, new ColorRGBA[1], null);
        this.pointSelection.setSolidColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        this.pointSelection.setPointSize(10.0f);
        this.pointSelection.setAntialiased(true);
        objToJme = this.display.getRenderer().createZBufferState();
        objToJme.setFunction(7);
        this.pointSelection.setRenderState((RenderState)objToJme);
        this.pointSelection.setLightCombineMode(0);
        this.rootNode.attachChild((Spatial)this.pointSelection);
    }

    private void createSelectionTriangles(int n) {
        this.clearPreviousSelections();
        this.selection = new Line[n];
        for (int i = 0; i < this.selection.length; ++i) {
            this.selection[i] = new Line("selected triangle" + i, new Vector3f[4], null, new ColorRGBA[4], null);
            this.selection[i].setSolidColor(new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f));
            this.selection[i].setLineWidth(5.0f);
            this.selection[i].setAntialiased(true);
            this.selection[i].setMode(1);
            ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
            zBufferState.setFunction(7);
            this.selection[i].setRenderState((RenderState)zBufferState);
            this.selection[i].setLightCombineMode(0);
            this.rootNode.attachChild((Spatial)this.selection[i]);
        }
        this.rootNode.updateGeometricState(0.0f, true);
        this.rootNode.updateRenderState();
    }

    private void clearPreviousSelections() {
        if (this.selection != null) {
            for (int i = 0; i < this.selection.length; ++i) {
                this.rootNode.detachChild((Spatial)this.selection[i]);
            }
        }
    }

    protected void simpleUpdate() {
        if (MouseInput.get().isButtonDown(0)) {
            Vector2f vector2f = new Vector2f();
            vector2f.set(this.am.getHotSpotPosition().x, this.am.getHotSpotPosition().y);
            Vector3f vector3f = this.display.getWorldCoordinates(vector2f, 1.0f);
            Ray ray = new Ray(this.cam.getLocation(), vector3f.subtractLocal(this.cam.getLocation()));
            ray.getDirection().normalizeLocal();
            this.results.clear();
            this.maggie.calculatePick(ray, (PickResults)this.results);
        }
    }
}

