/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.KeyBindingManager;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import java.net.URL;
import java.nio.FloatBuffer;

public class TestAnisotropic
extends SimpleGame {
    private Quad q;
    private Texture regTexture;
    private Texture anisoTexture;
    private TextureState ts;
    private boolean useAniso = false;

    public static void main(String[] stringArray) {
        TestAnisotropic testAnisotropic = new TestAnisotropic();
        testAnisotropic.setDialogBehaviour(2);
        testAnisotropic.start();
    }

    protected void simpleUpdate() {
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("aniso", false)) {
            if (this.useAniso) {
                this.display.setTitle("Anisotropic Demo - off - press 'f' to switch");
                this.ts.setTexture(this.regTexture);
                this.rootNode.updateRenderState();
            } else {
                this.display.setTitle("Anisotropic Demo - on - press 'f' to switch");
                this.ts.setTexture(this.anisoTexture);
                this.rootNode.updateRenderState();
            }
            this.useAniso = !this.useAniso;
        }
    }

    protected void simpleInitGame() {
        this.display.setTitle("Anisotropic Demo - off - press 'f' to switch");
        KeyBindingManager.getKeyBindingManager().set("aniso", 33);
        this.cam.setLocation(new Vector3f(0.0f, 10.0f, 100.0f));
        this.cam.update();
        this.q = new Quad("Quad", 200.0f, 200.0f);
        this.q.setModelBound((BoundingVolume)new BoundingSphere());
        this.q.updateModelBound();
        this.q.setLocalRotation(new Quaternion(new float[]{1.5707964f, 0.0f, 0.0f}));
        this.q.setLightCombineMode(0);
        FloatBuffer floatBuffer = this.q.getTextureBuffer(0, 0);
        floatBuffer.clear();
        floatBuffer.put(0.0f).put(5.0f);
        floatBuffer.put(0.0f).put(0.0f);
        floatBuffer.put(5.0f).put(0.0f);
        floatBuffer.put(5.0f).put(5.0f);
        this.rootNode.attachChild((Spatial)this.q);
        this.ts = this.display.getRenderer().createTextureState();
        this.ts.setEnabled(true);
        this.regTexture = TextureManager.loadTexture((URL)TestAnisotropic.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg"), (int)6, (int)1);
        this.regTexture.setWrap(3);
        this.anisoTexture = TextureManager.loadTexture((URL)TestAnisotropic.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg"), (int)6, (int)1, (float)this.ts.getMaxAnisotropic(), (boolean)true);
        this.anisoTexture.setWrap(3);
        this.ts.setTexture(this.regTexture);
        this.rootNode.setRenderState((RenderState)this.ts);
        this.lightState.setTwoSidedLighting(true);
    }
}

