/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.BatchMesh;
import com.jme.scene.Spatial;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.LineBatch;
import com.jme.scene.batch.PointBatch;
import com.jme.scene.batch.QuadBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.state.CullState;
import com.jme.scene.state.RenderState;
import com.jme.util.geom.BufferUtils;

public class TestBatchMesh
extends SimpleGame {
    public static void main(String[] stringArray) {
        TestBatchMesh testBatchMesh = new TestBatchMesh();
        testBatchMesh.setDialogBehaviour(2);
        testBatchMesh.start();
    }

    protected void simpleInitGame() {
        this.display.setTitle("Test BatchMesh. Press T for wireframe view.");
        this.lightState.setEnabled(false);
        TriangleBatch triangleBatch = new TriangleBatch();
        triangleBatch.setMode(2);
        triangleBatch.setVertexBuffer(BufferUtils.createFloatBuffer((Vector3f[])this.getVerts(3, 0)));
        triangleBatch.setIndexBuffer(BufferUtils.createIntBuffer((int[])new int[]{0, 1, 2, 3, 4, 5}));
        TriangleBatch triangleBatch2 = new TriangleBatch();
        triangleBatch2.setMode(3);
        triangleBatch2.setVertexBuffer(BufferUtils.createFloatBuffer((Vector3f[])this.getVerts(-1, 0)));
        triangleBatch2.setIndexBuffer(BufferUtils.createIntBuffer((int[])new int[]{2, 0, 1, 3, 5, 4}));
        TriangleBatch triangleBatch3 = new TriangleBatch();
        triangleBatch3.setMode(1);
        triangleBatch3.setVertexBuffer(BufferUtils.createFloatBuffer((Vector3f[])this.getVerts(-5, 0)));
        triangleBatch3.setIndexBuffer(BufferUtils.createIntBuffer((int[])new int[]{0, 1, 2, 3, 5, 4}));
        PointBatch pointBatch = new PointBatch();
        pointBatch.setPointSize(10.0f);
        pointBatch.setVertexBuffer(BufferUtils.createFloatBuffer((Vector3f[])this.getVerts(-5, -5)));
        pointBatch.setColorBuffer(BufferUtils.createFloatBuffer((ColorRGBA[])new ColorRGBA[]{ColorRGBA.blue, ColorRGBA.orange, ColorRGBA.cyan, ColorRGBA.gray, ColorRGBA.green, ColorRGBA.magenta}));
        pointBatch.setIndexBuffer(BufferUtils.createIntBuffer((int[])new int[]{0, 1, 2, 3, 4, 5}));
        LineBatch lineBatch = new LineBatch();
        lineBatch.setMode(1);
        lineBatch.setVertexBuffer(BufferUtils.createFloatBuffer((Vector3f[])this.getVerts(-5, 5)));
        lineBatch.setIndexBuffer(BufferUtils.createIntBuffer((int[])new int[]{0, 1, 2, 3, 4, 5}));
        LineBatch lineBatch2 = new LineBatch();
        lineBatch2.setMode(0);
        lineBatch2.setVertexBuffer(BufferUtils.createFloatBuffer((Vector3f[])this.getVerts(-1, 5)));
        lineBatch2.setIndexBuffer(BufferUtils.createIntBuffer((int[])new int[]{0, 1, 2, 3, 4, 5}));
        LineBatch lineBatch3 = new LineBatch();
        lineBatch3.setMode(2);
        lineBatch3.setVertexBuffer(BufferUtils.createFloatBuffer((Vector3f[])this.getVerts(3, 5)));
        lineBatch3.setIndexBuffer(BufferUtils.createIntBuffer((int[])new int[]{0, 1, 2, 3, 4, 5}));
        QuadBatch quadBatch = new QuadBatch();
        quadBatch.setMode(1);
        quadBatch.setVertexBuffer(BufferUtils.createFloatBuffer((Vector3f[])this.getVerts(-1, -5)));
        quadBatch.setIndexBuffer(BufferUtils.createIntBuffer((int[])new int[]{0, 1, 3, 2}));
        QuadBatch quadBatch2 = new QuadBatch();
        quadBatch2.setMode(2);
        quadBatch2.setVertexBuffer(BufferUtils.createFloatBuffer((Vector3f[])this.getVerts(3, -5)));
        quadBatch2.setIndexBuffer(BufferUtils.createIntBuffer((int[])new int[]{0, 1, 2, 3, 4, 5}));
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(2);
        BatchMesh batchMesh = new BatchMesh("batches", new GeomBatch[]{triangleBatch, triangleBatch2, triangleBatch3, pointBatch, lineBatch, lineBatch2, lineBatch3, quadBatch, quadBatch2});
        batchMesh.setRenderState((RenderState)cullState);
        batchMesh.updateRenderState();
        this.rootNode.attachChild((Spatial)batchMesh);
    }

    Vector3f[] getVerts(int n, int n2) {
        Vector3f[] vector3fArray = new Vector3f[]{new Vector3f((float)(0 + n), (float)(1 + n2), 0.0f), new Vector3f((float)(0 + n), (float)(0 + n2), 0.0f), new Vector3f((float)(1 + n), (float)(1 + n2), 0.0f), new Vector3f((float)(1 + n), (float)(0 + n2), 0.0f), new Vector3f((float)(2 + n), (float)(1 + n2), 0.0f), new Vector3f((float)(2 + n), (float)(0 + n2), 0.0f)};
        return vector3fArray;
    }
}

