/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.light.Light;
import com.jme.light.LightNode;
import com.jme.light.PointLight;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.BezierMesh;
import com.jme.scene.BezierPatch;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import java.net.URL;

public class TestBezierMesh
extends SimpleGame {
    private BezierMesh bez;
    private PointLight pl;
    private LightNode lightNode;
    private Vector3f currentPos;
    private Vector3f newPos;

    public static void main(String[] stringArray) {
        TestBezierMesh testBezierMesh = new TestBezierMesh();
        testBezierMesh.setDialogBehaviour(2);
        testBezierMesh.start();
    }

    protected void simpleUpdate() {
        if ((int)this.currentPos.x == (int)this.newPos.x && (int)this.currentPos.y == (int)this.newPos.y && (int)this.currentPos.z == (int)this.newPos.z) {
            this.newPos.x = (float)Math.random() * 10.0f - 5.0f;
            this.newPos.y = (float)Math.random() * 10.0f - 5.0f;
            this.newPos.z = (float)Math.random() * 10.0f - 5.0f;
        }
        this.currentPos.x -= (this.currentPos.x - this.newPos.x) / (this.timer.getFrameRate() / 2.0f);
        this.currentPos.y -= (this.currentPos.y - this.newPos.y) / (this.timer.getFrameRate() / 2.0f);
        this.currentPos.z -= (this.currentPos.z - this.newPos.z) / (this.timer.getFrameRate() / 2.0f);
        this.lightNode.setLocalTranslation(this.currentPos);
    }

    protected void simpleInitGame() {
        this.display.setTitle("Bezier Mesh Test");
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 5.0f));
        this.cam.update();
        this.currentPos = new Vector3f();
        this.newPos = new Vector3f();
        BezierPatch bezierPatch = new BezierPatch();
        bezierPatch.setAnchor(0, 0, new Vector3f(-0.75f, -0.75f, -0.5f));
        bezierPatch.setAnchor(0, 1, new Vector3f(-0.25f, -0.75f, 0.0f));
        bezierPatch.setAnchor(0, 2, new Vector3f(0.25f, -0.75f, 0.5f));
        bezierPatch.setAnchor(0, 3, new Vector3f(0.75f, -0.75f, 0.5f));
        bezierPatch.setAnchor(1, 0, new Vector3f(-0.75f, -0.25f, -0.75f));
        bezierPatch.setAnchor(1, 1, new Vector3f(-0.25f, -0.25f, 0.5f));
        bezierPatch.setAnchor(1, 2, new Vector3f(0.25f, -0.25f, 0.5f));
        bezierPatch.setAnchor(1, 3, new Vector3f(0.75f, -0.25f, 0.75f));
        bezierPatch.setAnchor(2, 0, new Vector3f(-0.75f, 0.25f, -0.5f));
        bezierPatch.setAnchor(2, 1, new Vector3f(-0.25f, 0.25f, -0.5f));
        bezierPatch.setAnchor(2, 2, new Vector3f(0.25f, 0.25f, -0.5f));
        bezierPatch.setAnchor(2, 3, new Vector3f(0.75f, 0.25f, 0.0f));
        bezierPatch.setAnchor(3, 0, new Vector3f(-0.75f, 0.75f, -0.5f));
        bezierPatch.setAnchor(3, 1, new Vector3f(-0.25f, 0.75f, -1.0f));
        bezierPatch.setAnchor(3, 2, new Vector3f(0.25f, 0.75f, -1.0f));
        bezierPatch.setAnchor(3, 3, new Vector3f(0.75f, 0.75f, -0.5f));
        bezierPatch.setDetailLevel(64);
        this.bez = new BezierMesh("Bezier Mesh");
        this.bez.setPatch(bezierPatch);
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis((float)Math.PI, new Vector3f(0.0f, 0.0f, 1.0f));
        this.bez.setLocalRotation(quaternion);
        this.bez.setModelBound((BoundingVolume)new BoundingSphere());
        this.bez.updateModelBound();
        this.rootNode.attachChild((Spatial)this.bez);
        MaterialState materialState = this.display.getRenderer().createMaterialState();
        materialState.setEmissive(new ColorRGBA(0.1f, 0.1f, 0.1f, 1.0f));
        materialState.setShininess(128.0f);
        materialState.setEnabled(true);
        this.bez.setRenderState((RenderState)materialState);
        this.pl = new PointLight();
        this.pl.setAmbient(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        this.pl.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        this.pl.setSpecular(new ColorRGBA(0.2f, 0.2f, 0.2f, 1.0f));
        this.pl.setEnabled(true);
        this.lightState.detachAll();
        this.lightState.setTwoSidedLighting(true);
        this.lightNode = new LightNode("Light Node", this.lightState);
        this.lightNode.setLight((Light)this.pl);
        this.lightNode.setTarget((Spatial)this.bez);
        Vector3f vector3f = new Vector3f(-0.15f, -0.15f, -0.15f);
        Vector3f vector3f2 = new Vector3f(0.15f, 0.15f, 0.15f);
        Box box = new Box("box", vector3f, vector3f2);
        box.setLightCombineMode(0);
        box.setModelBound((BoundingVolume)new BoundingSphere());
        box.updateModelBound();
        this.lightNode.attachChild((Spatial)box);
        this.lightNode.setCullMode(3);
        this.rootNode.attachChild((Spatial)this.lightNode);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestBezierMesh.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1));
        this.bez.setRenderState((RenderState)textureState);
    }
}

