/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.input.NodeHandler;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.light.SpotLight;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.CameraNode;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Box;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.util.TextureManager;
import java.net.URL;

public class TestCameraNode
extends SimpleGame {
    private TriMesh t;
    private CameraNode camNode;
    private Camera cam;
    private Node root;

    public static void main(String[] stringArray) {
        TestCameraNode testCameraNode = new TestCameraNode();
        testCameraNode.setDialogBehaviour(2);
        testCameraNode.start();
    }

    public void addSpatial(Spatial spatial) {
        this.rootNode.attachChild(spatial);
        this.rootNode.updateGeometricState(0.0f, true);
        System.out.println(this.rootNode.getQuantity());
    }

    protected void simpleInitGame() {
        this.display.getRenderer().setCamera(this.cam);
        this.camNode = new CameraNode("Camera Node", this.cam);
        this.input = new NodeHandler((Spatial)this.camNode, 15.0f, 1.0f);
        Vector3f vector3f = new Vector3f(5.0f, 5.0f, 5.0f);
        Vector3f vector3f2 = new Vector3f(-5.0f, -5.0f, -5.0f);
        this.t = new Box("Box 1", vector3f2, vector3f);
        this.t.setModelBound((BoundingVolume)new BoundingSphere());
        this.t.updateModelBound();
        this.t.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        Box box = new Box("Box 2", vector3f2.divide(4.0f), vector3f.divide(4.0f));
        box.setLocalTranslation(new Vector3f(-5.0f, 0.0f, 10.0f));
        this.rootNode.attachChild((Spatial)this.t);
        this.root = new Node("Root Node");
        this.root.attachChild((Spatial)this.rootNode);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        SpotLight spotLight = new SpotLight();
        spotLight.setDiffuse(new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f));
        spotLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        spotLight.setDirection(new Vector3f(0.0f, 0.0f, 0.0f));
        spotLight.setLocation(new Vector3f(25.0f, 10.0f, 0.0f));
        spotLight.setAngle(15.0f);
        SpotLight spotLight2 = new SpotLight();
        spotLight2.setDiffuse(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        spotLight2.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        spotLight2.setDirection(new Vector3f(0.0f, 0.0f, 0.0f));
        spotLight2.setLocation(new Vector3f(-25.0f, 10.0f, 0.0f));
        spotLight2.setAngle(15.0f);
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        directionalLight.setSpecular(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        directionalLight.setDirection(new Vector3f(150.0f, 0.0f, 150.0f));
        LightState lightState = this.display.getRenderer().createLightState();
        lightState.attach((Light)spotLight);
        lightState.attach((Light)directionalLight);
        lightState.attach((Light)spotLight2);
        spotLight.setEnabled(true);
        spotLight2.setEnabled(true);
        directionalLight.setEnabled(true);
        this.rootNode.setRenderState((RenderState)zBufferState);
        this.camNode.setLocalTranslation(new Vector3f(0.0f, 0.0f, -75.0f));
        this.camNode.attachChild((Spatial)box);
        this.rootNode.attachChild((Spatial)this.camNode);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestCameraNode.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1));
        this.rootNode.setRenderState((RenderState)textureState);
    }

    protected void reinit() {
    }

    protected void cleanup() {
    }
}

