/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.animation.AnimationController;
import com.jme.animation.Bone;
import com.jme.animation.BoneAnimation;
import com.jme.animation.SkinNode;
import com.jme.app.SimpleGame;
import com.jme.image.Texture;
import com.jme.image.util.ColorMipMapGenerator;
import com.jme.input.FirstPersonHandler;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.TextureRenderer;
import com.jme.scene.Controller;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.SceneElement;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.JmeException;
import com.jmex.model.collada.ColladaImporter;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;

public class TestMipMaps
extends SimpleGame {
    private TextureRenderer tRenderer;
    private Node monitorNode;
    private Texture fakeTex;
    private float lastRend = 1.0f;
    private float throttle = 0.033333335f;
    private SkinNode sn;

    public static void main(String[] stringArray) {
        TestMipMaps testMipMaps = new TestMipMaps();
        testMipMaps.setDialogBehaviour(2);
        testMipMaps.start();
    }

    protected void simpleInitGame() {
        this.setupModel();
        this.setupMonitor();
    }

    protected void cleanup() {
        super.cleanup();
        this.tRenderer.cleanup();
    }

    protected void simpleRender() {
        this.lastRend += this.tpf;
        if (this.lastRend > this.throttle) {
            this.tRenderer.render((Spatial)this.sn, this.fakeTex);
            this.lastRend = 0.0f;
        }
    }

    private void setupMonitor() {
        this.tRenderer = this.display.createTextureRenderer(256, 256, 2);
        this.tRenderer.getCamera().setAxes(new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 1.0f, 0.0f));
        this.tRenderer.getCamera().setLocation(new Vector3f(0.0f, -100.0f, 20.0f));
        this.monitorNode = new Node("Monitor Node");
        this.monitorNode.setRenderQueueMode(4);
        Quad quad = new Quad("Monitor");
        quad.initialize(100.0f, 100.0f);
        quad.setLocalTranslation(new Vector3f(110.0f, 110.0f, 0.0f));
        quad.getBatch(0).setZOrder(1);
        this.monitorNode.attachChild((Spatial)quad);
        Quad quad2 = new Quad("Monitor Back");
        quad2.initialize(110.0f, 110.0f);
        quad2.setLocalTranslation(new Vector3f(110.0f, 110.0f, 0.0f));
        quad2.getBatch(0).setZOrder(2);
        this.monitorNode.attachChild((Spatial)quad2);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(false);
        this.monitorNode.setRenderState((RenderState)zBufferState);
        this.tRenderer.setBackgroundColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        this.fakeTex = new Texture();
        this.fakeTex.setRTTSource(1);
        this.tRenderer.setupTexture(this.fakeTex);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(this.fakeTex);
        textureState.setEnabled(true);
        quad.setRenderState((RenderState)textureState);
        this.monitorNode.setLightCombineMode(0);
        this.rootNode.attachChild((Spatial)this.monitorNode);
    }

    private void setupModel() {
        this.cam.setAxes(new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 1.0f, 0.0f));
        this.cam.setLocation(new Vector3f(0.0f, -100.0f, 20.0f));
        this.input = new FirstPersonHandler(this.cam, 80.0f, 1.0f);
        URL uRL = TestMipMaps.class.getClassLoader().getResource("jmetest/data/model/collada/");
        InputStream inputStream = TestMipMaps.class.getClassLoader().getResourceAsStream("jmetest/data/model/collada/man.dae");
        InputStream inputStream2 = TestMipMaps.class.getClassLoader().getResourceAsStream("jmetest/data/model/collada/man_walk.dae");
        if (inputStream == null) {
            System.out.println("Unable to find file, did you include jme-test.jar in classpath?");
            System.exit(0);
        }
        ColladaImporter.load((InputStream)inputStream, (URL)uRL, (String)"model");
        this.sn = ColladaImporter.getSkinNode((String)((String)ColladaImporter.getSkinNodeNames().get(0)));
        Bone bone = ColladaImporter.getSkeleton((String)((String)ColladaImporter.getSkeletonNames().get(0)));
        ColladaImporter.cleanUp();
        ColladaImporter.load((InputStream)inputStream2, (URL)uRL, (String)"anim");
        ArrayList arrayList = ColladaImporter.getControllerNames();
        System.out.println("Number of animations: " + arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            System.out.println((String)arrayList.get(i));
        }
        BoneAnimation boneAnimation = ColladaImporter.getAnimationController((String)((String)arrayList.get(0)));
        AnimationController animationController = new AnimationController();
        animationController.addAnimation(boneAnimation);
        animationController.setRepeatType(2);
        animationController.setActive(true);
        animationController.setActiveAnimation(boneAnimation);
        bone.addController((Controller)animationController);
        this.stripTexturesAndMaterials((SceneElement)this.sn);
        Texture texture = new Texture();
        texture.setFilter(1);
        texture.setMipmapState(5);
        try {
            texture.setImage(ColorMipMapGenerator.generateColorMipMap((int)512, (ColorRGBA[])new ColorRGBA[]{ColorRGBA.blue, ColorRGBA.green, ColorRGBA.white}, (ColorRGBA)ColorRGBA.red));
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
        }
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(texture);
        this.sn.setRenderState((RenderState)textureState);
        this.rootNode.attachChild((Spatial)this.sn);
        this.rootNode.attachChild((Spatial)bone);
        ColladaImporter.cleanUp();
        this.lightState.detachAll();
        this.lightState.setEnabled(false);
    }

    private void stripTexturesAndMaterials(SceneElement sceneElement) {
        block3: {
            block2: {
                sceneElement.clearRenderState(6);
                sceneElement.clearRenderState(4);
                if (!(sceneElement instanceof Node)) break block2;
                Node node = (Node)sceneElement;
                for (Spatial spatial : node.getChildren()) {
                    this.stripTexturesAndMaterials((SceneElement)spatial);
                }
                break block3;
            }
            if (!(sceneElement instanceof Geometry)) break block3;
            Geometry geometry = (Geometry)sceneElement;
            for (int i = 0; i < geometry.getBatchCount(); ++i) {
                this.stripTexturesAndMaterials((SceneElement)geometry.getBatch(i));
            }
        }
    }
}

