/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.TextureRenderer;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import java.net.URL;

public class TestMultipleTexRender
extends SimpleGame {
    private Box realBox;
    private Box realBox2;
    private Box monkeyBox;
    private Node fakeScene;
    private Quaternion rotQuat = new Quaternion();
    private Quaternion rotMBQuat = new Quaternion();
    private Vector3f axis = new Vector3f(1.0f, 1.0f, 0.5f);
    private float angle = 0.0f;
    private float angle2 = 0.0f;
    private TextureRenderer tRenderer;
    private Texture fakeTex;
    private Texture fakeTex2;
    private float lastRend = 1.0f;

    public static void main(String[] stringArray) {
        TestMultipleTexRender testMultipleTexRender = new TestMultipleTexRender();
        testMultipleTexRender.setDialogBehaviour(2);
        testMultipleTexRender.start();
    }

    protected void cleanup() {
        this.tRenderer.cleanup();
        super.cleanup();
    }

    protected void simpleUpdate() {
        if (this.tpf < 1.0f) {
            this.angle += this.tpf * -0.25f;
            this.angle2 += this.tpf * 1.0f;
            if (this.angle < 0.0f) {
                this.angle = 359.75f;
            }
            if (this.angle2 >= 360.0f) {
                this.angle2 = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle, this.axis);
        this.rotMBQuat.fromAngleAxis(this.angle2, this.axis);
        this.realBox.setLocalRotation(this.rotQuat);
        this.monkeyBox.setLocalRotation(this.rotMBQuat);
        this.fakeScene.updateGeometricState(0.0f, true);
    }

    protected void simpleRender() {
        this.lastRend += this.tpf;
        if (this.lastRend > 0.03f) {
            this.tRenderer.render((Spatial)this.fakeScene, this.fakeTex);
            this.tRenderer.render((Spatial)this.fakeScene, this.fakeTex2);
            this.lastRend = 0.0f;
        }
    }

    protected void simpleInitGame() {
        this.display.setTitle("Render to Texture");
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 25.0f));
        this.cam.update();
        Vector3f vector3f = new Vector3f(5.0f, 5.0f, 5.0f);
        Vector3f vector3f2 = new Vector3f(-5.0f, -5.0f, -5.0f);
        this.realBox = new Box("Box", vector3f2, vector3f);
        this.realBox.setModelBound((BoundingVolume)new BoundingSphere());
        this.realBox.updateModelBound();
        this.realBox.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        this.rootNode.attachChild((Spatial)this.realBox);
        this.realBox2 = new Box("Box", vector3f2, vector3f);
        this.realBox2.setModelBound((BoundingVolume)new BoundingSphere());
        this.realBox2.updateModelBound();
        this.realBox2.setLocalTranslation(new Vector3f(10.0f, 0.0f, 0.0f));
        this.rootNode.attachChild((Spatial)this.realBox2);
        vector3f2.multLocal(3.0f);
        vector3f.multLocal(3.0f);
        this.monkeyBox = new Box("Fake Monkey Box", vector3f2, vector3f);
        this.monkeyBox.setModelBound((BoundingVolume)new BoundingSphere());
        this.monkeyBox.updateModelBound();
        this.monkeyBox.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        this.fakeScene = new Node("Fake node");
        this.fakeScene.setRenderQueueMode(1);
        this.fakeScene.attachChild((Spatial)this.monkeyBox);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        this.fakeScene.setRenderState((RenderState)zBufferState);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        Texture texture = TextureManager.loadTexture((URL)TestMultipleTexRender.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1);
        textureState.setTexture(texture);
        this.fakeScene.setRenderState((RenderState)textureState);
        this.tRenderer = this.display.createTextureRenderer(512, 512, 2);
        this.tRenderer.setBackgroundColor(new ColorRGBA(0.667f, 0.667f, 0.851f, 1.0f));
        this.fakeTex = new Texture();
        this.fakeTex.setWrap(0);
        this.fakeTex2 = new Texture();
        this.fakeTex2.setWrap(0);
        if (this.tRenderer.isSupported()) {
            this.tRenderer.setupTexture(this.fakeTex);
            this.tRenderer.setupTexture(this.fakeTex2);
            this.tRenderer.getCamera().setLocation(new Vector3f(0.0f, 0.0f, 75.0f));
        } else {
            LoggingSystem.getLogger().severe("Render to texture not supported!");
        }
        textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(this.fakeTex, 0);
        Texture texture2 = TextureManager.loadTexture((URL)TestMultipleTexRender.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg"), (int)6, (int)1);
        textureState.setTexture(texture2, 1);
        this.realBox.setRenderState((RenderState)textureState);
        textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(this.fakeTex2, 0);
        texture2 = TextureManager.loadTexture((URL)TestMultipleTexRender.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg"), (int)6, (int)1);
        textureState.setTexture(texture2, 1);
        this.realBox2.setRenderState((RenderState)textureState);
        this.realBox.copyTextureCoords(0, 0, 1);
        this.realBox2.copyTextureCoords(0, 0, 1);
        this.fakeScene.updateGeometricState(0.0f, true);
        this.fakeScene.updateRenderState();
    }
}

