/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimplePassGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.pass.Pass;
import com.jme.renderer.pass.RenderPass;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Box;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import java.net.URL;

public class TestMultitexturePass
extends SimplePassGame {
    private TriMesh t;
    private Quaternion rotQuat;
    private float angle = 0.0f;
    private Vector3f axis;

    public static void main(String[] stringArray) {
        TestMultitexturePass testMultitexturePass = new TestMultitexturePass();
        testMultitexturePass.setDialogBehaviour(2);
        testMultitexturePass.start();
    }

    protected void simpleUpdate() {
        if (this.timer.getTimePerFrame() < 1.0f) {
            this.angle += this.timer.getTimePerFrame() * 25.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle * ((float)Math.PI / 180), this.axis);
        this.t.setLocalRotation(this.rotQuat);
    }

    protected void simpleInitGame() {
        this.rotQuat = new Quaternion();
        this.axis = new Vector3f(1.0f, 1.0f, 0.5f);
        this.display.setTitle("Multitexturing - Multiple Passes");
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 40.0f));
        this.cam.update();
        Vector3f vector3f = new Vector3f(5.0f, 5.0f, 5.0f);
        Vector3f vector3f2 = new Vector3f(-5.0f, -5.0f, -5.0f);
        this.t = new Box("Box", vector3f2, vector3f);
        this.t.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        this.t.setModelBound((BoundingVolume)new BoundingSphere());
        this.t.updateModelBound();
        this.t.copyTextureCoords(0, 0, 1);
        this.rootNode.attachChild((Spatial)this.t);
        TextureState textureState = this.display.getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((URL)TestMultitexturePass.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg"), (int)2, (int)1);
        textureState.setTexture(texture);
        TextureState textureState2 = this.display.getRenderer().createTextureState();
        Texture texture2 = TextureManager.loadTexture((URL)TestMultitexturePass.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1);
        texture2.setWrap(3);
        textureState2.setTexture(texture2);
        textureState2.setTextureCoordinateOffset(1);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(2);
        alphaState.setDstFunction(2);
        RenderPass renderPass = new RenderPass();
        renderPass.setPassState((RenderState)textureState);
        renderPass.add((Spatial)this.t);
        RenderPass renderPass2 = new RenderPass();
        renderPass2.setPassState((RenderState)textureState2);
        renderPass2.setPassState((RenderState)alphaState);
        renderPass2.setZFactor(0.0f);
        renderPass2.setZOffset(-5.0f);
        renderPass2.add((Spatial)this.t);
        RenderPass renderPass3 = new RenderPass();
        renderPass3.add((Spatial)this.fpsNode);
        this.pManager.add((Pass)renderPass);
        this.pManager.add((Pass)renderPass2);
        this.pManager.add((Pass)renderPass3);
    }
}

