/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimplePassGame;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.pass.OutlinePass;
import com.jme.renderer.pass.Pass;
import com.jme.scene.Node;
import com.jme.scene.SharedNode;
import com.jme.scene.Spatial;
import com.jme.scene.state.CullState;
import com.jme.scene.state.RenderState;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.model.XMLparser.Converters.Md2ToJme;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class TestOutlinePass
extends SimplePassGame {
    private Node model = null;

    protected void simpleInitGame() {
        Md2ToJme md2ToJme;
        this.display.setTitle("Outline render pass test");
        this.display.getRenderer().setBackgroundColor(new ColorRGBA(0.5f, 0.7f, 1.0f, 1.0f));
        this.cam.setFrustumPerspective(55.0f, (float)this.display.getWidth() / (float)this.display.getHeight(), 1.0f, 1000.0f);
        this.cam.setLocation(new Vector3f(50.0f, 0.0f, 0.0f));
        this.cam.lookAt(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f));
        PointLight pointLight = new PointLight();
        pointLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        pointLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        pointLight.setLocation(new Vector3f(0.0f, 30.0f, 0.0f));
        pointLight.setEnabled(true);
        this.lightState.attach((Light)pointLight);
        Node node = new Node("outlined");
        OutlinePass outlinePass = new OutlinePass();
        outlinePass.add((Spatial)node);
        outlinePass.setEnabled(true);
        this.pManager.add((Pass)outlinePass);
        this.rootNode.attachChild((Spatial)node);
        try {
            md2ToJme = new Md2ToJme();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            md2ToJme.convert(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("jmetest/data/model/drfreak.md2"), (OutputStream)byteArrayOutputStream);
            this.model = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            CullState cullState = this.display.getRenderer().createCullState();
            cullState.setCullMode(1);
            cullState.setEnabled(true);
            this.model.setRenderState((RenderState)cullState);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.model != null) {
            md2ToJme = new SharedNode("outlined.model", this.model);
            node.attachChild((Spatial)md2ToJme);
        }
        this.rootNode.updateGeometricState(0.0f, true);
        this.rootNode.updateRenderState();
    }

    public static void main(String[] stringArray) {
        TestOutlinePass testOutlinePass = new TestOutlinePass();
        testOutlinePass.setDialogBehaviour(2);
        testOutlinePass.start();
    }
}

