/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.math.FastMath;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.shape.PQTorus;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import java.net.URL;
import java.util.logging.Level;
import jmetest.renderer.TestBoxColor;
import org.lwjgl.input.Keyboard;

public class TestPQTorus
extends SimpleGame {
    private Quaternion rotQuat = new Quaternion();
    private float angle = 0.0f;
    private Vector3f axis = new Vector3f(1.0f, 1.0f, 0.0f);
    private PQTorus t;
    private Text pqText;
    private float p = 1.0f;
    private float q = 0.0f;
    private boolean anim = false;
    private float targetP = this.p;
    private float targetQ = this.q;

    public static void main(String[] stringArray) {
        LoggingSystem.getLogger().setLevel(Level.WARNING);
        TestPQTorus testPQTorus = new TestPQTorus();
        testPQTorus.setDialogBehaviour(2);
        testPQTorus.start();
    }

    protected void simpleUpdate() {
        this.pqText.print("P: " + this.p + "  Q: " + this.q);
        if (!this.anim) {
            if (Keyboard.isKeyDown((int)25)) {
                this.targetP = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? (this.targetP -= 1.0f) : (this.targetP += 1.0f);
                this.anim = true;
            }
            if (Keyboard.isKeyDown((int)16)) {
                this.targetQ = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? (this.targetQ -= 1.0f) : (this.targetQ += 1.0f);
                this.anim = true;
            }
        } else if (this.targetP != this.p || this.targetQ != this.q) {
            this.p = FastMath.abs((float)(this.targetP - this.p)) < 0.01f ? this.targetP : (this.p < this.targetP ? (this.p += 0.01f) : (this.p -= 0.01f));
            this.q = FastMath.abs((float)(this.targetQ - this.q)) < 0.01f ? this.targetQ : (this.q < this.targetQ ? (this.q += 0.01f) : (this.q -= 0.01f));
            this.generatePQTorus();
            this.rootNode.updateRenderState();
        } else {
            this.anim = false;
        }
        if (this.timer.getTimePerFrame() < 1.0f) {
            this.angle += this.timer.getTimePerFrame() * 25.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle * ((float)Math.PI / 180), this.axis);
        this.rootNode.setLocalRotation(this.rotQuat);
    }

    protected void simpleInitGame() {
        this.display.setTitle("PQ Torus Test");
        this.pqText = new Text("PQ label", "");
        this.pqText.setLocalTranslation(new Vector3f(0.0f, 20.0f, 0.0f));
        this.pqText.setCullMode(3);
        this.fpsNode.attachChild((Spatial)this.pqText);
        this.generatePQTorus();
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestBoxColor.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1));
        this.rootNode.setRenderState((RenderState)textureState);
    }

    private void generatePQTorus() {
        this.rootNode.detachChild((Spatial)this.t);
        this.t = new PQTorus("torus", this.p, this.q, 2.0f, 1.0f, 128, 16);
        this.rootNode.attachChild((Spatial)this.t);
    }
}

