/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.TextureRenderer;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import java.net.URL;
import java.util.logging.Level;
import jmetest.renderer.TestBoxColor;

public class TestRTTSideBySide
extends SimpleGame {
    private Quaternion rotQuat = new Quaternion();
    private float angle = 0.0f;
    private Vector3f axis = new Vector3f(1.0f, 1.0f, 0.0f);
    private Sphere s;
    private Quad q;
    private TextureRenderer tRenderer;
    private Texture fakeTex;

    public static void main(String[] stringArray) {
        LoggingSystem.getLogger().setLevel(Level.OFF);
        TestRTTSideBySide testRTTSideBySide = new TestRTTSideBySide();
        testRTTSideBySide.setDialogBehaviour(2);
        testRTTSideBySide.start();
    }

    protected void cleanup() {
        super.cleanup();
        this.tRenderer.cleanup();
    }

    protected void simpleUpdate() {
        if (this.tpf < 1.0f) {
            this.angle += this.tpf * 1.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle, this.axis);
        this.s.setLocalRotation(this.rotQuat);
    }

    protected void simpleRender() {
        this.tRenderer.render((Spatial)this.s, this.fakeTex);
    }

    protected void simpleInitGame() {
        this.display.setTitle("jME - RTT Side By Side");
        this.tRenderer = this.display.createTextureRenderer(512, 512, 2);
        this.s = new Sphere("Sphere", 25, 25, 5.0f);
        this.s.setLocalTranslation(new Vector3f(-10.0f, 0.0f, 0.0f));
        this.s.setModelBound((BoundingVolume)new BoundingBox());
        this.s.updateModelBound();
        this.rootNode.attachChild((Spatial)this.s);
        this.q = new Quad("Quad", 15.0f, 13.0f);
        this.q.setLocalTranslation(new Vector3f(10.0f, 0.0f, 0.0f));
        this.q.setModelBound((BoundingVolume)new BoundingBox());
        this.q.updateModelBound();
        this.q.setLightCombineMode(0);
        this.rootNode.attachChild((Spatial)this.q);
        this.tRenderer.setBackgroundColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        this.fakeTex = new Texture();
        this.tRenderer.setupTexture(this.fakeTex);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(this.fakeTex);
        textureState.setEnabled(true);
        this.tRenderer.getCamera().setLocation(new Vector3f(-10.0f, 0.0f, 15.0f));
        this.q.setRenderState((RenderState)textureState);
        TextureState textureState2 = this.display.getRenderer().createTextureState();
        textureState2.setEnabled(true);
        textureState2.setTexture(TextureManager.loadTexture((URL)TestBoxColor.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1));
        this.rootNode.setRenderState((RenderState)textureState2);
    }
}

