/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.input.KeyBindingManager;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import java.net.URL;
import java.util.logging.Level;
import jmetest.renderer.TestBoxColor;

public class TestRecreateWindow
extends SimpleGame {
    private Quaternion rotQuat = new Quaternion();
    private float angle = 0.0f;
    private Vector3f axis = new Vector3f(1.0f, 1.0f, 0.0f);
    private Sphere s;
    private int resolution = -1;
    private int width;
    private int height;
    private int depth;
    private int freq;
    private boolean fs;
    private boolean changeScreen;
    private Text rez;

    public static void main(String[] stringArray) {
        LoggingSystem.getLogger().setLevel(Level.OFF);
        TestRecreateWindow testRecreateWindow = new TestRecreateWindow();
        testRecreateWindow.setDialogBehaviour(2);
        testRecreateWindow.start();
    }

    protected void simpleUpdate() {
        if (this.tpf < 1.0f) {
            this.angle += this.tpf * 1.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle, this.axis);
        this.s.setLocalRotation(this.rotQuat);
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("full_screen", false)) {
            this.changeScreen = true;
            boolean bl = this.fs = !this.fs;
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("resolution", false)) {
            this.changeScreen = true;
            ++this.resolution;
            if (this.resolution > 2) {
                this.resolution = 0;
            }
            switch (this.resolution) {
                case 0: {
                    this.width = 640;
                    this.height = 480;
                    break;
                }
                case 1: {
                    this.width = 800;
                    this.height = 600;
                    break;
                }
                case 2: {
                    this.width = 1024;
                    this.height = 768;
                }
            }
        }
        if (this.changeScreen) {
            this.changeScreen = false;
            this.updateRezText();
            this.display.recreateWindow(this.width, this.height, this.depth, this.freq, this.fs);
        }
    }

    private void updateRezText() {
        String string = this.width + " x " + this.height + "  " + this.depth + "bpp  " + this.freq + "Hz " + (this.fs ? "(full screen)" : "(windowed)");
        this.rez.print(string);
    }

    protected void simpleInitGame() {
        this.display.setTitle("Recreate Window Demo");
        KeyBindingManager.getKeyBindingManager().set("full_screen", 33);
        KeyBindingManager.getKeyBindingManager().set("resolution", 14);
        this.width = this.display.getWidth();
        this.height = this.display.getHeight();
        this.freq = this.display.getFrequency();
        this.depth = this.display.getBitDepth();
        this.fs = this.display.isFullScreen();
        this.s = new Sphere("Sphere", 63, 50, 25.0f);
        this.s.setLocalTranslation(new Vector3f(0.0f, 0.0f, -40.0f));
        this.s.setModelBound((BoundingVolume)new BoundingBox());
        this.s.updateModelBound();
        this.rootNode.attachChild((Spatial)this.s);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestBoxColor.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1));
        this.rootNode.setRenderState((RenderState)textureState);
        this.rez = new Text("rez", "rez");
        this.rez.setLocalTranslation(new Vector3f(0.0f, 20.0f, 0.0f));
        this.updateRezText();
        this.fpsNode.attachChild((Spatial)this.rez);
    }
}

