/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.input.KeyBindingManager;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Quad;
import com.jme.scene.shape.Torus;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.util.TextureManager;
import java.net.URL;

public class TestRenderQueue
extends SimpleGame {
    private boolean useQueue = false;
    protected Node opaques;
    protected Node transps;
    protected Node orthos;

    public static void main(String[] stringArray) {
        TestRenderQueue testRenderQueue = new TestRenderQueue();
        testRenderQueue.setDialogBehaviour(2);
        testRenderQueue.start();
    }

    protected void simpleUpdate() {
        boolean bl = false;
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("queue", false)) {
            if (this.useQueue) {
                this.transps.setRenderQueueMode(1);
                this.opaques.setRenderQueueMode(1);
                this.orthos.setRenderQueueMode(1);
            } else {
                this.transps.setRenderQueueMode(3);
                this.opaques.setRenderQueueMode(2);
                this.orthos.setRenderQueueMode(4);
            }
            this.useQueue = !this.useQueue;
            bl = true;
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("trans", false)) {
            this.display.getRenderer().getQueue().setTwoPassTransparency(!this.display.getRenderer().getQueue().isTwoPassTransparency());
            bl = true;
        }
        if (bl) {
            this.display.setTitle("Test Render Queue - " + this.useQueue + " - hit 'Q' to toggle Queue mode - '2' Two Pass: - " + this.display.getRenderer().getQueue().isTwoPassTransparency());
        }
    }

    protected void simpleRender() {
        Renderer renderer = this.display.getRenderer();
        if (!this.useQueue) {
            renderer.setOrtho();
            renderer.draw((Spatial)this.orthos);
            renderer.unsetOrtho();
        } else {
            renderer.draw((Spatial)this.orthos);
        }
        renderer.draw((Spatial)this.transps);
        renderer.draw((Spatial)this.opaques);
    }

    protected void simpleInitGame() {
        this.display.setTitle("Test Render Queue - false - hit 'Q' to toggle Queue mode - '2' Two Pass: - true");
        KeyBindingManager.getKeyBindingManager().set("queue", 16);
        KeyBindingManager.getKeyBindingManager().set("trans", 3);
        this.cam.setLocation(new Vector3f(10.0f, 0.0f, 50.0f));
        this.cam.update();
        Vector3f vector3f = new Vector3f(5.0f, 5.0f, 5.0f);
        Vector3f vector3f2 = new Vector3f(-5.0f, -5.0f, -5.0f);
        this.opaques = new Node("Opaques");
        this.transps = new Node("Transps");
        this.orthos = new Node("Orthos");
        this.transps.setRenderQueueMode(1);
        this.opaques.setRenderQueueMode(1);
        this.orthos.setRenderQueueMode(1);
        this.rootNode.attachChild((Spatial)this.orthos);
        this.rootNode.attachChild((Spatial)this.transps);
        this.rootNode.attachChild((Spatial)this.opaques);
        Box box = new Box("Box", vector3f2, vector3f);
        box.setModelBound((BoundingVolume)new BoundingBox());
        box.updateModelBound();
        box.setLocalTranslation(new Vector3f(0.0f, 0.0f, -15.0f));
        this.opaques.attachChild((Spatial)box);
        Box box2 = new Box("Box", vector3f2, vector3f);
        box2.setModelBound((BoundingVolume)new BoundingBox());
        box2.updateModelBound();
        box2.setLocalTranslation(new Vector3f(0.0f, 0.0f, -30.0f));
        this.opaques.attachChild((Spatial)box2);
        Box box3 = new Box("Box", vector3f2, vector3f);
        box3.setModelBound((BoundingVolume)new BoundingBox());
        box3.updateModelBound();
        box3.setLocalTranslation(new Vector3f(0.0f, -15.0f, -15.0f));
        this.opaques.attachChild((Spatial)box3);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestRenderQueue.class.getClassLoader().getResource("jmetest/data/images/Monkey.tga"), (int)6, (int)1));
        this.opaques.setRenderState((RenderState)textureState);
        LightState lightState = this.display.getRenderer().createLightState();
        lightState.setEnabled(true);
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setEnabled(true);
        directionalLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight.setDirection(new Vector3f(-1.0f, -1.0f, -1.0f));
        lightState.attach((Light)directionalLight);
        DirectionalLight directionalLight2 = new DirectionalLight();
        directionalLight2.setEnabled(true);
        directionalLight2.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight2.setDirection(new Vector3f(1.0f, 1.0f, 1.0f));
        lightState.attach((Light)directionalLight2);
        lightState.setTwoSidedLighting(false);
        this.transps.setRenderState((RenderState)lightState);
        this.transps.setLightCombineMode(5);
        Box box4 = new Box("TBox Blue", vector3f2, vector3f);
        box4.setModelBound((BoundingVolume)new BoundingBox());
        box4.updateModelBound();
        box4.setLocalTranslation(new Vector3f(0.0f, 15.0f, 15.0f));
        this.transps.attachChild((Spatial)box4);
        MaterialState materialState = this.display.getRenderer().createMaterialState();
        materialState.setEnabled(true);
        materialState.setDiffuse(new ColorRGBA(0.0f, 0.0f, 1.0f, 0.75f));
        materialState.setShininess(128.0f);
        box4.setRenderState((RenderState)materialState);
        Torus torus = new Torus("TBox Green", 20, 20, 3.0f, 6.0f);
        torus.setModelBound((BoundingVolume)new BoundingBox());
        torus.updateModelBound();
        torus.setLocalTranslation(new Vector3f(0.0f, 0.0f, 30.0f));
        this.transps.attachChild((Spatial)torus);
        MaterialState materialState2 = this.display.getRenderer().createMaterialState();
        materialState2.setEnabled(true);
        materialState2.setDiffuse(new ColorRGBA(0.0f, 1.0f, 0.0f, 0.75f));
        materialState2.setShininess(128.0f);
        torus.setRenderState((RenderState)materialState2);
        Box box5 = new Box("TBox Red", vector3f2, vector3f);
        box5.setModelBound((BoundingVolume)new BoundingBox());
        box5.updateModelBound();
        box5.setLocalTranslation(new Vector3f(0.0f, 0.0f, 15.0f));
        this.transps.attachChild((Spatial)box5);
        MaterialState materialState3 = this.display.getRenderer().createMaterialState();
        materialState3.setEnabled(true);
        materialState3.setDiffuse(new ColorRGBA(1.0f, 0.0f, 0.0f, 0.5f));
        materialState3.setShininess(128.0f);
        box5.setRenderState((RenderState)materialState3);
        Box box6 = new Box("TBox Blue2", new Vector3f(-4.5f, -4.5f, -4.5f), new Vector3f(4.5f, 4.5f, 4.5f));
        box6.setModelBound((BoundingVolume)new BoundingBox());
        box6.updateModelBound();
        box6.setLocalTranslation(new Vector3f(0.0f, 4.0f, 17.0f));
        this.transps.attachChild((Spatial)box6);
        MaterialState materialState4 = this.display.getRenderer().createMaterialState();
        materialState4.setEnabled(true);
        materialState4.setDiffuse(new ColorRGBA(0.0f, 0.0f, 1.0f, 0.75f));
        materialState4.setShininess(128.0f);
        box6.setRenderState((RenderState)materialState4);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setEnabled(true);
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        this.transps.setRenderState((RenderState)alphaState);
        Vector2f vector2f = new Vector2f((float)(this.display.getWidth() >> 1), (float)(this.display.getWidth() >> 1));
        Quad quad = new Quad("Ortho Q1", 40.0f, 40.0f);
        quad.setLocalTranslation(new Vector3f(100.0f + vector2f.x, 100.0f + vector2f.y, 0.0f));
        quad.setZOrder(1);
        quad.setDefaultColor(ColorRGBA.white);
        quad.setLightCombineMode(0);
        this.orthos.attachChild((Spatial)quad);
        Quad quad2 = new Quad("Ortho Q2", 100.0f, 100.0f);
        quad2.setLocalTranslation(new Vector3f(60.0f + vector2f.x, 60.0f + vector2f.y, 0.0f));
        quad2.setZOrder(5);
        quad2.setDefaultColor(ColorRGBA.red);
        quad2.setLightCombineMode(0);
        this.orthos.attachChild((Spatial)quad2);
        Quad quad3 = new Quad("Ortho Q3", 120.0f, 60.0f);
        quad3.setLocalTranslation(new Vector3f(-20.0f + vector2f.x, -150.0f + vector2f.y, 0.0f));
        quad3.setZOrder(2);
        quad3.setDefaultColor(ColorRGBA.blue);
        quad3.setLightCombineMode(0);
        this.orthos.attachChild((Spatial)quad3);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setWritable(false);
        zBufferState.setEnabled(false);
        this.orthos.setRenderState((RenderState)zBufferState);
        this.orthos.setRenderState(Renderer.defaultStateList[3]);
        this.rootNode.setCullMode(2);
        this.opaques.setCullMode(3);
        this.transps.setCullMode(3);
        this.orthos.setCullMode(3);
    }
}

