/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimplePassGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.ChaseCamera;
import com.jme.input.KeyBindingManager;
import com.jme.input.ThirdPersonHandler;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.pass.Pass;
import com.jme.renderer.pass.RenderPass;
import com.jme.renderer.pass.ShadowedRenderPass;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.VBOInfo;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.PQTorus;
import com.jme.scene.state.CullState;
import com.jme.scene.state.FogState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import com.jmex.terrain.TerrainPage;
import com.jmex.terrain.util.AbstractHeightMap;
import com.jmex.terrain.util.FaultFractalHeightMap;
import com.jmex.terrain.util.ProceduralTextureGenerator;
import java.awt.Image;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import jmetest.renderer.ShadowTweaker;

public class TestShadowPass
extends SimplePassGame {
    private Node m_character;
    private Node occluders;
    private ChaseCamera chaser;
    private TerrainPage page;
    private FogState fs;
    private Vector3f normal = new Vector3f();
    private static ShadowedRenderPass sPass = new ShadowedRenderPass();
    private static final boolean debug = true;

    public static void main(String[] stringArray) {
        LoggingSystem.getLogger().setLevel(Level.WARNING);
        TestShadowPass testShadowPass = new TestShadowPass();
        new ShadowTweaker(sPass).setVisible(true);
        testShadowPass.setDialogBehaviour(2);
        testShadowPass.start();
    }

    TestShadowPass() {
        this.stencilBits = 4;
    }

    protected void simpleInitGame() {
        this.display.setTitle("jME - Shadow Volume Test : X - enable/disable shadows");
        this.display.getRenderer().setBackgroundColor(ColorRGBA.gray);
        this.setupCharacter();
        this.setupTerrain();
        this.setupChaseCamera();
        this.setupInput();
        this.setupOccluders();
        this.rootNode.setRenderQueueMode(2);
        KeyBindingManager.getKeyBindingManager().set("toggle_shadows", 45);
        sPass.add((Spatial)this.rootNode);
        sPass.addOccluder((Spatial)this.m_character);
        sPass.addOccluder((Spatial)this.occluders);
        sPass.setRenderShadows(true);
        sPass.setLightingMethod(0);
        this.pManager.add((Pass)sPass);
        RenderPass renderPass = new RenderPass();
        renderPass.add((Spatial)this.fpsNode);
        this.pManager.add((Pass)renderPass);
    }

    protected void simpleUpdate() {
        float f;
        this.chaser.update(this.tpf);
        float f2 = this.page.getHeight(this.m_character.getLocalTranslation()) + ((BoundingBox)this.m_character.getWorldBound()).yExtent;
        if (!Float.isInfinite(f2) && !Float.isNaN(f2)) {
            this.m_character.getLocalTranslation().y = f2;
        }
        if (!Float.isInfinite(f = f2 + 150.0f) && !Float.isNaN(f) && this.cam.getLocation().y <= f) {
            this.cam.getLocation().y = f;
            this.cam.update();
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_shadows", false)) {
            sPass.setRenderShadows(!sPass.getRenderShadows());
        }
    }

    private void setupCharacter() {
        PQTorus pQTorus = new PQTorus("torus - target", 2.0f, 3.0f, 2.0f, 1.0f, 64, 12);
        pQTorus.setModelBound((BoundingVolume)new BoundingBox());
        pQTorus.updateModelBound();
        pQTorus.setVBOInfo(new VBOInfo(true));
        this.m_character = new Node("char node");
        this.rootNode.attachChild((Spatial)this.m_character);
        this.m_character.attachChild((Spatial)pQTorus);
        this.m_character.updateWorldBound();
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestShadowPass.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1));
        this.m_character.setRenderState((RenderState)textureState);
    }

    private void setupTerrain() {
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setEnabled(true);
        directionalLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight.setAmbient(new ColorRGBA(0.2f, 0.2f, 0.2f, 0.3f));
        directionalLight.setDirection(new Vector3f(0.5f, -0.4f, 0.0f).normalizeLocal());
        directionalLight.setShadowCaster(true);
        PointLight pointLight = new PointLight();
        pointLight.setEnabled(true);
        pointLight.setDiffuse(new ColorRGBA(0.7f, 0.7f, 0.7f, 1.0f));
        pointLight.setAmbient(new ColorRGBA(0.25f, 0.25f, 0.25f, 0.25f));
        pointLight.setLocation(new Vector3f(0.0f, 500.0f, 0.0f));
        pointLight.setShadowCaster(true);
        DirectionalLight directionalLight2 = new DirectionalLight();
        directionalLight2.setEnabled(true);
        directionalLight2.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight2.setAmbient(new ColorRGBA(0.2f, 0.2f, 0.2f, 0.4f));
        directionalLight2.setDirection(new Vector3f(-0.2f, -0.3f, 0.2f).normalizeLocal());
        directionalLight2.setShadowCaster(true);
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(2);
        cullState.setEnabled(true);
        this.rootNode.setRenderState((RenderState)cullState);
        this.lightState.detachAll();
        this.lightState.attach((Light)directionalLight);
        this.lightState.attach((Light)directionalLight2);
        this.lightState.attach((Light)pointLight);
        this.lightState.setGlobalAmbient(new ColorRGBA(0.6f, 0.6f, 0.6f, 1.0f));
        FaultFractalHeightMap faultFractalHeightMap = new FaultFractalHeightMap(257, 32, 0, 255, 0.55f);
        Vector3f vector3f = new Vector3f(10.0f, 1.0f, 10.0f);
        faultFractalHeightMap.setHeightScale(0.001f);
        this.page = new TerrainPage("Terrain", 33, faultFractalHeightMap.getSize(), vector3f, faultFractalHeightMap.getHeightMap(), false);
        this.page.setDetailTexture(1, 16);
        this.rootNode.attachChild((Spatial)this.page);
        ProceduralTextureGenerator proceduralTextureGenerator = new ProceduralTextureGenerator((AbstractHeightMap)faultFractalHeightMap);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestShadowPass.class.getClassLoader().getResource("jmetest/data/texture/grassb.png")), -128, 0, 128);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestShadowPass.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg")), 0, 128, 255);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestShadowPass.class.getClassLoader().getResource("jmetest/data/texture/highest.jpg")), 128, 255, 384);
        proceduralTextureGenerator.createTexture(512);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        Texture texture = TextureManager.loadTexture((Image)proceduralTextureGenerator.getImageIcon().getImage(), (int)6, (int)1, (boolean)true);
        textureState.setTexture(texture, 0);
        Texture texture2 = TextureManager.loadTexture((URL)TestShadowPass.class.getClassLoader().getResource("jmetest/data/texture/Detail.jpg"), (int)6, (int)1);
        textureState.setTexture(texture2, 1);
        texture2.setWrap(3);
        texture.setApply(4);
        texture.setCombineFuncRGB(1);
        texture.setCombineSrc0RGB(0);
        texture.setCombineOp0RGB(0);
        texture.setCombineSrc1RGB(1);
        texture.setCombineOp1RGB(0);
        texture.setCombineScaleRGB(1.0f);
        texture2.setApply(4);
        texture2.setCombineFuncRGB(3);
        texture2.setCombineSrc0RGB(0);
        texture2.setCombineOp0RGB(0);
        texture2.setCombineSrc1RGB(3);
        texture2.setCombineOp1RGB(0);
        texture2.setCombineScaleRGB(1.0f);
        this.rootNode.setRenderState((RenderState)textureState);
        this.fs = this.display.getRenderer().createFogState();
        this.fs.setDensity(0.5f);
        this.fs.setEnabled(true);
        this.fs.setColor(new ColorRGBA(0.5f, 0.5f, 0.5f, 0.5f));
        this.fs.setEnd(1000.0f);
        this.fs.setStart(500.0f);
        this.fs.setDensityFunction(0);
        this.fs.setApplyFunction(0);
        this.rootNode.setRenderState((RenderState)this.fs);
    }

    private void setupOccluders() {
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestShadowPass.class.getClassLoader().getResource("jmetest/data/texture/rust.png"), (int)6, (int)1));
        this.occluders = new Node("occs");
        this.occluders.setRenderState((RenderState)textureState);
        this.rootNode.attachChild((Spatial)this.occluders);
        for (int i = 0; i < 50; ++i) {
            Box box = new Box("box", new Vector3f(), 8.0f, 50.0f, 8.0f);
            box.setModelBound((BoundingVolume)new BoundingBox());
            box.updateModelBound();
            float f = (float)Math.random() * 2000.0f - 1000.0f;
            float f2 = (float)Math.random() * 2000.0f - 1000.0f;
            box.setLocalTranslation(new Vector3f(f, this.page.getHeight(f, f2) + 50.0f, f2));
            this.page.getSurfaceNormal(box.getLocalTranslation(), this.normal);
            if (this.normal != null) {
                box.rotateUpTo(this.normal);
            }
            this.occluders.attachChild((Spatial)box);
        }
        this.occluders.lock();
    }

    private void setupChaseCamera() {
        Vector3f vector3f = new Vector3f();
        vector3f.y = ((BoundingBox)this.m_character.getWorldBound()).yExtent * 1.5f;
        this.chaser = new ChaseCamera(this.cam, (Spatial)this.m_character);
        this.chaser.setTargetOffset(vector3f);
        this.chaser.getMouseLook().setMinRollOut(150.0f);
        this.chaser.setMaxDistance(300.0f);
    }

    private void setupInput() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("doGradual", "true");
        hashMap.put("turnSpeed", "1.5707964");
        hashMap.put("lockBackwards", "true");
        hashMap.put("cameraAlignedMovement", "true");
        hashMap.put("rotateOnly", "true");
        this.input = new ThirdPersonHandler((Spatial)this.m_character, this.cam, hashMap);
        this.input.setActionSpeed(100.0f);
    }
}

