/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.ChaseCamera;
import com.jme.input.ThirdPersonHandler;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.TextureRenderer;
import com.jme.scene.CameraNode;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.CullState;
import com.jme.scene.state.FogState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureKey;
import com.jme.util.TextureManager;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.model.XMLparser.Converters.MilkToJme;
import com.jmex.terrain.TerrainPage;
import com.jmex.terrain.util.AbstractHeightMap;
import com.jmex.terrain.util.FaultFractalHeightMap;
import com.jmex.terrain.util.ProceduralTextureGenerator;
import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import javax.swing.ImageIcon;
import jmetest.input.TestThirdPersonController;
import jmetest.renderer.loader.TestMilkJmeWrite;
import jmetest.terrain.TestTerrain;

public class TestSpatialLookAt
extends SimpleGame {
    private Node monitorNode;
    private CameraNode camNode;
    private TextureRenderer tRenderer;
    private Texture fakeTex;
    private float lastRend = 1.0f;
    public Node scene;
    public Node m_character;
    public TerrainPage page;
    public ChaseCamera chaser;
    public ThirdPersonHandler input;
    public Geometry target;
    private Vector3f normal = new Vector3f();

    public static void main(String[] stringArray) {
        TestSpatialLookAt testSpatialLookAt = new TestSpatialLookAt();
        testSpatialLookAt.setDialogBehaviour(2);
        testSpatialLookAt.start();
    }

    protected void cleanup() {
        super.cleanup();
        this.tRenderer.cleanup();
    }

    protected void simpleUpdate() {
        this.monitorNode.updateGeometricState(0.0f, true);
    }

    protected void simpleRender() {
        float f;
        this.input.update(this.tpf);
        this.chaser.update(this.tpf);
        float f2 = this.page.getHeight(this.cam.getLocation()) + 2.0f;
        if (!Float.isInfinite(f2) && !Float.isNaN(f2) && this.cam.getLocation().y <= f2) {
            this.cam.getLocation().y = f2;
            this.cam.update();
        }
        if (!Float.isInfinite(f = this.page.getHeight(this.m_character.getLocalTranslation()) + ((BoundingBox)this.m_character.getWorldBound()).yExtent) && !Float.isNaN(f)) {
            this.m_character.getLocalTranslation().y = f;
        }
        this.page.getSurfaceNormal(this.m_character.getLocalTranslation(), this.normal);
        if (this.normal != null) {
            this.m_character.rotateUpTo(this.normal);
        }
        this.lastRend += this.tpf;
        if (this.lastRend > 0.03f) {
            this.camNode.lookAt(this.m_character.getWorldTranslation(), Vector3f.UNIT_Y);
            this.tRenderer.render((Spatial)this.scene, this.fakeTex);
            this.lastRend = 0.0f;
        }
        this.display.getRenderer().draw((Spatial)this.monitorNode);
    }

    protected void simpleInitGame() {
        this.display.setTitle("Spatial.lookAt Test");
        this.scene = new Node("rend_scene");
        this.rootNode.attachChild((Spatial)this.scene);
        this.rootNode.setRenderQueueMode(2);
        this.setupCharacter();
        this.setupTerrain();
        this.setupChaseCamera();
        this.setupInput();
        this.setupSecurityCamera();
        this.setupSecurityMonitor();
    }

    private void setupSecurityMonitor() {
        this.monitorNode = new Node("Monitor Node");
        this.monitorNode.setRenderQueueMode(4);
        Quad quad = new Quad("Monitor");
        quad.getBatch(0).setZOrder(1);
        quad.initialize(150.0f, 150.0f);
        quad.setLocalTranslation(new Vector3f(90.0f, 110.0f, 0.0f));
        this.monitorNode.attachChild((Spatial)quad);
        Quad quad2 = new Quad("Monitor");
        quad2.getBatch(0).setZOrder(2);
        quad2.initialize(160.0f, 160.0f);
        quad2.getLocalTranslation().set(quad.getLocalTranslation());
        this.monitorNode.attachChild((Spatial)quad2);
        this.tRenderer.setBackgroundColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        this.fakeTex = new Texture();
        this.fakeTex.setRTTSource(1);
        this.tRenderer.setupTexture(this.fakeTex);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(this.fakeTex);
        textureState.setEnabled(true);
        quad.setRenderState((RenderState)textureState);
        this.monitorNode.updateGeometricState(0.0f, true);
        this.monitorNode.updateRenderState();
        this.camNode.lookAt(this.m_character.getWorldTranslation(), Vector3f.UNIT_Y);
    }

    private void setupSecurityCamera() {
        this.tRenderer = this.display.createTextureRenderer(256, 256, 2);
        this.camNode = new CameraNode("Camera Node", this.tRenderer.getCamera());
        this.camNode.setLocalTranslation(new Vector3f(0.0f, 255.0f, 0.0f));
        this.camNode.updateGeometricState(0.0f, true);
        MilkToJme milkToJme = new MilkToJme();
        URL uRL = TestMilkJmeWrite.class.getClassLoader().getResource("jmetest/data/model/msascii/camera.ms3d");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            milkToJme.convert(uRL.openStream(), (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            System.out.println("IO problem writting the file!!!");
            System.out.println(iOException.getMessage());
            System.exit(0);
        }
        URL uRL2 = TestMilkJmeWrite.class.getClassLoader().getResource("jmetest/data/model/msascii/");
        TextureKey.setOverridingLocation((URL)uRL2);
        Node node = null;
        try {
            node = (Node)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            System.out.println("darn exceptions:" + iOException.getMessage());
        }
        this.camNode.attachChild((Spatial)node);
        this.rootNode.attachChild((Spatial)this.camNode);
    }

    private void setupCharacter() {
        this.target = new Box("box", new Vector3f(), 0.5f, 0.5f, 0.5f);
        this.target.setLocalScale(10.0f);
        this.target.setModelBound((BoundingVolume)new BoundingBox());
        this.target.updateModelBound();
        this.m_character = new Node("char node");
        this.scene.attachChild((Spatial)this.m_character);
        this.m_character.attachChild((Spatial)this.target);
        this.m_character.getLocalTranslation().y = 255.0f;
        this.m_character.updateWorldBound();
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestThirdPersonController.class.getClassLoader().getResource("jmetest/data/images/Monkey.tga"), (int)2, (int)1));
        this.m_character.setRenderState((RenderState)textureState);
    }

    private void setupTerrain() {
        this.display.getRenderer().setBackgroundColor(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setEnabled(true);
        directionalLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        directionalLight.setDirection(new Vector3f(0.5f, -0.5f, 0.0f));
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(2);
        cullState.setEnabled(true);
        this.rootNode.setRenderState((RenderState)cullState);
        LightState lightState = this.display.getRenderer().createLightState();
        lightState.setEnabled(true);
        lightState.attach((Light)directionalLight);
        this.rootNode.setRenderState((RenderState)lightState);
        FaultFractalHeightMap faultFractalHeightMap = new FaultFractalHeightMap(257, 32, 0, 255, 0.75f);
        Vector3f vector3f = new Vector3f(10.0f, 1.0f, 10.0f);
        faultFractalHeightMap.setHeightScale(0.001f);
        this.page = new TerrainPage("Terrain", 33, faultFractalHeightMap.getSize(), vector3f, faultFractalHeightMap.getHeightMap(), false);
        this.page.setDetailTexture(1, 16);
        this.scene.attachChild((Spatial)this.page);
        ProceduralTextureGenerator proceduralTextureGenerator = new ProceduralTextureGenerator((AbstractHeightMap)faultFractalHeightMap);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/grassb.png")), -128, 0, 128);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg")), 0, 128, 255);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/highest.jpg")), 128, 255, 384);
        proceduralTextureGenerator.createTexture(512);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        Texture texture = TextureManager.loadTexture((Image)proceduralTextureGenerator.getImageIcon().getImage(), (int)6, (int)1, (boolean)true);
        textureState.setTexture(texture, 0);
        Texture texture2 = TextureManager.loadTexture((URL)TestThirdPersonController.class.getClassLoader().getResource("jmetest/data/texture/Detail.jpg"), (int)6, (int)1);
        textureState.setTexture(texture2, 1);
        texture2.setWrap(3);
        texture.setApply(4);
        texture.setCombineFuncRGB(1);
        texture.setCombineSrc0RGB(0);
        texture.setCombineOp0RGB(0);
        texture.setCombineSrc1RGB(1);
        texture.setCombineOp1RGB(0);
        texture.setCombineScaleRGB(1.0f);
        texture2.setApply(4);
        texture2.setCombineFuncRGB(3);
        texture2.setCombineSrc0RGB(0);
        texture2.setCombineOp0RGB(0);
        texture2.setCombineSrc1RGB(3);
        texture2.setCombineOp1RGB(0);
        texture2.setCombineScaleRGB(1.0f);
        this.rootNode.setRenderState((RenderState)textureState);
        FogState fogState = this.display.getRenderer().createFogState();
        fogState.setDensity(0.5f);
        fogState.setEnabled(true);
        fogState.setColor(new ColorRGBA(0.5f, 0.5f, 0.5f, 0.5f));
        fogState.setEnd(1000.0f);
        fogState.setStart(500.0f);
        fogState.setDensityFunction(0);
        fogState.setApplyFunction(0);
        this.rootNode.setRenderState((RenderState)fogState);
    }

    private void setupChaseCamera() {
        Vector3f vector3f = new Vector3f();
        vector3f.y = ((BoundingBox)this.m_character.getWorldBound()).yExtent * 1.5f;
        this.chaser = new ChaseCamera(this.cam, (Spatial)this.m_character);
        this.chaser.setTargetOffset(vector3f);
    }

    private void setupInput() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("doGradual", "true");
        hashMap.put("turnSpeed", "3.1415927");
        hashMap.put("lockBackwards", "false");
        hashMap.put("cameraAlignedMovement", "true");
        this.input = new ThirdPersonHandler((Spatial)this.m_character, this.cam, hashMap);
        this.input.setActionSpeed(100.0f);
    }
}

