/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.animation.SpatialTransformer;
import com.jme.app.SimpleGame;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;

public class TestSpatialTransform
extends SimpleGame {
    private final int test = 7;
    private final float time = 5.0f;
    private final float timeDivision = 10.0f;
    private SpatialTransformer spt = new SpatialTransformer(1);

    public TestSpatialTransform() {
        this.spt.setRepeatType(1);
    }

    public static void main(String[] stringArray) {
        TestSpatialTransform testSpatialTransform = new TestSpatialTransform();
        System.out.println("Spatial transform diagnostic tests, 5/4/2005");
        testSpatialTransform.setDialogBehaviour(2);
        testSpatialTransform.start();
    }

    public void simpleInitGame() {
        Box box = new Box("Reference", new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f));
        Box box2 = new Box("Transform", new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f));
        box2.setLocalScale(2.0f);
        box2.setLocalTranslation(new Vector3f(1.0f, 1.0f, 1.0f));
        Quaternion quaternion = new Quaternion();
        quaternion.fromAngleAxis(0.7854f, new Vector3f(1.0f, 1.0f, 1.0f));
        box2.setLocalRotation(quaternion);
        this.cam.setLocation(new Vector3f(1.0f, 2.5f, 12.0f));
        this.setTest((Spatial)box2);
        System.out.println("DIAGNOSTIC ::");
        System.out.println("SCALE :" + box2.getLocalScale());
        System.out.println("ROTATION :" + box2.getLocalRotation());
        System.out.println("TRANSLATION :" + box2.getLocalTranslation());
        box2.addController((Controller)this.spt);
        this.rootNode.attachChild((Spatial)box);
        this.rootNode.attachChild((Spatial)box2);
    }

    private void setTest(Spatial spatial) {
        this.spt.setObject(spatial, 0, -1);
        if ((this.test & 1) == 1) {
            this.setRotation();
        }
        if ((this.test & 2) == 2) {
            this.setScale();
        }
        if ((this.test & 4) == 4) {
            this.setTranslation();
        }
        this.spt.interpolateMissing();
    }

    private void setRotation() {
        Quaternion quaternion = new Quaternion();
        float f = 0.0f;
        for (float f2 = 0.0f; f2 < this.time + this.time / this.timeDivision; f2 += this.time / this.timeDivision) {
            f = f2 / this.time * 360.0f;
            if (f > 360.0f) {
                f = 360.0f;
            }
            quaternion.fromAngleAxis((float)Math.PI / 180 * f, new Vector3f(1.0f, 1.0f, 1.0f));
            this.spt.setRotation(0, f2, quaternion);
        }
    }

    private void setTranslation() {
        Vector3f vector3f = new Vector3f();
        for (float f = 0.0f; f < this.time + this.time / this.timeDivision; f += this.time / this.timeDivision) {
            float f2 = (float)((double)(f / this.time) * (Math.PI * 2));
            if ((double)f2 > Math.PI * 2) {
                f2 = (float)Math.PI * 2;
            }
            vector3f.x = (float)Math.sin(f2) * 5.0f;
            vector3f.y = (float)Math.cos(f2) * 2.5f;
            vector3f.z = (float)Math.cos(f2) * 5.0f;
            this.spt.setPosition(0, f, vector3f);
        }
    }

    private void setScale() {
        Vector3f vector3f = new Vector3f();
        for (float f = 0.0f; f < this.time + this.time / this.timeDivision; f += this.time / this.timeDivision) {
            float f2 = f < this.time / 2.0f ? f / this.time * 10.0f : (1.0f - f / this.time) * 10.0f;
            vector3f.x = f2;
            vector3f.y = f2;
            vector3f.z = f2;
            this.spt.setScale(0, f, vector3f);
        }
    }
}

