/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingVolume;
import com.jme.bounding.OrientedBoundingBox;
import com.jme.intersection.CollisionResults;
import com.jme.intersection.TriangleCollisionResults;
import com.jme.math.Vector3f;
import com.jme.scene.DistanceSwitchModel;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.SwitchModel;
import com.jme.scene.Text;
import com.jme.scene.TriMesh;
import com.jme.scene.lod.DiscreteLodNode;
import com.jme.scene.shape.Box;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import java.net.URL;

public class TestSwitchNodeCollision
extends SimpleGame {
    private TriMesh t1;
    private TriMesh t2;
    private TriMesh t3;
    private Text text;
    private Node scene;
    private int t1Collided = 0;
    private int t2Collided = 0;
    private int t3Collided = 0;
    private TriangleCollisionResults results;
    private float step = -40.0f;

    protected void simpleInitGame() {
        this.results = new TriangleCollisionResults();
        this.display.setTitle("Collision Detection");
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 75.0f));
        this.cam.update();
        this.text = new Text("Text Label", "Collision: No");
        this.text.setLocalTranslation(new Vector3f(1.0f, 60.0f, 0.0f));
        this.fpsNode.attachChild((Spatial)this.text);
        this.scene = new Node("3D Scene Root");
        Vector3f vector3f = new Vector3f(5.0f, 5.0f, 5.0f);
        Vector3f vector3f2 = new Vector3f(-5.0f, -5.0f, -5.0f);
        this.t1 = new Box("Box 1", vector3f2, vector3f);
        this.t1.setModelBound((BoundingVolume)new OrientedBoundingBox());
        this.t1.updateModelBound();
        this.t2 = new Box("Box 2", vector3f2, vector3f);
        this.t2.setModelBound((BoundingVolume)new OrientedBoundingBox());
        this.t2.updateModelBound();
        DistanceSwitchModel distanceSwitchModel = new DistanceSwitchModel(2);
        DiscreteLodNode discreteLodNode = new DiscreteLodNode("lod node", (SwitchModel)distanceSwitchModel);
        discreteLodNode.setLocalTranslation(new Vector3f(-30.0f, 0.0f, 0.0f));
        distanceSwitchModel.setModelDistance(0, 0.0f, 2000.0f);
        discreteLodNode.attachChild((Spatial)this.t1);
        distanceSwitchModel.setModelDistance(1, 2000.0f, 9000.0f);
        discreteLodNode.attachChild((Spatial)this.t2);
        discreteLodNode.updateGeometricState(0.0f, true);
        this.t3 = new Box("Char", vector3f2.mult(0.5f), vector3f.mult(0.5f));
        this.t3.setModelBound((BoundingVolume)new OrientedBoundingBox());
        this.t3.updateModelBound();
        this.t3.setLocalTranslation(new Vector3f(30.0f, 0.0f, 0.0f));
        this.scene.attachChild((Spatial)discreteLodNode);
        this.scene.attachChild((Spatial)this.t3);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestSwitchNodeCollision.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1));
        this.scene.setRenderState((RenderState)textureState);
        this.rootNode.attachChild((Spatial)this.scene);
    }

    protected void simpleUpdate() {
        this.t3.getLocalTranslation().x += this.step * this.timer.getTimePerFrame();
        if (this.t3.getLocalTranslation().x > 40.0f) {
            this.t3.getLocalTranslation().x = 40.0f;
            this.step *= -1.0f;
        } else if (this.t3.getLocalTranslation().x < -40.0f) {
            this.t3.getLocalTranslation().x = -40.0f;
            this.step *= -1.0f;
        }
        this.results.clear();
        this.t3.findCollisions((Spatial)this.scene, (CollisionResults)this.results);
        if (this.results.getNumber() == 0) {
            this.text.print("");
        } else {
            for (int i = 0; i < this.results.getNumber(); ++i) {
                if (this.results.getCollisionData(i).getTargetMesh().equals(this.t1) || this.results.getCollisionData(i).getSourceMesh().equals(this.t1)) {
                    ++this.t1Collided;
                }
                if (this.results.getCollisionData(i).getTargetMesh().equals(this.t2) || this.results.getCollisionData(i).getSourceMesh().equals(this.t2)) {
                    ++this.t2Collided;
                }
                if (this.results.getCollisionData(i).getTargetMesh().equals(this.t3) || this.results.getCollisionData(i).getSourceMesh().equals(this.t3)) {
                    ++this.t3Collided;
                }
                if (this.results.getCollisionData(i).getTargetTris().size() > 0) {
                    this.text.print("Collision with " + this.results.getCollisionData(i).getTargetMesh().getName());
                    continue;
                }
                if (this.results.getCollisionData(i).getSourceTris().size() <= 0) continue;
                this.text.print("Collision with " + this.results.getCollisionData(i).getSourceMesh().getName());
            }
        }
    }

    public void cleanup() {
        System.out.println("Collisions: t1=" + this.t1Collided + ", t2=" + this.t2Collided + ", t3=" + this.t3Collided);
    }

    public static void main(String[] stringArray) {
        TestSwitchNodeCollision testSwitchNodeCollision = new TestSwitchNodeCollision();
        testSwitchNodeCollision.setDialogBehaviour(2);
        testSwitchNodeCollision.start();
    }
}

