/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Teapot;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import java.net.URL;

public class TestTeapot
extends SimpleGame {
    private Quaternion rotQuat = new Quaternion();
    private float angle = 0.0f;
    private Vector3f axis = new Vector3f(0.0f, 1.0f, 0.0f);
    private Teapot t;

    public static void main(String[] stringArray) {
        TestTeapot testTeapot = new TestTeapot();
        testTeapot.setDialogBehaviour(2);
        testTeapot.start();
    }

    protected void simpleUpdate() {
        if (this.tpf < 1.0f) {
            this.angle += this.tpf * 25.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleAxis(this.angle * ((float)Math.PI / 180), this.axis);
        this.t.setLocalRotation(this.rotQuat);
    }

    protected void simpleInitGame() {
        this.display.setTitle("Teapot Test");
        this.cam.setLocation(new Vector3f(0.0f, 2.0f, 10.0f));
        this.cam.update();
        this.t = new Teapot("Teapot");
        this.t.setModelBound((BoundingVolume)new BoundingBox());
        this.t.updateModelBound();
        this.rootNode.attachChild((Spatial)this.t);
        TextureState textureState = this.display.getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((URL)TestTeapot.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)6, (int)1);
        Texture texture2 = TextureManager.loadTexture((URL)TestTeapot.class.getClassLoader().getResource("jmetest/data/texture/clouds.png"), (int)6, (int)1);
        texture2.setEnvironmentalMapMode(2);
        textureState.setTexture(texture, 0);
        textureState.setTexture(texture2, 1);
        textureState.setEnabled(true);
        this.rootNode.setRenderState((RenderState)textureState);
        this.lightState.setTwoSidedLighting(true);
        this.lightState.get(0).setDiffuse(ColorRGBA.white);
    }
}

