/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer.state;

import com.jme.app.SimpleGame;
import com.jme.input.NodeHandler;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.GLSLShaderObjectsState;
import com.jme.scene.state.RenderState;
import com.jme.util.LoggingSystem;
import java.util.logging.Level;

public class TestGLSLShaderObjectsState
extends SimpleGame {
    public static void main(String[] stringArray) {
        TestGLSLShaderObjectsState testGLSLShaderObjectsState = new TestGLSLShaderObjectsState();
        testGLSLShaderObjectsState.setDialogBehaviour(2);
        testGLSLShaderObjectsState.start();
    }

    protected void simpleInitGame() {
        this.display.setTitle("GLSL");
        this.display.getRenderer().setBackgroundColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 0.0f));
        this.cam.setLocation(new Vector3f(0.0f, 0.0f, 2.0f));
        this.cam.update();
        this.input = new NodeHandler((Spatial)this.rootNode, 10.0f, 2.0f);
        Quad quad = this.createBrickQuad();
        this.rootNode.attachChild((Spatial)quad);
        this.rootNode.updateRenderState();
    }

    private Quad createBrickQuad() {
        GLSLShaderObjectsState gLSLShaderObjectsState = this.display.getRenderer().createGLSLShaderObjectsState();
        if (!gLSLShaderObjectsState.isSupported()) {
            LoggingSystem.getLogger().log(Level.SEVERE, "Your graphics card does not support GLSL programs, and thus cannot run this test.");
            this.quit();
        }
        gLSLShaderObjectsState.load(TestGLSLShaderObjectsState.class.getClassLoader().getResource("jmetest/data/images/shader.vert"), TestGLSLShaderObjectsState.class.getClassLoader().getResource("jmetest/data/images/shader.frag"));
        gLSLShaderObjectsState.setUniform("BrickColor", 1.0f, 0.3f, 0.2f);
        gLSLShaderObjectsState.setUniform("MortarColor", 0.85f, 0.86f, 0.84f);
        gLSLShaderObjectsState.setUniform("BrickSize", 0.3f, 0.15f);
        gLSLShaderObjectsState.setUniform("BrickPct", 0.9f, 0.85f);
        gLSLShaderObjectsState.setUniform("LightPosition", 0.0f, 0.0f, 4.0f);
        gLSLShaderObjectsState.setEnabled(true);
        Quad quad = new Quad("glslQuad", 1.0f, 1.0f);
        quad.setRenderState((RenderState)gLSLShaderObjectsState);
        return quad;
    }
}

