/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer.state;

import com.jme.app.BaseGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.input.FirstPersonHandler;
import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Box;
import com.jme.scene.state.CullState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.TextureManager;
import com.jme.util.Timer;
import java.net.URL;

public class TestRenderStateList
extends BaseGame {
    private TriMesh t;
    private TriMesh t2;
    private TriMesh t3;
    private Camera cam;
    private Node scene;
    private InputHandler input;
    private Timer timer;

    public static void main(String[] stringArray) {
        TestRenderStateList testRenderStateList = new TestRenderStateList();
        testRenderStateList.setDialogBehaviour(2);
        testRenderStateList.start();
    }

    protected void update(float f) {
        this.timer.update();
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("exit", false)) {
            this.finish();
        }
        this.input.update(this.timer.getTimePerFrame());
    }

    protected void render(float f) {
        this.display.getRenderer().clearBuffers();
        this.display.getRenderer().draw((Spatial)this.scene);
    }

    protected void initSystem() {
        try {
            this.display = DisplaySystem.getDisplaySystem((String)this.properties.getRenderer());
            this.display.createWindow(this.properties.getWidth(), this.properties.getHeight(), this.properties.getDepth(), this.properties.getFreq(), this.properties.getFullscreen());
            this.cam = this.display.getRenderer().createCamera(this.properties.getWidth(), this.properties.getHeight());
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
            System.exit(1);
        }
        ColorRGBA colorRGBA = new ColorRGBA();
        colorRGBA.r = 0.0f;
        colorRGBA.g = 0.0f;
        this.display.getRenderer().setBackgroundColor(colorRGBA);
        this.cam.setFrustum(1.0f, 1000.0f, -0.55f, 0.55f, 0.4125f, -0.4125f);
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 4.0f);
        Vector3f vector3f2 = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, -1.0f);
        this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.display.getRenderer().setCamera(this.cam);
        this.input = new FirstPersonHandler(this.cam, 15.0f, 1.0f);
        this.timer = Timer.getTimer();
        KeyBindingManager.getKeyBindingManager().set("exit", 1);
    }

    protected void initGame() {
        Vector3f vector3f = new Vector3f(-5.0f, -5.0f, -5.0f);
        Vector3f vector3f2 = new Vector3f(5.0f, 5.0f, 5.0f);
        this.t = new Box("Box 1", vector3f, vector3f2);
        this.t.setModelBound((BoundingVolume)new BoundingSphere());
        this.t.setLocalTranslation(new Vector3f(-15.0f, 0.0f, -20.0f));
        this.t.updateModelBound();
        this.t2 = new Box("Box 2", vector3f, vector3f2);
        this.t2.setModelBound((BoundingVolume)new BoundingSphere());
        this.t2.setLocalTranslation(new Vector3f(0.0f, 0.0f, -20.0f));
        this.t2.updateModelBound();
        this.t3 = new Box("Box 3", vector3f, vector3f2);
        this.t3.setModelBound((BoundingVolume)new BoundingSphere());
        this.t3.setLocalTranslation(new Vector3f(15.0f, 0.0f, -20.0f));
        this.t3.updateModelBound();
        this.cam.update();
        this.scene = new Node("Scene Node");
        this.scene.attachChild((Spatial)this.t);
        this.scene.attachChild((Spatial)this.t2);
        this.scene.attachChild((Spatial)this.t3);
        this.scene.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        this.scene.setRenderState((RenderState)zBufferState);
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setEnabled(true);
        cullState.setCullMode(2);
        this.scene.setRenderState((RenderState)cullState);
        CullState cullState2 = this.display.getRenderer().createCullState();
        cullState2.setEnabled(true);
        cullState2.setCullMode(0);
        this.t3.setRenderState((RenderState)cullState2);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestRenderStateList.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1));
        TextureState textureState2 = this.display.getRenderer().createTextureState();
        textureState2.setEnabled(true);
        textureState2.setTexture(TextureManager.loadTexture((URL)TestRenderStateList.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg"), (int)2, (int)1));
        this.t2.setRenderState((RenderState)textureState2);
        this.scene.setRenderState((RenderState)textureState);
        this.cam.update();
        this.scene.updateGeometricState(0.0f, true);
        this.scene.updateRenderState();
    }

    protected void reinit() {
    }

    protected void cleanup() {
    }
}

