/*
 * Decompiled with CFR 0.152.
 */
package jmetest.renderer.state;

import com.jme.animation.TextureAnimationController;
import com.jme.app.BaseGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.math.Quaternion;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Node;
import com.jme.scene.SharedMesh;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.TextureManager;
import com.jme.util.geom.BufferUtils;
import java.net.URL;

public class TestTextureState
extends BaseGame {
    private TriMesh t;
    private TriMesh t2;
    private Camera cam;
    private Node scene;
    Vector3f trans;
    TextureState ts;
    private Quaternion rotation;
    private Vector3f textureRotationAxis;
    float rotationAngle;

    public static void main(String[] stringArray) {
        TestTextureState testTextureState = new TestTextureState();
        testTextureState.setDialogBehaviour(2);
        testTextureState.start();
    }

    protected void update(float f) {
        this.scene.updateGeometricState(f, true);
    }

    protected void render(float f) {
        this.display.getRenderer().clearBuffers();
        this.display.getRenderer().draw((Spatial)this.scene);
    }

    protected void initSystem() {
        try {
            this.display = DisplaySystem.getDisplaySystem((String)this.properties.getRenderer());
            this.display.createWindow(this.properties.getWidth(), this.properties.getHeight(), this.properties.getDepth(), this.properties.getFreq(), this.properties.getFullscreen());
            this.cam = this.display.getRenderer().createCamera(this.properties.getWidth(), this.properties.getHeight());
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
            System.exit(1);
        }
        ColorRGBA colorRGBA = new ColorRGBA();
        colorRGBA.r = 0.0f;
        colorRGBA.g = 0.0f;
        this.display.getRenderer().setBackgroundColor(colorRGBA);
        this.cam.setFrustum(1.0f, 1000.0f, -0.55f, 0.55f, 0.4125f, -0.4125f);
        Vector3f vector3f = new Vector3f(4.0f, 0.0f, 0.0f);
        Vector3f vector3f2 = new Vector3f(0.0f, -1.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 0.0f, 1.0f);
        Vector3f vector3f4 = new Vector3f(-1.0f, 0.0f, 0.0f);
        this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.display.getRenderer().setCamera(this.cam);
        this.trans = new Vector3f();
        this.rotation = new Quaternion();
        this.textureRotationAxis = new Vector3f(0.0f, 0.0f, 1.0f);
    }

    protected void initGame() {
        Vector3f[] vector3fArray = new Vector3f[3];
        ColorRGBA[] colorRGBAArray = new ColorRGBA[3];
        Vector2f[] vector2fArray = new Vector2f[3];
        vector3fArray[0] = new Vector3f();
        vector3fArray[0].x = -50.0f;
        vector3fArray[0].y = 0.0f;
        vector3fArray[0].z = 0.0f;
        vector3fArray[1] = new Vector3f();
        vector3fArray[1].x = -50.0f;
        vector3fArray[1].y = 25.0f;
        vector3fArray[1].z = 25.0f;
        vector3fArray[2] = new Vector3f();
        vector3fArray[2].x = -50.0f;
        vector3fArray[2].y = 25.0f;
        vector3fArray[2].z = 0.0f;
        vector2fArray[0] = new Vector2f();
        vector2fArray[0].x = 1.0f;
        vector2fArray[0].y = 0.0f;
        vector2fArray[1] = new Vector2f();
        vector2fArray[1].x = 1.0f;
        vector2fArray[1].y = 1.0f;
        vector2fArray[2] = new Vector2f();
        vector2fArray[2].x = 0.0f;
        vector2fArray[2].y = 1.0f;
        colorRGBAArray[0] = new ColorRGBA();
        colorRGBAArray[0].r = 1.0f;
        colorRGBAArray[0].g = 0.0f;
        colorRGBAArray[0].b = 0.0f;
        colorRGBAArray[0].a = 1.0f;
        colorRGBAArray[1] = new ColorRGBA();
        colorRGBAArray[1].r = 0.0f;
        colorRGBAArray[1].g = 1.0f;
        colorRGBAArray[1].b = 0.0f;
        colorRGBAArray[1].a = 1.0f;
        colorRGBAArray[2] = new ColorRGBA();
        colorRGBAArray[2].r = 0.0f;
        colorRGBAArray[2].g = 0.0f;
        colorRGBAArray[2].b = 1.0f;
        colorRGBAArray[2].a = 1.0f;
        int[] nArray = new int[]{0, 1, 2};
        this.t = new TriMesh("Triangle", BufferUtils.createFloatBuffer((Vector3f[])vector3fArray), null, BufferUtils.createFloatBuffer((ColorRGBA[])colorRGBAArray), BufferUtils.createFloatBuffer((Vector2f[])vector2fArray), BufferUtils.createIntBuffer((int[])nArray));
        this.t.setModelBound((BoundingVolume)new BoundingSphere());
        this.t.updateModelBound();
        Vector3f[] vector3fArray2 = new Vector3f[3];
        ColorRGBA[] colorRGBAArray2 = new ColorRGBA[3];
        vector3fArray2[0] = new Vector3f();
        vector3fArray2[0].x = -40.0f;
        vector3fArray2[0].y = 10.0f;
        vector3fArray2[0].z = 0.0f;
        vector3fArray2[1] = new Vector3f();
        vector3fArray2[1].x = -40.0f;
        vector3fArray2[1].y = 35.0f;
        vector3fArray2[1].z = 15.0f;
        vector3fArray2[2] = new Vector3f();
        vector3fArray2[2].x = -10.0f;
        vector3fArray2[2].y = 35.0f;
        vector3fArray2[2].z = -10.0f;
        colorRGBAArray2[0] = new ColorRGBA();
        colorRGBAArray2[0].r = 1.0f;
        colorRGBAArray2[0].g = 0.0f;
        colorRGBAArray2[0].b = 0.0f;
        colorRGBAArray2[0].a = 1.0f;
        colorRGBAArray2[1] = new ColorRGBA();
        colorRGBAArray2[1].r = 0.0f;
        colorRGBAArray2[1].g = 1.0f;
        colorRGBAArray2[1].b = 0.0f;
        colorRGBAArray2[1].a = 1.0f;
        colorRGBAArray2[2] = new ColorRGBA();
        colorRGBAArray2[2].r = 0.0f;
        colorRGBAArray2[2].g = 0.0f;
        colorRGBAArray2[2].b = 1.0f;
        colorRGBAArray2[2].a = 1.0f;
        this.t2 = new SharedMesh("Triangle 2", this.t);
        this.t2.setLocalTranslation(new Vector3f(10.0f, 6.0f, 5.0f));
        this.t2.setModelBound((BoundingVolume)new BoundingSphere());
        this.t2.updateModelBound();
        this.cam.update();
        this.scene = new Node("Scene Node");
        this.scene.attachChild((Spatial)this.t);
        this.scene.attachChild((Spatial)this.t2);
        this.scene.setLocalTranslation(new Vector3f(0.0f, -25.0f, 0.0f));
        this.ts = this.display.getRenderer().createTextureState();
        this.ts.setEnabled(true);
        Texture texture = TextureManager.loadTexture((URL)TestTextureState.class.getClassLoader().getResource("jmetest/data/model/marble.bmp"), (int)2, (int)1);
        texture.setWrap(3);
        this.ts.setTexture(texture);
        TextureAnimationController textureAnimationController = new TextureAnimationController(this.ts);
        textureAnimationController.setActive(true);
        textureAnimationController.setSpeed(3.0E-4f);
        textureAnimationController.setTranslationDelta(new Vector3f(1.0f, 1.0f, 0.0f));
        textureAnimationController.setRotationDelta(1.0f);
        textureAnimationController.setXRepeat(10.0f);
        textureAnimationController.setYRepeat(10.0f);
        textureAnimationController.setZRepeat(10.0f);
        textureAnimationController.setTextureRotationAxis(this.textureRotationAxis);
        this.t2.addController((Controller)textureAnimationController);
        this.t2.setRenderState((RenderState)this.ts);
        this.cam.update();
        this.scene.updateGeometricState(0.0f, true);
        this.scene.updateRenderState();
    }

    protected void reinit() {
    }

    protected void cleanup() {
    }
}

