/*
 * Decompiled with CFR 0.152.
 */
package jmetest.shape;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.input.FirstPersonHandler;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Capsule;
import com.jme.scene.state.CullState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import java.net.URL;

public class TestCapsule
extends SimpleGame {
    private Quaternion rotQuat = new Quaternion();
    private float angle = 0.0f;
    private Vector3f axis = new Vector3f(1.0f, 1.0f, 0.0f).normalizeLocal();
    private Capsule t;

    public static void main(String[] stringArray) {
        TestCapsule testCapsule = new TestCapsule();
        testCapsule.setDialogBehaviour(2);
        testCapsule.start();
    }

    protected void simpleUpdate() {
        if (this.timer.getTimePerFrame() < 1.0f) {
            this.angle += this.timer.getTimePerFrame() * 1.0f;
            if (this.angle > 360.0f) {
                this.angle = 0.0f;
            }
        }
        this.rotQuat.fromAngleNormalAxis(this.angle, this.axis);
        this.t.setLocalRotation(this.rotQuat);
    }

    protected void simpleInitGame() {
        this.display.setTitle("Cylinder Test");
        this.t = new Capsule("Capsule", 40, 32, 16, 4.0f, 10.0f);
        this.t.setModelBound((BoundingVolume)new BoundingBox());
        this.t.updateModelBound();
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(2);
        this.rootNode.setRenderState((RenderState)cullState);
        this.input = new FirstPersonHandler(this.cam, 10.0f, 1.0f);
        this.rootNode.attachChild((Spatial)this.t);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestCapsule.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1));
        textureState.getTexture().setWrap(3);
        this.rootNode.setRenderState((RenderState)textureState);
        this.lightState.setTwoSidedLighting(false);
    }
}

