/*
 * Decompiled with CFR 0.152.
 */
package jmetest.shape;

import com.jme.app.SimpleGame;
import com.jme.image.Texture;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.GeoSphere;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import java.net.URL;

public class TestGeoSphere
extends SimpleGame {
    private TextureState textureState;

    protected void simpleInitGame() {
        this.createTextureState();
        this.createGeoSpheres(true, -3.0f, -1);
        this.createGeoSpheres(false, 0.0f, -2);
        Sphere sphere = new Sphere("sphere1", 3, 4, 1.0f);
        System.out.println("Sphere triangles: " + sphere.getTriangleCount());
        sphere.getLocalTranslation().set(-2.5f, 3.0f, 0.0f);
        this.init((TriMesh)sphere);
        Sphere sphere2 = new Sphere("sphere2", 4, 8, 1.0f);
        System.out.println("Sphere triangles: " + sphere2.getTriangleCount());
        sphere2.getLocalTranslation().set(0.0f, 3.0f, 0.0f);
        this.init((TriMesh)sphere2);
        Sphere sphere3 = new Sphere("sphere3", 8, 11, 1.0f);
        System.out.println("Sphere triangles: " + sphere3.getTriangleCount());
        sphere3.getLocalTranslation().set(2.5f, 3.0f, 0.0f);
        this.init((TriMesh)sphere3);
        Sphere sphere4 = new Sphere("sphere4", 16, 18, 1.0f);
        System.out.println("Sphere triangles: " + sphere4.getTriangleCount());
        sphere4.getLocalTranslation().set(5.0f, 3.0f, 0.0f);
        this.init((TriMesh)sphere4);
    }

    private void createTextureState() {
        this.textureState = this.display.getRenderer().createTextureState();
        this.textureState.setEnabled(true);
        Texture texture = TextureManager.loadTexture((URL)TestGeoSphere.class.getClassLoader().getResource("jmetest/data/texture/clouds.png"), (int)2, (int)1);
        this.textureState.setTexture(texture);
    }

    private void createGeoSpheres(boolean bl, float f, int n) {
        for (int i = 1; i <= 4; ++i) {
            GeoSphere geoSphere = new GeoSphere("geosphere", bl, i);
            System.out.println("Geosphere (" + (bl ? "ikosa" : "octa") + ") triangles: " + geoSphere.getTriangleCount());
            geoSphere.getLocalTranslation().set((float)(i + n) * 2.5f, f, 0.0f);
            this.init((TriMesh)geoSphere);
        }
    }

    private void init(TriMesh triMesh) {
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setEnabled(true);
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(5);
        triMesh.addController((Controller)new RotatingController((Spatial)triMesh));
        this.rootNode.attachChild((Spatial)triMesh);
        triMesh.setRenderQueueMode(3);
        triMesh.setRenderState((RenderState)alphaState);
        MaterialState materialState = this.display.getRenderer().createMaterialState();
        materialState.setShininess(128.0f);
        ColorRGBA colorRGBA = new ColorRGBA(0.7f, 0.7f, 0.7f, 1.0f);
        materialState.setDiffuse(colorRGBA);
        materialState.setAmbient(colorRGBA.mult(new ColorRGBA(0.1f, 0.1f, 0.1f, 1.0f)));
        triMesh.setRenderState((RenderState)materialState);
        triMesh.setRenderState((RenderState)this.textureState);
    }

    public static void main(String[] stringArray) {
        new TestGeoSphere().start();
    }

    private static class RotatingController
    extends Controller {
        private Quaternion rot;
        private Vector3f axis;
        private final Spatial spatial;

        public RotatingController(Spatial spatial) {
            this.spatial = spatial;
            this.rot = new Quaternion();
            this.axis = new Vector3f(1.0f, 0.0f, 0.0f).normalizeLocal();
        }

        public void update(float f) {
            this.rot.fromAngleNormalAxis(0.5f * f, this.axis);
            this.spatial.getLocalRotation().multLocal(this.rot);
        }
    }
}

