/*
 * Decompiled with CFR 0.152.
 */
package jmetest.sound.openal;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.sound.openAL.SoundSystem;
import com.jmex.sound.openAL.scene.Configuration;
import java.net.URL;

public class TestSoundGraph
extends SimpleGame {
    private int snode;
    int boxCenter;
    int boxRight;
    int boxLeft;
    int background;
    Box box;
    Box leftBox;
    Box rightBox;
    private float volume;

    public static void main(String[] stringArray) {
        TestSoundGraph testSoundGraph = new TestSoundGraph();
        testSoundGraph.setDialogBehaviour(2);
        testSoundGraph.start();
    }

    protected void simpleUpdate() {
        float f;
        this.leftBox.getLocalTranslation().x += 1.0f / this.leftBox.getLocalTranslation().y;
        this.leftBox.getLocalTranslation().y += 1.0f / this.leftBox.getLocalTranslation().y;
        if (this.rightBox.getLocalTranslation().y > 0.0f && this.rightBox.getLocalTranslation().y < 50.0f) {
            this.rightBox.getLocalTranslation().y = (float)((double)this.rightBox.getLocalTranslation().y - 0.01);
        }
        if (this.rightBox.getLocalTranslation().y < 0.0f && this.rightBox.getLocalTranslation().y > -50.0f) {
            this.rightBox.getLocalTranslation().y = (float)((double)this.rightBox.getLocalTranslation().y + 0.01);
        }
        if ((f = (float)(Math.pow(-this.rightBox.getLocalTranslation().y, 2.0) + 25.0)) >= 0.0f) {
            f = (float)Math.sqrt(f);
        }
        if (f < 0.0f) {
            f = (float)Math.sqrt(-f);
        }
        this.rightBox.getLocalTranslation().x = f;
        SoundSystem.setSamplePosition((int)this.boxLeft, (float)this.leftBox.getLocalTranslation().x, (float)this.leftBox.getLocalTranslation().y, (float)this.leftBox.getLocalTranslation().z);
        SoundSystem.setSamplePosition((int)this.boxLeft, (float)this.rightBox.getLocalTranslation().x, (float)this.rightBox.getLocalTranslation().y, (float)this.rightBox.getLocalTranslation().z);
        this.volume = (float)((double)this.volume + 1.0E-4);
        SoundSystem.setStreamVolume((int)this.background, (float)this.volume);
        SoundSystem.update((float)0.0f);
    }

    protected void simpleRender() {
        SoundSystem.draw((int)this.snode);
    }

    protected void simpleInitGame() {
        this.display.setTitle("Test Sound Graph");
        SoundSystem.init((Camera)this.display.getRenderer().getCamera(), (int)0);
        Vector3f vector3f = new Vector3f(5.0f, 5.0f, 5.0f);
        Vector3f vector3f2 = new Vector3f(-5.0f, -5.0f, -5.0f);
        this.box = new Box("Box", vector3f2, vector3f);
        this.box.setModelBound((BoundingVolume)new BoundingSphere());
        this.box.updateModelBound();
        this.box.setLocalTranslation(new Vector3f(0.0f, 10.0f, -50.0f));
        this.leftBox = new Box("Box2", (Vector3f)vector3f2.clone(), (Vector3f)vector3f.clone());
        this.leftBox.setModelBound((BoundingVolume)new BoundingSphere());
        this.leftBox.updateModelBound();
        this.leftBox.setLocalTranslation(new Vector3f(-100.0f, 10.0f, -50.0f));
        this.rightBox = new Box("Box3", (Vector3f)vector3f2.clone(), (Vector3f)vector3f.clone());
        this.rightBox.setModelBound((BoundingVolume)new BoundingSphere());
        this.rightBox.updateModelBound();
        this.rightBox.setLocalTranslation(new Vector3f(100.0f, 10.0f, -50.0f));
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestSoundGraph.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1));
        this.rootNode.setRenderState((RenderState)textureState);
        this.rootNode.attachChild((Spatial)this.box);
        this.rootNode.attachChild((Spatial)this.leftBox);
        this.rootNode.attachChild((Spatial)this.rightBox);
        this.snode = SoundSystem.createSoundNode();
        try {
            this.background = SoundSystem.createStream((URL)TestSoundGraph.class.getClassLoader().getResource("jmetest/data/sound/test.ogg"));
            this.boxCenter = SoundSystem.create3DSample((URL)TestSoundGraph.class.getClassLoader().getResource("jmetest/data/sound/CHAR_CRE_1.ogg"));
            this.boxRight = SoundSystem.cloneSample((int)this.boxCenter);
            this.boxLeft = SoundSystem.cloneSample((int)this.boxCenter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        SoundSystem.setStreamLooping((int)this.background, (boolean)true);
        SoundSystem.playStream((int)this.background);
        SoundSystem.setStreamVolume((int)this.background, (float)0.0f);
        SoundSystem.setSampleMaxAudibleDistance((int)this.boxLeft, (int)100);
        SoundSystem.setSamplePosition((int)this.boxLeft, (float)this.rightBox.getLocalTranslation().x, (float)this.rightBox.getLocalTranslation().y, (float)this.rightBox.getLocalTranslation().z);
        SoundSystem.setSampleMinAudibleDistance((int)this.boxLeft, (int)4);
        SoundSystem.addSampleToNode((int)this.boxLeft, (int)this.snode);
        SoundSystem.setSampleMaxAudibleDistance((int)this.boxRight, (int)100);
        SoundSystem.setSamplePosition((int)this.boxRight, (float)this.leftBox.getLocalTranslation().x, (float)this.leftBox.getLocalTranslation().y, (float)this.leftBox.getLocalTranslation().z);
        SoundSystem.setSampleMinAudibleDistance((int)this.boxRight, (int)4);
        SoundSystem.addSampleToNode((int)this.boxRight, (int)this.snode);
        Configuration configuration = new Configuration();
        configuration.setDistortion(-10.0f, 70.0f, 6000.0f, 5000.0f, 7000.0f);
        SoundSystem.setSampleConfig((int)this.boxCenter, (Configuration)configuration);
    }
}

