/*
 * Decompiled with CFR 0.152.
 */
package jmetest.stress.graphbrowser;

import com.jme.input.KeyBindingManager;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Line;
import com.jme.scene.Node;
import com.jme.scene.SharedMesh;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Box;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import java.util.HashMap;
import java.util.Map;
import jmetest.stress.StressApp;
import jmetest.stress.graphbrowser.GraphAccessor;
import jmetest.stress.graphbrowser.GraphLayouter;

public class GraphBrowser
extends StressApp {
    Map<Object, Spatial> nodes = new HashMap<Object, Spatial>();
    Map<Object, Line> edges = new HashMap<Object, Line>();
    private GraphAccessor accessor;
    private GraphLayouter layouter;
    private boolean pathOnly;
    private static final String COMMAND_PATH_ONLY = "toggle_path_only";
    private Box box;

    public GraphBrowser(GraphAccessor graphAccessor, GraphLayouter graphLayouter) {
        this.accessor = graphAccessor;
        this.layouter = graphLayouter;
    }

    protected void simpleInitGame() {
        ColorRGBA colorRGBA;
        Object object;
        this.lightState.setGlobalAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        this.box = new Box("box", new Vector3f(-1.0f, -1.0f, -1.0f), new Vector3f(1.0f, 1.0f, 1.0f));
        MaterialState materialState = this.display.getRenderer().createMaterialState();
        materialState.setEnabled(true);
        ColorRGBA colorRGBA2 = new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
        materialState.setDiffuse(colorRGBA2);
        this.rootNode.setRenderState((RenderState)materialState);
        for (int i = this.accessor.getNodeCount() - 1; i >= 0; --i) {
            Object object2 = this.accessor.getNode(i);
            object = new SharedMesh(String.valueOf(object2), (TriMesh)this.box);
            object.getLocalTranslation().set(this.layouter.getCoordinates(object2));
            colorRGBA = this.colorForNode(object2);
            if (!colorRGBA2.equals((Object)colorRGBA)) {
                materialState = this.display.getRenderer().createMaterialState();
                materialState.setEnabled(true);
                materialState.setDiffuse(colorRGBA);
                object.setRenderState((RenderState)materialState);
            }
            this.rootNode.attachChild((Spatial)object);
            this.nodes.put(object2, (Spatial)object);
        }
        Node node = new Node("lines");
        materialState = this.display.getRenderer().createMaterialState();
        materialState.setEnabled(true);
        materialState.setDiffuse(colorRGBA2);
        materialState.setEmissive(colorRGBA2);
        node.setRenderState((RenderState)materialState);
        this.rootNode.attachChild((Spatial)node);
        for (int i = this.accessor.getEdgeCount() - 1; i >= 0; --i) {
            object = this.accessor.getEdge(i);
            colorRGBA = this.nodes.get(this.accessor.getEdgeSource(object));
            Spatial spatial = this.nodes.get(this.accessor.getEdgeTarget(object));
            Vector3f[] vector3fArray = new Vector3f[]{colorRGBA.getLocalTranslation(), spatial.getLocalTranslation()};
            Line line = new Line(object.toString(), vector3fArray, null, null, null);
            ColorRGBA colorRGBA3 = this.colorForEdge(object);
            if (!colorRGBA2.equals((Object)colorRGBA3)) {
                materialState = this.display.getRenderer().createMaterialState();
                materialState.setEnabled(true);
                materialState.setDiffuse(colorRGBA3);
                materialState.setEmissive(colorRGBA3);
                line.setRenderState((RenderState)materialState);
            }
            line.setLightCombineMode(2);
            node.attachChild((Spatial)line);
            line.updateRenderState();
            this.edges.put(object, line);
        }
        KeyBindingManager.getKeyBindingManager().set(COMMAND_PATH_ONLY, 24);
        Text text = this.createText("Press O to toggle edges/path");
        text.getLocalTranslation().set(0.0f, 20.0f, 0.0f);
        this.fpsNode.attachChild((Spatial)text);
        this.cam.getLocation().set(40.0f, 40.0f, 100.0f);
        this.cam.update();
    }

    private ColorRGBA colorForEdge(Object object) {
        boolean bl = this.accessor.isEdgePath(object);
        return new ColorRGBA(1.0f, bl ? 0.0f : 1.0f, bl ? 0.0f : 1.0f, 1.0f);
    }

    private ColorRGBA colorForNode(Object object) {
        return new ColorRGBA(1.0f, 1.0f, this.accessor.isNodeTerminal(object) ? 0.0f : 1.0f, 1.0f);
    }

    protected void simpleUpdate() {
        super.simpleUpdate();
        if (KeyBindingManager.getKeyBindingManager().isValidCommand(COMMAND_PATH_ONLY, false)) {
            this.pathOnly = !this.pathOnly;
            for (int i = this.accessor.getEdgeCount() - 1; i >= 0; --i) {
                Spatial spatial;
                Object object = this.accessor.getEdge(i);
                if (this.accessor.isEdgePath(object) || (spatial = (Spatial)this.edges.get(object)) == null) continue;
                spatial.setCullMode(this.pathOnly ? 2 : 1);
            }
        }
    }
}

