/*
 * Decompiled with CFR 0.152.
 */
package jmetest.stress.swarm;

import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.intersection.BoundingCollisionResults;
import com.jme.intersection.CollisionResults;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Node;
import com.jme.scene.SharedMesh;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Box;
import com.jme.scene.state.RenderState;
import com.jme.system.DisplaySystem;
import java.util.HashMap;
import java.util.Map;

public class Fish
extends Node {
    private static final long serialVersionUID = 1L;
    private float speed;
    private Vector3f orientation;
    private static final float SIGHT_RADIUS = 0.1f;
    private static final float STEERING_SPEED = 0.3f;
    private static final float MINIMUM_DISTANCE = 0.02f;
    private Vector3f relativePositionSumInSight = new Vector3f();
    private Vector3f orientationSumInSight = new Vector3f();
    private Vector3f relativePositionSumTooNear = new Vector3f();
    private int fishTooNear;
    private int fishInSight;
    private static final float SIZE = 0.01f;
    private Vector3f relativePosition = new Vector3f();
    private Vector3f tmp_pos = new Vector3f();
    private final Node rootNode;
    private static final float SPEED_GREEN = 0.001f;
    private static final float SPEED_RED = 0.01f;
    public static boolean useCollisionDetection = true;
    private static Map<Float, TriMesh> visuals = new HashMap<Float, TriMesh>();
    protected static CollisionResults nearbyFish = new BoundingCollisionResults();

    public Fish(float f, float f2, float f3, float f4, float f5, float f6, float f7, Node node) {
        super("fish");
        this.rootNode = node;
        this.speed = f7;
        this.orientation = new Vector3f(f4, f5, f6);
        this.orientation.normalize();
        this.setupAppearance(f7);
        this.getLocalTranslation().set(f, f2, f3);
        this.addController(new Controller(){
            private static final long serialVersionUID = 1L;

            public void update(float f) {
                Fish.this.process();
            }
        });
    }

    private void setupAppearance(float f) {
        SharedMesh sharedMesh;
        float f2 = (f - 0.001f) / 0.01f;
        if (f2 > 1.0f) {
            f2 = 1.0f;
        } else if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        TriMesh triMesh = visuals.get(Float.valueOf(f2));
        if (triMesh == null) {
            triMesh = new Box("fish", new Vector3f(), 0.01f, 0.01f, 0.01f);
            sharedMesh = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
            sharedMesh.setDiffuse(new ColorRGBA());
            sharedMesh.setDiffuse(new ColorRGBA(f2, 1.0f - f2, 0.0f, 1.0f));
            triMesh.setRenderState((RenderState)sharedMesh);
            triMesh.setModelBound((BoundingVolume)new BoundingSphere(0.05f, new Vector3f()));
            visuals.put(Float.valueOf(f2), triMesh);
        }
        sharedMesh = new SharedMesh("fish visual", triMesh);
        this.attachChild((Spatial)sharedMesh);
    }

    public Vector3f getOrientation() {
        return this.orientation;
    }

    public void process() {
        this.fishInSight = 0;
        this.fishTooNear = 0;
        this.relativePositionSumInSight.set(0.0f, 0.0f, 0.0f);
        this.orientationSumInSight.set(0.0f, 0.0f, 0.0f);
        this.relativePositionSumTooNear.set(0.0f, 0.0f, 0.0f);
        nearbyFish.clear();
        if (useCollisionDetection) {
            this.rootNode.findCollisions((Spatial)this, nearbyFish);
            this.view(nearbyFish);
        }
        if (this.fishInSight > 0) {
            this.relativePositionSumInSight.normalizeLocal();
            this.orientationSumInSight.normalizeLocal();
        }
        this.orientation.normalizeLocal();
        if (this.fishTooNear > 0) {
            this.relativePositionSumTooNear.normalizeLocal();
            this.relativePositionSumTooNear.multLocal(-0.2f);
            this.orientation.scaleAdd(0.7f, this.orientation, this.relativePositionSumTooNear);
            this.relativePositionSumInSight.multLocal(-0.1f);
            this.orientation.addLocal(this.relativePositionSumInSight);
        } else if (this.fishInSight > 0) {
            this.relativePositionSumInSight.multLocal(0.15f);
            this.orientation.scaleAdd(0.7f, this.orientation, this.relativePositionSumInSight);
            this.orientationSumInSight.multLocal(0.15f);
            this.orientation.addLocal(this.orientationSumInSight);
        }
        if (this.getLocalTranslation().length() > 3.0f) {
            this.tmp_pos.set(this.getLocalTranslation());
            float f = -1.0f / this.getLocalTranslation().length() * (this.getLocalTranslation().length() - 3.0f) * 0.3f;
            if (f > 1.0f) {
                f = 1.0f;
            }
            this.tmp_pos.multLocal(f);
            this.orientation.scaleAdd(1.0f - f, this.tmp_pos);
        }
        this.orientation.normalizeLocal();
        this.orientation.multLocal(this.speed);
        this.getLocalTranslation().addLocal(this.orientation);
    }

    private void view(CollisionResults collisionResults) {
        for (int i = collisionResults.getNumber() - 1; i >= 0; --i) {
            Fish fish;
            Node node = collisionResults.getCollisionData(i).getSourceMesh().getParent();
            if (!(node instanceof Fish) || (fish = (Fish)node) == this) continue;
            this.relativePosition.set(fish.getLocalTranslation());
            this.relativePosition.subtractLocal(this.getLocalTranslation());
            float f = this.relativePosition.length();
            if (!(f < 0.1f)) continue;
            ++this.fishInSight;
            this.relativePositionSumInSight.addLocal(this.relativePosition);
            this.orientationSumInSight.addLocal(fish.getOrientation());
            if (!(f < 0.02f)) continue;
            ++this.fishTooNear;
            this.relativePositionSumTooNear.addLocal(this.relativePosition);
        }
    }
}

