/*
 * Decompiled with CFR 0.152.
 */
package jmetest.stress.swarm;

import com.jme.input.KeyBindingManager;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.util.LoggingSystem;
import java.util.Random;
import java.util.logging.Level;
import jmetest.stress.StressApp;
import jmetest.stress.swarm.CollisionTreeManager;
import jmetest.stress.swarm.Fish;

public class TestSwarm
extends StressApp {
    private boolean doReorganizeScenegraph = true;
    private CollisionTreeManager collisionTreeManager;
    private static final String COMMAND_REORGANIZATION = "toggle_reorganization";
    private static final int NUMBER_OF_FISH = 1000;
    private static final String COMMAND_COLLISION = "toggle_collision";
    private long startTime;
    private int frame;

    protected void simpleInitGame() {
        Fish fish;
        int n;
        long l = System.currentTimeMillis();
        Random random = new Random(1L);
        this.collisionTreeManager = new CollisionTreeManager(this.rootNode, new float[]{0.2f, 1.2f});
        for (n = 0; n < 100; ++n) {
            fish = new Fish(0.0f + random.nextFloat() - 0.5f, 0.0f + random.nextFloat() - 0.5f, 0.0f, random.nextFloat() - 0.5f, random.nextFloat() - 0.5f, 0.0f, 0.001f, this.rootNode);
            this.collisionTreeManager.add((Spatial)fish);
        }
        for (n = 0; n < 200; ++n) {
            fish = new Fish(0.0f + random.nextFloat() - 0.5f, random.nextFloat() - 0.5f, 0.0f, random.nextFloat() - 0.5f, random.nextFloat() - 0.5f, 0.0f, 0.005f, this.rootNode);
            this.collisionTreeManager.add((Spatial)fish);
        }
        for (n = 0; n < 700; ++n) {
            fish = new Fish(0.0f + random.nextFloat() - 0.5f, 0.0f + random.nextFloat() - 0.5f, 0.0f, random.nextFloat() - 0.5f, random.nextFloat() - 0.5f, 0.0f, 0.01f, this.rootNode);
            this.collisionTreeManager.add((Spatial)fish);
        }
        this.cam.getLocation().set(0.0f, 0.0f, 5.0f);
        this.cam.update();
        KeyBindingManager.getKeyBindingManager().set(COMMAND_REORGANIZATION, 19);
        Text text = this.createText("Press R to toggle scene graph reorganization (node tree / flat)");
        text.getLocalTranslation().set(0.0f, 20.0f, 0.0f);
        this.fpsNode.attachChild((Spatial)text);
        KeyBindingManager.getKeyBindingManager().set(COMMAND_COLLISION, 22);
        fish = this.createText("Press U to toggle collision detection use (fish perception on/off)");
        fish.getLocalTranslation().set(0.0f, 40.0f, 0.0f);
        this.fpsNode.attachChild((Spatial)fish);
        long l2 = System.currentTimeMillis() - l;
        System.out.println("Setup took " + l2 + " ms (below 100 ms very inaccurate).");
        this.startTime = System.currentTimeMillis();
    }

    protected void simpleUpdate() {
        if (KeyBindingManager.getKeyBindingManager().isValidCommand(COMMAND_REORGANIZATION, false)) {
            boolean bl = this.doReorganizeScenegraph = !this.doReorganizeScenegraph;
            if (!this.doReorganizeScenegraph) {
                this.collisionTreeManager.disable();
            }
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand(COMMAND_COLLISION, false)) {
            boolean bl = Fish.useCollisionDetection = !Fish.useCollisionDetection;
        }
        if (this.doReorganizeScenegraph) {
            this.collisionTreeManager.reorganize();
        }
        ++this.frame;
        if (this.frame == 100) {
            long l = System.currentTimeMillis() - this.startTime;
            System.out.println("First 100 frames took " + l + " ms.");
        }
    }

    public static void main(String[] stringArray) {
        LoggingSystem.getLogger().setLevel(Level.WARNING);
        new TestSwarm().start();
    }
}

