/*
 * Decompiled with CFR 0.152.
 */
package jmetest.terrain;

import com.jme.app.SimpleGame;
import com.jme.image.Texture;
import com.jme.input.NodeHandler;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.CameraNode;
import com.jme.scene.Spatial;
import com.jme.scene.state.CullState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.terrain.TerrainPage;
import com.jmex.terrain.util.AbstractHeightMap;
import com.jmex.terrain.util.FluidSimHeightMap;
import com.jmex.terrain.util.ProceduralTextureGenerator;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;
import jmetest.terrain.TestTerrain;

public class TestFluidSimHeightmap
extends SimpleGame {
    public static void main(String[] stringArray) {
        TestFluidSimHeightmap testFluidSimHeightmap = new TestFluidSimHeightmap();
        testFluidSimHeightmap.setDialogBehaviour(2);
        testFluidSimHeightmap.start();
    }

    protected void simpleInitGame() {
        this.display.setTitle("Fluid Simulation Heightmap");
        CameraNode cameraNode = new CameraNode("Camera Node", this.cam);
        cameraNode.setLocalTranslation(new Vector3f(0.0f, 250.0f, -20.0f));
        cameraNode.updateWorldData(0.0f);
        this.input = new NodeHandler((Spatial)cameraNode, 150.0f, 1.0f);
        this.rootNode.attachChild((Spatial)cameraNode);
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(2);
        cullState.setEnabled(true);
        this.rootNode.setRenderState((RenderState)cullState);
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight.setDirection(new Vector3f(1.0f, -0.5f, 1.0f));
        directionalLight.setEnabled(true);
        this.lightState.attach((Light)directionalLight);
        FluidSimHeightMap fluidSimHeightMap = new FluidSimHeightMap(129, 120);
        fluidSimHeightMap.setHeightScale(0.001f);
        Vector3f vector3f = new Vector3f(10.0f, 1.0f, 10.0f);
        TerrainPage terrainPage = new TerrainPage("Terrain", 33, fluidSimHeightMap.getSize(), vector3f, fluidSimHeightMap.getHeightMap(), false);
        terrainPage.setDetailTexture(1, 16);
        this.rootNode.attachChild((Spatial)terrainPage);
        ProceduralTextureGenerator proceduralTextureGenerator = new ProceduralTextureGenerator((AbstractHeightMap)fluidSimHeightMap);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/grassb.png")), -128, 0, 128);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg")), 0, 128, 255);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/highest.jpg")), 128, 255, 384);
        proceduralTextureGenerator.createTexture(256);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        Texture texture = TextureManager.loadTexture((Image)proceduralTextureGenerator.getImageIcon().getImage(), (int)6, (int)1, (boolean)true);
        textureState.setTexture(texture, 0);
        Texture texture2 = TextureManager.loadTexture((URL)TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/Detail.jpg"), (int)6, (int)1);
        textureState.setTexture(texture2, 1);
        texture2.setWrap(3);
        texture.setApply(4);
        texture.setCombineFuncRGB(1);
        texture.setCombineSrc0RGB(0);
        texture.setCombineOp0RGB(0);
        texture.setCombineSrc1RGB(1);
        texture.setCombineOp1RGB(0);
        texture.setCombineScaleRGB(1.0f);
        texture2.setApply(4);
        texture2.setCombineFuncRGB(3);
        texture2.setCombineSrc0RGB(0);
        texture2.setCombineOp0RGB(0);
        texture2.setCombineSrc1RGB(3);
        texture2.setCombineOp1RGB(0);
        texture2.setCombineScaleRGB(1.0f);
        this.rootNode.setRenderState((RenderState)textureState);
    }
}

