/*
 * Decompiled with CFR 0.152.
 */
package jmetest.terrain;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.light.PointLight;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.state.CullState;
import com.jme.scene.state.FogState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.terrain.TerrainBlock;
import com.jmex.terrain.util.AbstractHeightMap;
import com.jmex.terrain.util.ImageBasedHeightMap;
import com.jmex.terrain.util.ProceduralSplatTextureGenerator;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;

public class TestProceduralSplatTexture
extends SimpleGame {
    public static void main(String[] stringArray) {
        TestProceduralSplatTexture testProceduralSplatTexture = new TestProceduralSplatTexture();
        testProceduralSplatTexture.setDialogBehaviour(2);
        testProceduralSplatTexture.start();
    }

    protected void simpleInitGame() {
        try {
            this.display.setTitle("ProceduralSplatTexture Test");
            this.cam.setLocation(new Vector3f(320.0f, 125.0f, 320.0f));
            this.cam.update();
            FogState fogState = this.display.getRenderer().createFogState();
            fogState.setEnabled(false);
            this.rootNode.setRenderState((RenderState)fogState);
            CullState cullState = this.display.getRenderer().createCullState();
            cullState.setCullMode(2);
            cullState.setEnabled(true);
            this.lightState.setTwoSidedLighting(true);
            ((PointLight)this.lightState.get(0)).setLocation(new Vector3f(100.0f, 500.0f, 50.0f));
            URL uRL = TestProceduralSplatTexture.class.getClassLoader().getResource("jmetest/data/texture/terrain.png");
            ImageBasedHeightMap imageBasedHeightMap = new ImageBasedHeightMap(new ImageIcon(uRL).getImage());
            Vector3f vector3f = new Vector3f(5.0f, 0.25f, 5.0f);
            TerrainBlock terrainBlock = new TerrainBlock("Terrain", imageBasedHeightMap.getSize(), vector3f, imageBasedHeightMap.getHeightMap(), new Vector3f(0.0f, 0.0f, 0.0f), true);
            terrainBlock.setDistanceTolerance(1.0f);
            terrainBlock.setDetailTexture(1, 16);
            terrainBlock.setModelBound((BoundingVolume)new BoundingBox());
            terrainBlock.updateModelBound();
            terrainBlock.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
            this.rootNode.attachChild((Spatial)terrainBlock);
            this.rootNode.setRenderState((RenderState)cullState);
            ProceduralSplatTextureGenerator proceduralSplatTextureGenerator = new ProceduralSplatTextureGenerator((AbstractHeightMap)imageBasedHeightMap);
            proceduralSplatTextureGenerator.addTexture(new ImageIcon(TestProceduralSplatTexture.class.getClassLoader().getResource("jmetest/data/texture/grassb.png")), -128, 0, 128);
            proceduralSplatTextureGenerator.addTexture(new ImageIcon(TestProceduralSplatTexture.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg")), 0, 128, 255);
            proceduralSplatTextureGenerator.addTexture(new ImageIcon(TestProceduralSplatTexture.class.getClassLoader().getResource("jmetest/data/texture/highest.jpg")), 128, 255, 384);
            proceduralSplatTextureGenerator.addSplatTexture(new ImageIcon(TestProceduralSplatTexture.class.getClassLoader().getResource("jmetest/data/texture/terrainTex.png")), new ImageIcon(TestProceduralSplatTexture.class.getClassLoader().getResource("jmetest/data/texture/water.png")));
            proceduralSplatTextureGenerator.createTexture(512);
            TextureState textureState = this.display.getRenderer().createTextureState();
            textureState.setEnabled(true);
            Texture texture = TextureManager.loadTexture((Image)proceduralSplatTextureGenerator.getImageIcon().getImage(), (int)6, (int)1, (boolean)true);
            textureState.setTexture(texture, 0);
            Texture texture2 = TextureManager.loadTexture((URL)TestProceduralSplatTexture.class.getClassLoader().getResource("jmetest/data/texture/Detail.jpg"), (int)6, (int)1);
            textureState.setTexture(texture2, 1);
            texture2.setWrap(3);
            texture.setApply(4);
            texture.setCombineFuncRGB(1);
            texture.setCombineSrc0RGB(0);
            texture.setCombineOp0RGB(0);
            texture.setCombineSrc1RGB(1);
            texture.setCombineOp1RGB(0);
            texture.setCombineScaleRGB(1.0f);
            texture2.setApply(4);
            texture2.setCombineFuncRGB(3);
            texture2.setCombineSrc0RGB(0);
            texture2.setCombineOp0RGB(0);
            texture2.setCombineSrc1RGB(3);
            texture2.setCombineOp1RGB(0);
            texture2.setCombineScaleRGB(1.0f);
            this.rootNode.setRenderState((RenderState)textureState);
            this.rootNode.setRenderQueueMode(2);
            this.fpsNode.setRenderQueueMode(2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

