/*
 * Decompiled with CFR 0.152.
 */
package jmetest.terrain;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.light.PointLight;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.state.CullState;
import com.jme.scene.state.FogState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jme.util.geom.Debugger;
import com.jmex.terrain.TerrainBlock;
import com.jmex.terrain.util.AbstractHeightMap;
import com.jmex.terrain.util.MidPointHeightMap;
import com.jmex.terrain.util.ProceduralTextureGenerator;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;

public class TestTerrain
extends SimpleGame {
    private TerrainBlock tb;

    public static void main(String[] stringArray) {
        TestTerrain testTerrain = new TestTerrain();
        testTerrain.setDialogBehaviour(2);
        testTerrain.start();
    }

    protected void simpleUpdate() {
        super.simpleUpdate();
        this.tb.updateFromHeightMap();
    }

    protected void simpleInitGame() {
        this.display.setTitle("Terrain Test");
        this.cam.setLocation(new Vector3f(320.0f, 250.0f, 320.0f));
        this.cam.update();
        FogState fogState = this.display.getRenderer().createFogState();
        fogState.setEnabled(false);
        this.rootNode.setRenderState((RenderState)fogState);
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(2);
        cullState.setEnabled(true);
        this.lightState.setTwoSidedLighting(true);
        Debugger.AUTO_NORMAL_RATIO = 0.02f;
        ((PointLight)this.lightState.get(0)).setLocation(new Vector3f(100.0f, 500.0f, 50.0f));
        MidPointHeightMap midPointHeightMap = new MidPointHeightMap(128, 1.9f);
        Vector3f vector3f = new Vector3f(5.0f, 1.0f, 5.0f);
        this.tb = new TerrainBlock("Terrain", midPointHeightMap.getSize(), vector3f, midPointHeightMap.getHeightMap(), new Vector3f(0.0f, 0.0f, 0.0f), false);
        this.tb.setDistanceTolerance(1.0f);
        this.tb.setDetailTexture(1, 16);
        this.tb.setModelBound((BoundingVolume)new BoundingBox());
        this.tb.updateModelBound();
        this.tb.setLocalTranslation(new Vector3f(0.0f, 0.0f, 0.0f));
        this.rootNode.attachChild((Spatial)this.tb);
        this.rootNode.setRenderState((RenderState)cullState);
        ProceduralTextureGenerator proceduralTextureGenerator = new ProceduralTextureGenerator((AbstractHeightMap)midPointHeightMap);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/grassb.png")), -128, 0, 128);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg")), 0, 128, 255);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/highest.jpg")), 128, 255, 384);
        proceduralTextureGenerator.createTexture(64);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        Texture texture = TextureManager.loadTexture((Image)proceduralTextureGenerator.getImageIcon().getImage(), (int)6, (int)1, (boolean)true);
        texture.setStoreTexture(true);
        textureState.setTexture(texture, 0);
        Texture texture2 = TextureManager.loadTexture((URL)TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/Detail.jpg"), (int)6, (int)1);
        textureState.setTexture(texture2, 1);
        texture2.setWrap(3);
        texture.setApply(4);
        texture.setCombineFuncRGB(1);
        texture.setCombineSrc0RGB(0);
        texture.setCombineOp0RGB(0);
        texture.setCombineSrc1RGB(1);
        texture.setCombineOp1RGB(0);
        texture.setCombineScaleRGB(1.0f);
        texture2.setApply(4);
        texture2.setCombineFuncRGB(3);
        texture2.setCombineSrc0RGB(0);
        texture2.setCombineOp0RGB(0);
        texture2.setCombineSrc1RGB(3);
        texture2.setCombineOp1RGB(0);
        texture2.setCombineScaleRGB(1.0f);
        this.rootNode.setRenderState((RenderState)textureState);
        this.rootNode.setRenderQueueMode(2);
        this.fpsNode.setRenderQueueMode(2);
    }
}

