/*
 * Decompiled with CFR 0.152.
 */
package jmetest.terrain;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.input.NodeHandler;
import com.jme.light.Light;
import com.jme.light.LightNode;
import com.jme.light.PointLight;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.CameraNode;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.state.CullState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.effects.LensFlare;
import com.jmex.effects.LensFlareFactory;
import com.jmex.terrain.TerrainBlock;
import com.jmex.terrain.util.MidPointHeightMap;
import java.net.URL;
import jmetest.terrain.TestTerrain;

public class TestTerrainLighting
extends SimpleGame {
    private CameraNode camNode;
    private Vector3f currentPos;
    private Vector3f newPos;
    private LightNode lightNode;
    private LensFlare flare;

    public static void main(String[] stringArray) {
        TestTerrainLighting testTerrainLighting = new TestTerrainLighting();
        testTerrainLighting.setDialogBehaviour(2);
        testTerrainLighting.start();
    }

    protected void simpleUpdate() {
        if ((int)this.currentPos.x == (int)this.newPos.x && (int)this.currentPos.z == (int)this.newPos.z) {
            this.newPos.x = FastMath.nextRandomFloat() * 128.0f * 5.0f;
            this.newPos.z = FastMath.nextRandomFloat() * 128.0f * 5.0f;
        }
        this.currentPos.x -= (this.currentPos.x - this.newPos.x) / (this.timer.getFrameRate() / 2.0f);
        this.currentPos.y = 255.0f;
        this.currentPos.z -= (this.currentPos.z - this.newPos.z) / (this.timer.getFrameRate() / 2.0f);
        this.lightNode.setLocalTranslation(this.currentPos);
    }

    protected void simpleInitGame() {
        this.rootNode.setRenderQueueMode(2);
        this.fpsNode.setRenderQueueMode(2);
        this.currentPos = new Vector3f();
        this.newPos = new Vector3f();
        this.cam.setFrustum(1.0f, 1000.0f, -0.55f, 0.55f, 0.4125f, -0.4125f);
        this.cam.update();
        this.camNode = new CameraNode("Camera Node", this.cam);
        this.camNode.setLocalTranslation(new Vector3f(0.0f, 250.0f, -20.0f));
        this.camNode.updateWorldData(0.0f);
        this.input = new NodeHandler((Spatial)this.camNode, 50.0f, 0.5f);
        this.display.setTitle("Terrain Test");
        PointLight pointLight = new PointLight();
        pointLight.setEnabled(true);
        pointLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        pointLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        pointLight.setLocation(new Vector3f(0.5f, -0.5f, 0.0f));
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(2);
        cullState.setEnabled(true);
        this.lightState.setTwoSidedLighting(true);
        this.lightNode = new LightNode("light", this.lightState);
        this.lightNode.setLight((Light)pointLight);
        Vector3f vector3f = new Vector3f(-0.5f, -0.5f, -0.5f);
        Vector3f vector3f2 = new Vector3f(0.5f, 0.5f, 0.5f);
        Box box = new Box("box", vector3f, vector3f2);
        box.setModelBound((BoundingVolume)new BoundingBox());
        box.updateModelBound();
        this.lightNode.attachChild((Spatial)box);
        this.lightNode.setTarget((Spatial)this.rootNode);
        TextureState[] textureStateArray = new TextureState[4];
        textureStateArray[0] = this.display.getRenderer().createTextureState();
        textureStateArray[0].setTexture(TextureManager.loadTexture((URL)LensFlare.class.getClassLoader().getResource("jmetest/data/texture/flare1.png"), (int)6, (int)1, (int)3, (float)1.0f, (boolean)true));
        textureStateArray[0].setEnabled(true);
        textureStateArray[1] = this.display.getRenderer().createTextureState();
        textureStateArray[1].setTexture(TextureManager.loadTexture((URL)LensFlare.class.getClassLoader().getResource("jmetest/data/texture/flare2.png"), (int)6, (int)1));
        textureStateArray[1].setEnabled(true);
        textureStateArray[2] = this.display.getRenderer().createTextureState();
        textureStateArray[2].setTexture(TextureManager.loadTexture((URL)LensFlare.class.getClassLoader().getResource("jmetest/data/texture/flare3.png"), (int)6, (int)1));
        textureStateArray[2].setEnabled(true);
        textureStateArray[3] = this.display.getRenderer().createTextureState();
        textureStateArray[3].setTexture(TextureManager.loadTexture((URL)LensFlare.class.getClassLoader().getResource("jmetest/data/texture/flare4.png"), (int)6, (int)1));
        textureStateArray[3].setEnabled(true);
        this.flare = LensFlareFactory.createBasicLensFlare((String)"flare", (TextureState[])textureStateArray);
        this.flare.setLocalScale(0.5f);
        this.flare.setRootNode(this.rootNode);
        this.lightNode.attachChild((Spatial)this.flare);
        MidPointHeightMap midPointHeightMap = new MidPointHeightMap(128, 1.5f);
        Vector3f vector3f3 = new Vector3f(5.0f, 1.0f, 5.0f);
        TerrainBlock terrainBlock = new TerrainBlock("Terrain", midPointHeightMap.getSize(), vector3f3, midPointHeightMap.getHeightMap(), new Vector3f(0.0f, 0.0f, 0.0f), false);
        terrainBlock.setDetailTexture(1, 4);
        terrainBlock.setModelBound((BoundingVolume)new BoundingBox());
        terrainBlock.updateModelBound();
        this.rootNode.attachChild((Spatial)terrainBlock);
        this.rootNode.setRenderState((RenderState)cullState);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(false);
        Texture texture = TextureManager.loadTexture((URL)TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/grassb.png"), (int)6, (int)1);
        textureState.setTexture(texture, 0);
        Texture texture2 = TextureManager.loadTexture((URL)TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/Detail.jpg"), (int)6, (int)1);
        textureState.setTexture(texture2, 1);
        texture2.setWrap(3);
        texture.setApply(4);
        texture.setCombineFuncRGB(1);
        texture.setCombineSrc0RGB(0);
        texture.setCombineOp0RGB(0);
        texture.setCombineSrc1RGB(1);
        texture.setCombineOp1RGB(0);
        texture.setCombineScaleRGB(1.0f);
        texture2.setApply(4);
        texture2.setCombineFuncRGB(3);
        texture2.setCombineSrc0RGB(0);
        texture2.setCombineOp0RGB(0);
        texture2.setCombineSrc1RGB(3);
        texture2.setCombineOp1RGB(0);
        texture2.setCombineScaleRGB(1.0f);
        this.rootNode.setRenderState((RenderState)textureState);
        this.rootNode.attachChild((Spatial)this.lightNode);
        this.rootNode.attachChild((Spatial)this.camNode);
    }
}

