/*
 * Decompiled with CFR 0.152.
 */
package jmetest.terrain;

import com.jme.app.SimpleGame;
import com.jme.image.Texture;
import com.jme.input.NodeHandler;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.CameraNode;
import com.jme.scene.Spatial;
import com.jme.scene.state.CullState;
import com.jme.scene.state.FogState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.terrain.TerrainPage;
import com.jmex.terrain.util.AbstractHeightMap;
import com.jmex.terrain.util.FaultFractalHeightMap;
import com.jmex.terrain.util.ProceduralTextureGenerator;
import java.awt.Image;
import java.net.URL;
import javax.swing.ImageIcon;
import jmetest.terrain.TestTerrain;

public class TestTerrainPage
extends SimpleGame {
    private CameraNode camNode;
    private TerrainPage page;

    public static void main(String[] stringArray) {
        TestTerrainPage testTerrainPage = new TestTerrainPage();
        testTerrainPage.setDialogBehaviour(2);
        testTerrainPage.start();
    }

    protected void simpleInitGame() {
        this.rootNode.setRenderQueueMode(2);
        this.fpsNode.setRenderQueueMode(4);
        DirectionalLight directionalLight = new DirectionalLight();
        directionalLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight.setDirection(new Vector3f(1.0f, -0.5f, 1.0f));
        directionalLight.setEnabled(true);
        this.lightState.attach((Light)directionalLight);
        this.cam.setFrustum(1.0f, 1000.0f, -0.55f, 0.55f, 0.4125f, -0.4125f);
        this.cam.update();
        this.camNode = new CameraNode("Camera Node", this.cam);
        this.camNode.setLocalTranslation(new Vector3f(0.0f, 250.0f, -20.0f));
        this.camNode.updateWorldData(0.0f);
        this.input = new NodeHandler((Spatial)this.camNode, 150.0f, 1.0f);
        this.rootNode.attachChild((Spatial)this.camNode);
        this.display.setTitle("Terrain Test");
        this.display.getRenderer().setBackgroundColor(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        DirectionalLight directionalLight2 = new DirectionalLight();
        directionalLight2.setEnabled(true);
        directionalLight2.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        directionalLight2.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        directionalLight2.setDirection(new Vector3f(0.5f, -0.5f, 0.0f).normalizeLocal());
        CullState cullState = this.display.getRenderer().createCullState();
        cullState.setCullMode(2);
        cullState.setEnabled(true);
        this.rootNode.setRenderState((RenderState)cullState);
        this.lightState.attach((Light)directionalLight2);
        FaultFractalHeightMap faultFractalHeightMap = new FaultFractalHeightMap(257, 32, 0, 255, 0.75f);
        Vector3f vector3f = new Vector3f(10.0f, 1.0f, 10.0f);
        faultFractalHeightMap.setHeightScale(0.001f);
        this.page = new TerrainPage("Terrain", 33, faultFractalHeightMap.getSize(), vector3f, faultFractalHeightMap.getHeightMap(), false);
        this.page.setDetailTexture(1, 16);
        this.rootNode.attachChild((Spatial)this.page);
        ProceduralTextureGenerator proceduralTextureGenerator = new ProceduralTextureGenerator((AbstractHeightMap)faultFractalHeightMap);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/grassb.png")), -128, 0, 128);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/dirt.jpg")), 0, 128, 255);
        proceduralTextureGenerator.addTexture(new ImageIcon(TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/highest.jpg")), 128, 255, 384);
        proceduralTextureGenerator.createTexture(512);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        Texture texture = TextureManager.loadTexture((Image)proceduralTextureGenerator.getImageIcon().getImage(), (int)6, (int)1, (boolean)true);
        textureState.setTexture(texture, 0);
        Texture texture2 = TextureManager.loadTexture((URL)TestTerrain.class.getClassLoader().getResource("jmetest/data/texture/Detail.jpg"), (int)6, (int)1);
        textureState.setTexture(texture2, 1);
        texture2.setWrap(3);
        texture.setApply(4);
        texture.setCombineFuncRGB(1);
        texture.setCombineSrc0RGB(0);
        texture.setCombineOp0RGB(0);
        texture.setCombineSrc1RGB(1);
        texture.setCombineOp1RGB(0);
        texture.setCombineScaleRGB(1.0f);
        texture2.setApply(4);
        texture2.setCombineFuncRGB(3);
        texture2.setCombineSrc0RGB(0);
        texture2.setCombineOp0RGB(0);
        texture2.setCombineSrc1RGB(3);
        texture2.setCombineOp1RGB(0);
        texture2.setCombineScaleRGB(1.0f);
        this.rootNode.setRenderState((RenderState)textureState);
        FogState fogState = this.display.getRenderer().createFogState();
        fogState.setDensity(0.5f);
        fogState.setEnabled(true);
        fogState.setColor(new ColorRGBA(0.5f, 0.5f, 0.5f, 0.5f));
        fogState.setEnd(1000.0f);
        fogState.setStart(500.0f);
        fogState.setDensityFunction(0);
        fogState.setApplyFunction(0);
        this.rootNode.setRenderState((RenderState)fogState);
    }
}

