/*
 * Decompiled with CFR 0.152.
 */
package jmetest.text;

import com.jme.app.SimpleGame;
import com.jme.input.KeyBindingManager;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.state.CullState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.util.LoggingSystem;
import com.jmex.font2d.Font2D;
import com.jmex.font2d.Text2D;
import com.jmex.font3d.Font3D;
import com.jmex.font3d.Text3D;
import com.jmex.font3d.effects.Font3DTexture;
import java.awt.Font;
import java.util.logging.Level;
import jmetest.renderer.state.TestTextureState;

public class Test3DText
extends SimpleGame {
    private Font3D myfont;

    public static void main(String[] stringArray) {
        LoggingSystem.getLogger().setLevel(Level.OFF);
        Test3DText test3DText = new Test3DText();
        test3DText.setDialogBehaviour(2);
        test3DText.start();
    }

    protected void simpleInitGame() {
        ZBufferState zBufferState;
        Text2D text2D;
        Text3D text3D;
        this.display.setTitle("Test Text3D");
        this.myfont = new Font3D(new Font("Arial", 0, 2), 0.1, true, true, true);
        Font3DTexture font3DTexture = new Font3DTexture(TestTextureState.class.getClassLoader().getResource("jmetest/data/model/marble.bmp"));
        font3DTexture.applyEffect(this.myfont);
        for (int i = 0; i < 3; ++i) {
            text3D = this.myfont.createText("---- (" + i + ") ---- Text3D is nice !!!", 2.0f, 0);
            text2D = new ColorRGBA(1.0f, (float)Math.random(), (float)Math.random(), 1.0f);
            text3D.setFontColor((ColorRGBA)text2D);
            text3D.setLocalTranslation(new Vector3f(2.0f, (float)(i * 2), 0.0f));
            text3D.setLocalRotation(new Quaternion().fromAngleNormalAxis((float)Math.PI * 2 * ((float)i / 20.0f), Vector3f.UNIT_Y));
            this.rootNode.attachChild((Spatial)text3D);
            if (i % 3 == 0) {
                text3D.setLightCombineMode(0);
            }
            text3D.updateRenderState();
            zBufferState = new Box("ReferenceBox" + i, text3D.getLocalTranslation(), 1.0f, 1.0f, 1.0f);
            zBufferState.setDefaultColor((ColorRGBA)text2D);
            this.rootNode.attachChild((Spatial)zBufferState);
        }
        CullState cullState = DisplaySystem.getDisplaySystem().getRenderer().createCullState();
        cullState.setCullMode(2);
        this.rootNode.setRenderState((RenderState)cullState);
        text3D = new Font2D();
        text2D = text3D.createText("You can press \"u\" to toggle locked/unlocked mode on the glyphs", 10.0f, 0);
        text2D.setLocalTranslation(new Vector3f(100.0f, 100.0f, 0.0f));
        text2D.setRenderQueueMode(4);
        zBufferState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
        zBufferState.setFunction(7);
        text2D.setRenderState((RenderState)zBufferState);
        this.rootNode.attachChild((Spatial)text2D);
        text2D = text3D.createText("And you can press \"l\" to toggle lights.", 10.0f, 0);
        text2D.setLocalTranslation(new Vector3f(100.0f, 80.0f, 0.0f));
        text2D.setRenderQueueMode(4);
        zBufferState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
        zBufferState.setFunction(7);
        text2D.setRenderState((RenderState)zBufferState);
        this.rootNode.attachChild((Spatial)text2D);
        KeyBindingManager.getKeyBindingManager().set("toggle_locked_font_mesh", 22);
        KeyBindingManager.getKeyBindingManager().set("update_render_states", 23);
    }

    public void simpleUpdate() {
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_locked_font_mesh", false)) {
            if ((this.myfont.getRenderTriMesh().getLocks() & 2) == 0) {
                System.out.println("Locked !");
                this.myfont.getRenderTriMesh().lockMeshes();
            } else {
                System.out.println("Unlocked !");
                this.myfont.getRenderTriMesh().unlockMeshes();
            }
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("update_render_states", false)) {
            this.rootNode.updateRenderState();
        }
    }
}

