/*
 * Decompiled with CFR 0.152.
 */
package jmetest.util;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.input.InputHandler;
import com.jme.input.KeyInput;
import com.jme.input.action.InputAction;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.InputActionInterface;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.system.DisplaySystem;
import com.jme.util.TextureManager;
import com.jmex.awt.JMECanvas;
import com.jmex.awt.JMECanvasImplementor;
import com.jmex.awt.SimpleCanvasImpl;
import com.jmex.awt.input.AWTMouseInput;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.UIManager;

public class JMESwingTest {
    int width = 640;
    int height = 480;
    private SwingFrame frame = new SwingFrame();

    public JMESwingTest() {
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        new JMESwingTest();
    }

    class MyImplementor
    extends SimpleCanvasImpl {
        private Quaternion rotQuat;
        private float angle;
        private Vector3f axis;
        private Box box;
        long startTime;
        long fps;
        private InputHandler input;

        public MyImplementor(int n, int n2) {
            super(n, n2);
            this.angle = 0.0f;
            this.startTime = 0L;
            this.fps = 0L;
        }

        public void simpleSetup() {
            this.rotQuat = new Quaternion();
            this.axis = new Vector3f(1.0f, 1.0f, 0.5f);
            this.axis.normalizeLocal();
            Vector3f vector3f = new Vector3f(5.0f, 5.0f, 5.0f);
            Vector3f vector3f2 = new Vector3f(-5.0f, -5.0f, -5.0f);
            this.box = new Box("Box", vector3f2, vector3f);
            this.box.setModelBound((BoundingVolume)new BoundingBox());
            this.box.updateModelBound();
            this.box.setLocalTranslation(new Vector3f(0.0f, 0.0f, -10.0f));
            this.box.setRenderQueueMode(1);
            this.rootNode.attachChild((Spatial)this.box);
            this.box.setRandomColors();
            TextureState textureState = this.renderer.createTextureState();
            textureState.setEnabled(true);
            textureState.setTexture(TextureManager.loadTexture((URL)JMESwingTest.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1));
            this.rootNode.setRenderState((RenderState)textureState);
            this.startTime = System.currentTimeMillis() + 5000L;
            this.input = new InputHandler();
            this.input.addAction((InputActionInterface)new InputAction(){

                public void performAction(InputActionEvent inputActionEvent) {
                    System.out.println(inputActionEvent.getTriggerName());
                }
            }, "mouse", Integer.MIN_VALUE, -1, false);
        }

        public void simpleUpdate() {
            this.input.update(this.tpf);
            if (this.tpf < 1.0f) {
                this.angle += this.tpf * 25.0f;
                if (this.angle > 360.0f) {
                    this.angle = 0.0f;
                }
            }
            this.rotQuat.fromAngleNormalAxis(this.angle * ((float)Math.PI / 180), this.axis);
            this.box.setLocalRotation(this.rotQuat);
            if (this.startTime > System.currentTimeMillis()) {
                ++this.fps;
            } else {
                long l = 5000L + (this.startTime - System.currentTimeMillis());
                this.startTime = System.currentTimeMillis() + 5000L;
                System.out.println(this.fps + " frames in " + (float)l / 1000.0f + " seconds = " + (float)this.fps / ((float)l / 1000.0f) + " FPS (average)");
                this.fps = 0L;
            }
        }
    }

    class SwingFrame
    extends JFrame {
        private static final long serialVersionUID = 1L;
        JPanel contentPane;
        JPanel mainPanel = new JPanel();
        Canvas comp = null;
        JButton coolButton = new JButton();
        JButton uncoolButton = new JButton();
        JPanel spPanel = new JPanel();
        JScrollPane scrollPane = new JScrollPane();
        JTree jTree1 = new JTree();
        JCheckBox scaleBox = new JCheckBox("Scale GL Image");
        JPanel colorPanel = new JPanel();
        JLabel colorLabel = new JLabel("BG Color:");
        JMECanvasImplementor impl;

        public SwingFrame() {
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    SwingFrame.this.dispose();
                }
            });
            this.init();
            this.pack();
            new Thread(){
                {
                    this.setDaemon(true);
                }

                public void run() {
                    while (true) {
                        SwingFrame.this.comp.repaint();
                        2.yield();
                    }
                }
            }.start();
        }

        private void init() {
            this.contentPane = (JPanel)this.getContentPane();
            this.contentPane.setLayout(new BorderLayout());
            this.mainPanel.setLayout(new GridBagLayout());
            this.setTitle("JME - SWING INTEGRATION TEST");
            this.comp = DisplaySystem.getDisplaySystem((String)"lwjgl").createCanvas(JMESwingTest.this.width, JMESwingTest.this.height);
            this.comp.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    SwingFrame.this.doResize();
                }
            });
            KeyInput.setProvider((String)"com.jmex.awt.input.AWTKeyInput");
            AWTMouseInput.setup((Canvas)this.comp, (boolean)false);
            this.impl = new MyImplementor(JMESwingTest.this.width, JMESwingTest.this.height);
            JMECanvas jMECanvas = (JMECanvas)this.comp;
            jMECanvas.setImplementor(this.impl);
            jMECanvas.setUpdateInput(true);
            this.coolButton.setText("Cool Button");
            this.uncoolButton.setText("Uncool Button");
            this.colorPanel.setBackground(Color.black);
            this.colorPanel.setToolTipText("Click here to change Panel BG color.");
            this.colorPanel.setBorder(BorderFactory.createRaisedBevelBorder());
            this.colorPanel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    Color color = JColorChooser.showDialog(SwingFrame.this, "Choose new background color:", SwingFrame.this.colorPanel.getBackground());
                    if (color == null) {
                        return;
                    }
                    SwingFrame.this.colorPanel.setBackground(color);
                    SwingFrame.this.comp.setBackground(color);
                }
            });
            this.scaleBox.setOpaque(false);
            this.scaleBox.setSelected(true);
            this.scaleBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SwingFrame.this.comp != null) {
                        SwingFrame.this.doResize();
                    }
                }
            });
            this.spPanel.setLayout(new BorderLayout());
            this.contentPane.add((Component)this.mainPanel, "West");
            this.mainPanel.add((Component)this.scaleBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.mainPanel.add((Component)this.colorLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.mainPanel.add((Component)this.colorPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 25, 25));
            this.mainPanel.add((Component)this.coolButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.mainPanel.add((Component)this.uncoolButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.mainPanel.add((Component)this.spPanel, new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.spPanel.add((Component)this.scrollPane, "Center");
            this.scrollPane.setViewportView(this.jTree1);
            this.comp.setBounds(0, 0, JMESwingTest.this.width, JMESwingTest.this.height);
            this.contentPane.add((Component)this.comp, "Center");
        }

        protected void doResize() {
            if (this.scaleBox != null && this.scaleBox.isSelected()) {
                this.impl.resizeCanvas(this.comp.getWidth(), this.comp.getHeight());
            } else {
                this.impl.resizeCanvas(JMESwingTest.this.width, JMESwingTest.this.height);
            }
        }

        protected void processWindowEvent(WindowEvent windowEvent) {
            super.processWindowEvent(windowEvent);
            if (windowEvent.getID() == 201) {
                System.exit(0);
            }
        }
    }
}

