/*
 * Decompiled with CFR 0.152.
 */
package jmetest.util;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Vector3f;
import com.jme.scene.shape.Box;

public class Sizeof {
    private static final Runtime s_runtime = Runtime.getRuntime();

    public static void main(String[] stringArray) throws Exception {
        Sizeof.runGC();
        Sizeof.usedMemory();
        Object[] objectArray = new Object[1000];
        long l = 0L;
        Vector3f vector3f = new Vector3f(5.0f, 5.0f, 5.0f);
        Vector3f vector3f2 = new Vector3f(-5.0f, -5.0f, -5.0f);
        for (int i = -1; i < 1000; ++i) {
            Box box = null;
            box = new Box("Box", vector3f2, vector3f);
            box.setModelBound((BoundingVolume)new BoundingBox());
            box.updateModelBound();
            box.setRandomColors();
            if (i >= 0) {
                objectArray[i] = box;
                continue;
            }
            box = null;
            Sizeof.runGC();
            l = Sizeof.usedMemory();
        }
        Sizeof.runGC();
        long l2 = Sizeof.usedMemory();
        int n = Math.round((float)(l2 - l) / 1000.0f);
        System.out.println("'before' heap: " + l + ", 'after' heap: " + l2);
        System.out.println("heap delta: " + (l2 - l) + ", {" + objectArray[0].getClass() + "} size = " + n + " bytes");
        for (int i = 0; i < 1000; ++i) {
            objectArray[i] = null;
        }
        objectArray = null;
        System.exit(0);
    }

    private static void runGC() throws Exception {
        for (int i = 0; i < 4; ++i) {
            Sizeof._runGC();
        }
    }

    private static void _runGC() throws Exception {
        long l = Sizeof.usedMemory();
        long l2 = Long.MAX_VALUE;
        for (int i = 0; l < l2 && i < 500; ++i) {
            s_runtime.runFinalization();
            s_runtime.gc();
            Thread.yield();
            l2 = l;
            l = Sizeof.usedMemory();
        }
    }

    private static long usedMemory() {
        return s_runtime.totalMemory() - s_runtime.freeMemory();
    }
}

