/*
 * Decompiled with CFR 0.152.
 */
package jmetest.util;

import com.jme.animation.SpatialTransformer;
import com.jme.app.SimpleGame;
import com.jme.input.KeyBindingManager;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;

public class TestTimerAccuracy
extends SimpleGame {
    private SpatialTransformer spt;
    private final float INTERVAL = 2.0f;
    private int updatedelay = 0;
    private Box static1;
    private Box static2;
    private Box transformer;
    private final String appname = "TestTimer (Press Q to change update delay) Update delay: ";
    private long start = 0L;

    public static void main(String[] stringArray) {
        TestTimerAccuracy testTimerAccuracy = new TestTimerAccuracy();
        testTimerAccuracy.setDialogBehaviour(2);
        testTimerAccuracy.start();
    }

    public void simpleInitGame() {
        this.display.setTitle("TestTimer (Press Q to change update delay) Update delay: none");
        this.static1 = new Box("Static Box 1", new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f));
        this.static2 = new Box("Static Box 2", new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f));
        this.static2.getLocalTranslation().y += 5.0f;
        this.transformer = new Box("Transforming Box", new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f));
        this.cam.setLocation(new Vector3f(1.0f, 2.5f, 12.0f));
        this.rootNode.attachChild((Spatial)this.static1);
        this.rootNode.attachChild((Spatial)this.static2);
        this.rootNode.attachChild((Spatial)this.transformer);
        this.display.getRenderer().setBackgroundColor(ColorRGBA.blue);
        this.setupTransformer();
        KeyBindingManager.getKeyBindingManager().set("change speed", 16);
    }

    private void setupTransformer() {
        this.transformer.removeController((Controller)this.spt);
        this.spt = new SpatialTransformer(1);
        this.spt.setRepeatType(1);
        this.spt.setPosition(0, 0.0f, this.static2.getLocalTranslation());
        this.spt.setPosition(0, 2.0f, this.static1.getLocalTranslation());
        this.spt.setObject((Spatial)this.transformer, 0, -1);
        this.transformer.addController((Controller)this.spt);
        this.spt.interpolateMissing();
        this.spt.setActive(true);
    }

    protected void simpleUpdate() {
        long l;
        long l2;
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("change speed", false)) {
            if (this.updatedelay == 0) {
                this.updatedelay = 1;
                this.display.setTitle("TestTimer (Press Q to change update delay) Update delay: 1 ms");
            } else if (this.updatedelay == 1) {
                this.updatedelay = 20;
                this.display.setTitle("TestTimer (Press Q to change update delay) Update delay: 20 ms");
            } else if (this.updatedelay == 20) {
                this.updatedelay = 0;
                this.display.setTitle("TestTimer (Press Q to change update delay) Update delay: none");
            }
            this.setupTransformer();
            this.start = System.currentTimeMillis();
        }
        if ((l2 = this.start + 2000L) <= (l = System.currentTimeMillis())) {
            if (this.display.getRenderer().getBackgroundColor() == ColorRGBA.blue) {
                this.display.getRenderer().setBackgroundColor(ColorRGBA.black);
            } else if (this.display.getRenderer().getBackgroundColor() == ColorRGBA.black) {
                this.display.getRenderer().setBackgroundColor(ColorRGBA.blue);
            }
            this.start = l2;
        }
        try {
            if (this.updatedelay != 0) {
                Thread.sleep(this.updatedelay);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

