/*
 * Decompiled with CFR 0.152.
 */
package jmetest.TutorialGuide;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.input.action.InputActionEvent;
import com.jme.input.action.InputActionInterface;
import com.jme.input.action.KeyInputAction;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Skybox;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.TriMesh;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.util.TextureManager;
import com.jmex.sound.openAL.SoundSystem;
import java.net.URL;
import java.util.Random;

public class HelloIntersection
extends SimpleGame {
    MaterialState bulletMaterial;
    Sphere target;
    URL laserURL;
    URL hitURL;
    Random r = new Random();
    Skybox sb;
    int laserSound;
    int targetSound;
    int snode;
    private int laserEventID = 1;
    private int hitEventID = 2;

    public static void main(String[] stringArray) {
        HelloIntersection helloIntersection = new HelloIntersection();
        helloIntersection.setDialogBehaviour(2);
        helloIntersection.start();
    }

    protected void simpleInitGame() {
        this.setupSound();
        Text text = new Text("Crosshairs", "+");
        text.setLocalTranslation(new Vector3f((float)this.display.getWidth() / 2.0f - 8.0f, (float)this.display.getHeight() / 2.0f - 8.0f, 0.0f));
        this.fpsNode.attachChild((Spatial)text);
        this.target = new Sphere("my sphere", 15, 15, 1.0f);
        this.target.setModelBound((BoundingVolume)new BoundingSphere());
        this.target.updateModelBound();
        this.rootNode.attachChild((Spatial)this.target);
        this.sb = new Skybox("skybox", 200.0f, 200.0f, 200.0f);
        URL uRL = HelloIntersection.class.getClassLoader().getResource("jmetest/data/texture/clouds.png");
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((URL)uRL, (int)2, (int)1));
        this.sb.setRenderState((RenderState)textureState);
        this.rootNode.attachChild((Spatial)this.sb);
        this.rootNode.setCullMode(3);
        this.input.addAction((InputActionInterface)new FireBullet(), "firebullet", 33, false);
        this.bulletMaterial = this.display.getRenderer().createMaterialState();
        this.bulletMaterial.setEmissive(ColorRGBA.green);
        MaterialState materialState = this.display.getRenderer().createMaterialState();
        materialState.setDiffuse(ColorRGBA.red);
        this.target.setRenderState((RenderState)materialState);
    }

    private void setupSound() {
        SoundSystem.init((Camera)this.display.getRenderer().getCamera(), (int)0);
        this.snode = SoundSystem.createSoundNode();
        this.targetSound = SoundSystem.create3DSample((URL)((Object)((Object)this)).getClass().getResource("/jmetest/data/sound/explosion.wav"));
        this.laserSound = SoundSystem.create3DSample((URL)((Object)((Object)this)).getClass().getResource("/jmetest/data/sound/laser.ogg"));
        SoundSystem.setSampleMaxAudibleDistance((int)this.targetSound, (int)1000);
        SoundSystem.setSampleMaxAudibleDistance((int)this.laserSound, (int)1000);
        SoundSystem.bindEventToSample((int)this.laserSound, (int)this.laserEventID);
        SoundSystem.bindEventToSample((int)this.targetSound, (int)this.hitEventID);
        SoundSystem.addSampleToNode((int)this.laserSound, (int)this.snode);
        SoundSystem.addSampleToNode((int)this.targetSound, (int)this.snode);
    }

    protected void simpleRender() {
        SoundSystem.draw();
    }

    protected void simpleUpdate() {
        SoundSystem.update((float)this.tpf);
    }

    class BulletMover
    extends Controller {
        private static final long serialVersionUID = 1L;
        TriMesh bullet;
        Vector3f direction;
        float speed = 10.0f;
        float lifeTime = 5.0f;

        BulletMover(TriMesh triMesh, Vector3f vector3f) {
            this.bullet = triMesh;
            this.direction = vector3f;
            this.direction.normalizeLocal();
        }

        public void update(float f) {
            this.lifeTime -= f;
            if (this.lifeTime < 0.0f) {
                HelloIntersection.this.rootNode.detachChild((Spatial)this.bullet);
                this.bullet.removeController((Controller)this);
                return;
            }
            Vector3f vector3f = this.bullet.getLocalTranslation();
            vector3f.addLocal(this.direction.mult(f * this.speed));
            this.bullet.setLocalTranslation(vector3f);
            if (this.bullet.getWorldBound().intersects(HelloIntersection.this.target.getWorldBound())) {
                System.out.println("OWCH!!!");
                Vector3f vector3f2 = HelloIntersection.this.target.getWorldTranslation();
                SoundSystem.setSamplePosition((int)HelloIntersection.this.targetSound, (float)vector3f2.x, (float)vector3f2.y, (float)vector3f2.z);
                HelloIntersection.this.target.setLocalTranslation(new Vector3f(HelloIntersection.this.r.nextFloat() * 10.0f, HelloIntersection.this.r.nextFloat() * 10.0f, HelloIntersection.this.r.nextFloat() * 10.0f));
                this.lifeTime = 0.0f;
                SoundSystem.onEvent((int)HelloIntersection.this.snode, (int)HelloIntersection.this.hitEventID);
            }
        }
    }

    class FireBullet
    extends KeyInputAction {
        int numBullets;

        FireBullet() {
        }

        public void performAction(InputActionEvent inputActionEvent) {
            System.out.println("BANG");
            Sphere sphere = new Sphere("bullet" + this.numBullets++, 8, 8, 0.25f);
            sphere.setModelBound((BoundingVolume)new BoundingSphere());
            sphere.updateModelBound();
            sphere.setLocalTranslation(new Vector3f(HelloIntersection.this.cam.getLocation()));
            sphere.setRenderState((RenderState)HelloIntersection.this.bulletMaterial);
            sphere.updateGeometricState(0.0f, true);
            sphere.addController((Controller)new BulletMover((TriMesh)sphere, new Vector3f(HelloIntersection.this.cam.getDirection())));
            HelloIntersection.this.rootNode.attachChild((Spatial)sphere);
            sphere.updateRenderState();
            Vector3f vector3f = HelloIntersection.this.cam.getLocation();
            SoundSystem.setSamplePosition((int)HelloIntersection.this.laserSound, (float)vector3f.x, (float)vector3f.y, (float)vector3f.z);
            SoundSystem.onEvent((int)HelloIntersection.this.snode, (int)HelloIntersection.this.laserEventID);
        }
    }
}

