/*
 * Decompiled with CFR 0.152.
 */
package jmetest.TutorialGuide;

import com.jme.app.BaseGame;
import com.jme.app.SimpleGame;
import com.jme.input.FirstPersonHandler;
import com.jme.input.InputHandler;
import com.jme.input.KeyBindingManager;
import com.jme.input.KeyInput;
import com.jme.input.MouseInput;
import com.jme.input.joystick.JoystickInput;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.Node;
import com.jme.scene.SceneElement;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.shape.Box;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.WireframeState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.system.JmeException;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import com.jme.util.Timer;
import com.jme.util.geom.Debugger;
import java.net.URL;
import java.util.logging.Level;

public class HelloSimpleGame
extends BaseGame {
    protected Camera cam;
    protected Node rootNode;
    protected InputHandler input;
    protected Timer timer;
    protected Node fpsNode;
    protected Text fps;
    protected float tpf;
    protected boolean showBounds = false;
    protected WireframeState wireState;
    protected LightState lightState;
    public static String fontLocation = "com/jme/app/defaultfont.tga";

    public static void main(String[] stringArray) {
        HelloSimpleGame helloSimpleGame = new HelloSimpleGame();
        helloSimpleGame.setDialogBehaviour(2);
        helloSimpleGame.start();
    }

    protected final void update(float f) {
        this.timer.update();
        this.tpf = this.timer.getTimePerFrame();
        this.input.update(this.tpf);
        this.fps.print("FPS: " + (int)this.timer.getFrameRate() + " - " + this.display.getRenderer().getStatistics());
        this.simpleUpdate();
        this.rootNode.updateGeometricState(this.tpf, true);
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_wire", false)) {
            this.wireState.setEnabled(!this.wireState.isEnabled());
            this.rootNode.updateRenderState();
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_lights", false)) {
            this.lightState.setEnabled(!this.lightState.isEnabled());
            this.rootNode.updateRenderState();
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("toggle_bounds", false)) {
            boolean bl = this.showBounds = !this.showBounds;
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("camera_out", false)) {
            System.err.println("Camera at: " + this.display.getRenderer().getCamera().getLocation());
        }
        if (KeyBindingManager.getKeyBindingManager().isValidCommand("exit", false)) {
            this.finish();
        }
    }

    protected final void render(float f) {
        this.display.getRenderer().clearStatistics();
        this.display.getRenderer().clearBuffers();
        this.display.getRenderer().draw((Spatial)this.rootNode);
        if (this.showBounds) {
            Debugger.drawBounds((SceneElement)this.rootNode, (Renderer)this.display.getRenderer());
        }
        this.display.getRenderer().draw((Spatial)this.fpsNode);
        this.simpleRender();
    }

    protected final void initSystem() {
        try {
            this.display = DisplaySystem.getDisplaySystem((String)this.properties.getRenderer());
            this.display.createWindow(this.properties.getWidth(), this.properties.getHeight(), this.properties.getDepth(), this.properties.getFreq(), this.properties.getFullscreen());
            this.cam = this.display.getRenderer().createCamera(this.display.getWidth(), this.display.getHeight());
        }
        catch (JmeException jmeException) {
            jmeException.printStackTrace();
            System.exit(1);
        }
        this.display.getRenderer().setBackgroundColor(ColorRGBA.black);
        this.cam.setFrustumPerspective(45.0f, (float)this.display.getWidth() / (float)this.display.getHeight(), 1.0f, 1000.0f);
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 25.0f);
        Vector3f vector3f2 = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, -1.0f);
        this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
        this.cam.update();
        this.display.getRenderer().setCamera(this.cam);
        FirstPersonHandler firstPersonHandler = new FirstPersonHandler(this.cam, this.properties.getRenderer());
        firstPersonHandler.getKeyboardLookHandler().setActionSpeed(10.0f);
        firstPersonHandler.getMouseLookHandler().setActionSpeed(1.0f);
        this.input = firstPersonHandler;
        this.timer = Timer.getTimer();
        this.display.setTitle("SimpleGame");
        this.display.getRenderer().enableStatistics(true);
        KeyBindingManager.getKeyBindingManager().set("toggle_wire", 20);
        KeyBindingManager.getKeyBindingManager().set("toggle_lights", 38);
        KeyBindingManager.getKeyBindingManager().set("toggle_bounds", 48);
        KeyBindingManager.getKeyBindingManager().set("camera_out", 46);
        KeyBindingManager.getKeyBindingManager().set("exit", 1);
    }

    protected final void initGame() {
        this.rootNode = new Node("rootNode");
        this.wireState = this.display.getRenderer().createWireframeState();
        this.wireState.setEnabled(false);
        this.rootNode.setRenderState((RenderState)this.wireState);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        this.rootNode.setRenderState((RenderState)zBufferState);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        alphaState.setEnabled(true);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((URL)SimpleGame.class.getClassLoader().getResource(fontLocation), (int)2, (int)1));
        textureState.setEnabled(true);
        this.fps = new Text("FPS label", "");
        this.fps.setCullMode(3);
        this.fps.setTextureCombineMode(5);
        this.fpsNode = new Node("FPS node");
        this.fpsNode.attachChild((Spatial)this.fps);
        this.fpsNode.setRenderState((RenderState)textureState);
        this.fpsNode.setRenderState((RenderState)alphaState);
        this.fpsNode.setCullMode(3);
        PointLight pointLight = new PointLight();
        pointLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        pointLight.setAmbient(new ColorRGBA(0.5f, 0.5f, 0.5f, 1.0f));
        pointLight.setLocation(new Vector3f(100.0f, 100.0f, 100.0f));
        pointLight.setEnabled(true);
        this.lightState = this.display.getRenderer().createLightState();
        this.lightState.setEnabled(true);
        this.lightState.attach((Light)pointLight);
        this.rootNode.setRenderState((RenderState)this.lightState);
        this.simpleInitGame();
        this.rootNode.updateGeometricState(0.0f, true);
        this.rootNode.updateRenderState();
        this.fpsNode.updateGeometricState(0.0f, true);
        this.fpsNode.updateRenderState();
    }

    protected void simpleInitGame() {
        this.rootNode.attachChild((Spatial)new Box("my box", new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)));
    }

    protected void simpleUpdate() {
    }

    protected void simpleRender() {
    }

    protected void reinit() {
    }

    protected void cleanup() {
        LoggingSystem.getLogger().log(Level.INFO, "Cleaning up resources.");
        KeyInput.destroyIfInitalized();
        MouseInput.destroyIfInitalized();
        JoystickInput.destroyIfInitalized();
    }
}

