/*
 * Decompiled with CFR 0.152.
 */
package jmetest.awt.applet;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Sphere;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.util.TextureManager;
import com.jme.util.Timer;
import com.jmex.awt.applet.SimpleJMEApplet;
import com.jmex.effects.particles.ParticleFactory;
import com.jmex.effects.particles.ParticleGeometry;
import com.jmex.effects.particles.ParticleInfluence;
import com.jmex.effects.particles.SwarmInfluence;
import java.net.URL;

public class AppletTestParticles
extends SimpleJMEApplet {
    private static final long serialVersionUID = 1L;
    private ParticleGeometry particles;
    private Vector3f currentPos = new Vector3f();
    private Vector3f newPos = new Vector3f();
    private float frameRate = 0.0f;
    private SwarmInfluence swarm;
    private Sphere sphere;

    public void simpleAppletUpdate() {
        float f = this.getTimePerFrame();
        if (f > 1.0f) {
            f = 1.0f;
        }
        if ((int)this.currentPos.x == (int)this.newPos.x && (int)this.currentPos.y == (int)this.newPos.y && (int)this.currentPos.z == (int)this.newPos.z) {
            this.newPos.x = (float)Math.random() * 50.0f - 25.0f;
            this.newPos.y = (float)Math.random() * 50.0f - 25.0f;
            this.newPos.z = (float)Math.random() * 50.0f - 150.0f;
        }
        this.frameRate = Timer.getTimer().getFrameRate() / 2.0f;
        this.currentPos.x -= (this.currentPos.x - this.newPos.x) / this.frameRate;
        this.currentPos.y -= (this.currentPos.y - this.newPos.y) / this.frameRate;
        this.currentPos.z -= (this.currentPos.z - this.newPos.z) / this.frameRate;
        this.particles.setOriginOffset(this.currentPos);
        this.sphere.getLocalTranslation().set(this.currentPos);
        this.swarm.getSwarmOffset().set(this.currentPos);
    }

    public void simpleAppletSetup() {
        this.getLightState().setEnabled(false);
        this.sphere = new Sphere("sp", 12, 12, 3.0f);
        this.sphere.setModelBound((BoundingVolume)new BoundingBox());
        this.sphere.updateModelBound();
        this.sphere.setSolidColor(ColorRGBA.blue);
        this.sphere.setRenderQueueMode(2);
        this.particles = ParticleFactory.buildParticles((String)"particles", (int)30);
        this.particles.setEmissionDirection(new Vector3f(0.0f, 1.0f, 0.0f));
        this.particles.setStartSize(3.0f);
        this.particles.setEndSize(1.5f);
        this.particles.setOriginOffset(new Vector3f(0.0f, 0.0f, 0.0f));
        this.particles.setInitialVelocity(0.05f);
        this.particles.setMinimumLifeTime(5000.0f);
        this.particles.setMaximumLifeTime(15000.0f);
        this.particles.setStartColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
        this.particles.setEndColor(new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f));
        this.particles.setMaximumAngle((float)Math.PI * 2);
        this.particles.getParticleController().setControlFlow(false);
        this.particles.getParticleController().setSpeed(0.75f);
        this.swarm = new SwarmInfluence(new Vector3f(this.particles.getWorldTranslation()), 0.001f);
        this.swarm.setMaxSpeed(0.2f);
        this.swarm.setSpeedBump(0.025f);
        this.swarm.setTurnSpeed((float)Math.PI * 2);
        this.particles.addInfluence((ParticleInfluence)this.swarm);
        AlphaState alphaState = this.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        alphaState.setEnabled(true);
        this.particles.setRenderState((RenderState)alphaState);
        TextureState textureState = this.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((URL)AppletTestParticles.class.getClassLoader().getResource("jmetest/data/texture/flaresmall.jpg"), (int)6, (int)1));
        textureState.setEnabled(true);
        this.particles.setRenderState((RenderState)textureState);
        ZBufferState zBufferState = this.getRenderer().createZBufferState();
        zBufferState.setEnabled(false);
        this.particles.setRenderState((RenderState)zBufferState);
        this.particles.setModelBound((BoundingVolume)new BoundingBox());
        this.particles.updateModelBound();
        this.getRootNode().attachChild((Spatial)this.particles);
        this.getRootNode().attachChild((Spatial)this.sphere);
    }
}

