/*
 * Decompiled with CFR 0.152.
 */
package jmetest.awt.applet;

import com.jme.image.Texture;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.FastMath;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Quad;
import com.jme.scene.state.CullState;
import com.jme.scene.state.FragmentProgramState;
import com.jme.scene.state.LightState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.VertexProgramState;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import com.jme.util.geom.BufferUtils;
import com.jmex.awt.applet.SimpleJMEApplet;
import java.net.URL;
import java.nio.FloatBuffer;
import java.util.logging.Level;

public class AppletTestShaderBumpMapping
extends SimpleJMEApplet {
    private static final long serialVersionUID = 1L;
    private static final String BRICK_TEX = "jmetest/data/images/rockwall2.png";
    private static final String BRICK_HEIGHT = "jmetest/data/images/rockwall_height2.png";
    private static final String BRICK_NRML = "jmetest/data/images/rockwall_normal2.png";
    private static final String BRICK_VP = "jmetest/data/images/bump_parallax.vp";
    private static final String BRICK_FP = "jmetest/data/images/bump_parallax.fp";
    private float angle0 = 0.0f;
    private float angle1 = 0.0f;

    public void simpleAppletSetup() {
        CullState cullState = this.getRenderer().createCullState();
        cullState.setCullMode(2);
        cullState.setEnabled(true);
        TextureState textureState = this.getRenderer().createTextureState();
        Texture texture = TextureManager.loadTexture((URL)AppletTestShaderBumpMapping.class.getClassLoader().getResource(BRICK_TEX), (int)6, (int)1);
        texture.setWrap(3);
        Texture texture2 = TextureManager.loadTexture((URL)AppletTestShaderBumpMapping.class.getClassLoader().getResource(BRICK_HEIGHT), (int)6, (int)1);
        texture2.setWrap(3);
        Texture texture3 = TextureManager.loadTexture((URL)AppletTestShaderBumpMapping.class.getClassLoader().getResource(BRICK_NRML), (int)6, (int)1);
        texture3.setWrap(3);
        textureState.setTexture(texture, 0);
        textureState.setTexture(texture3, 1);
        textureState.setTexture(texture2, 2);
        textureState.setEnabled(true);
        VertexProgramState vertexProgramState = this.getRenderer().createVertexProgramState();
        FragmentProgramState fragmentProgramState = this.getRenderer().createFragmentProgramState();
        if (!vertexProgramState.isSupported() || !fragmentProgramState.isSupported()) {
            LoggingSystem.getLogger().log(Level.SEVERE, "Your graphics card does not support vertex or fragment programs, and thus cannot run this test.");
            this.destroy();
        }
        vertexProgramState.load(AppletTestShaderBumpMapping.class.getClassLoader().getResource(BRICK_VP));
        vertexProgramState.setEnabled(true);
        fragmentProgramState.load(AppletTestShaderBumpMapping.class.getClassLoader().getResource(BRICK_FP));
        fragmentProgramState.setEnabled(true);
        Quad quad = new Quad("wall", 10.0f, 10.0f);
        quad.setRenderState((RenderState)textureState);
        FloatBuffer floatBuffer = BufferUtils.createVector2Buffer((int)4);
        for (int i = 0; i < 4; ++i) {
            floatBuffer.put(1.0f).put(0.0f);
        }
        quad.setTextureBuffer(0, floatBuffer, 1);
        FloatBuffer floatBuffer2 = BufferUtils.createVector2Buffer((int)4);
        for (int i = 0; i < 4; ++i) {
            floatBuffer2.put(0.0f).put(1.0f);
        }
        quad.setTextureBuffer(0, floatBuffer2, 2);
        quad.setRenderState((RenderState)vertexProgramState);
        quad.setRenderState((RenderState)fragmentProgramState);
        quad.setRenderState((RenderState)cullState);
        this.initLights();
        this.getRootNode().attachChild((Spatial)quad);
        this.getRootNode().setCullMode(3);
    }

    private void initLights() {
        PointLight pointLight = new PointLight();
        pointLight.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        pointLight.setLocation(new Vector3f(2.0f, 4.0f, 1.0f));
        pointLight.setEnabled(true);
        PointLight pointLight2 = new PointLight();
        pointLight2.setDiffuse(new ColorRGBA(1.0f, 0.5f, 0.0f, 1.0f));
        pointLight2.setLocation(new Vector3f(2.0f, 2.0f, 1.0f));
        pointLight2.setEnabled(true);
        LightState lightState = this.getLightState();
        lightState.detachAll();
        lightState.setEnabled(true);
        lightState.attach((Light)pointLight);
        lightState.attach((Light)pointLight2);
        lightState.setGlobalAmbient(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
        this.getRootNode().setRenderState((RenderState)lightState);
    }

    public void simpleAppletUpdate() {
        this.angle0 += 2.0f * this.getTimePerFrame();
        this.angle1 += 4.0f * this.getTimePerFrame();
        ((PointLight)this.getLightState().get(0)).setLocation(new Vector3f(2.0f * FastMath.cos((float)this.angle0), 2.0f * FastMath.sin((float)this.angle0), 1.5f));
        ((PointLight)this.getLightState().get(1)).setLocation(new Vector3f(2.0f * FastMath.cos((float)this.angle1), 2.0f * FastMath.sin((float)this.angle1), 1.5f));
    }
}

