/*
 * Decompiled with CFR 0.152.
 */
package jmetest.awt.applet;

import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.light.Light;
import com.jme.light.PointLight;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.pass.Pass;
import com.jme.renderer.pass.ShadowedRenderPass;
import com.jme.scene.Spatial;
import com.jme.scene.shape.PQTorus;
import com.jme.scene.shape.Quad;
import com.jmex.awt.applet.SimpleJMEPassApplet;

public class AppletTestShadows
extends SimpleJMEPassApplet {
    private static final long serialVersionUID = 1L;
    private float rps = 0.5f;
    private float angle = 0.0f;
    private float elapsed = 0.0f;
    private float throttle = 0.033333335f;
    private Quaternion rotQuat = new Quaternion();
    private PointLight p;

    public AppletTestShadows() {
        this.stencilBits = 8;
    }

    public void simpleAppletUpdate() {
        this.elapsed += this.getTimePerFrame();
        if (this.elapsed >= this.throttle) {
            this.angle = this.elapsed * this.rps * ((float)Math.PI * 2);
            this.rotQuat.fromAngleNormalAxis(this.angle, Vector3f.UNIT_Y);
            this.rotQuat.mult(this.p.getLocation(), this.p.getLocation());
            this.elapsed = 0.0f;
        }
    }

    public void simpleAppletSetup() {
        this.getCamera().setLocation(new Vector3f(0.0f, 50.0f, -100.0f));
        this.getCamera().lookAt(Vector3f.ZERO, Vector3f.UNIT_Y);
        ShadowedRenderPass shadowedRenderPass = new ShadowedRenderPass();
        shadowedRenderPass.setLightingMethod(1);
        this.getManager().clearAll();
        this.getManager().add((Pass)shadowedRenderPass);
        this.getLightState().detachAll();
        this.p = new PointLight();
        this.p.setDiffuse(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        this.p.setAmbient(new ColorRGBA(0.8f, 0.8f, 0.8f, 0.4f));
        this.p.getLocation().set(10.0f, 10.0f, -10.0f);
        this.p.setShadowCaster(true);
        this.getLightState().attach((Light)this.p);
        PQTorus pQTorus = new PQTorus("actor", 3.0f, 2.0f, 2.0f, 1.0f, 128, 16);
        pQTorus.setModelBound((BoundingVolume)new BoundingBox());
        pQTorus.updateModelBound();
        Quad quad = new Quad("floor", 100.0f, 100.0f);
        quad.setModelBound((BoundingVolume)new BoundingBox());
        quad.updateModelBound();
        Quaternion quaternion = new Quaternion(new float[]{1.5707964f, 0.0f, 0.0f});
        quad.setLocalRotation(quaternion);
        quad.getLocalTranslation().y -= 2.0f;
        this.getRootNode().attachChild((Spatial)pQTorus);
        this.getRootNode().attachChild((Spatial)quad);
        shadowedRenderPass.add((Spatial)this.getRootNode());
        shadowedRenderPass.addOccluder((Spatial)pQTorus);
    }
}

