/*
 * Decompiled with CFR 0.152.
 */
package jmetest.awt.swingui.dnd;

import com.jme.util.LoggingSystem;
import com.jmex.awt.swingui.dnd.JMEDndException;
import com.jmex.awt.swingui.dnd.JMEDragAndDrop;
import com.jmex.awt.swingui.dnd.JMEDragGestureEvent;
import com.jmex.awt.swingui.dnd.JMEDragGestureListener;
import com.jmex.awt.swingui.dnd.JMEDragSourceEvent;
import com.jmex.awt.swingui.dnd.JMEDragSourceListener;
import com.jmex.awt.swingui.dnd.JMEDropTargetEvent;
import com.jmex.awt.swingui.dnd.JMEDropTargetListener;
import com.jmex.awt.swingui.dnd.JMEMouseDragGestureRecognizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import jmetest.awt.swingui.dnd.TransferableImage;

public class DndImage
extends JInternalFrame
implements JMEDragSourceListener,
JMEDropTargetListener,
JMEDragGestureListener {
    private static final long serialVersionUID = 6297095858466971972L;
    private JLabel label;
    private JLabel info;
    private ImageIcon bgIcon;
    private Logger log = LoggingSystem.getLogger();
    private JMEDragAndDrop dnd;

    public DndImage(JMEDragAndDrop jMEDragAndDrop) {
        this.setLayout(new BorderLayout());
        this.bgIcon = new ImageIcon(DndImage.class.getResource("test.png"));
        this.label = new JLabel(this.bgIcon);
        this.label.setName("DndImage.Label");
        this.add(this.label);
        this.info = new JLabel(" ");
        this.add((Component)this.info, "South");
        this.dnd = jMEDragAndDrop;
        new JMEMouseDragGestureRecognizer(jMEDragAndDrop, (Component)this, 3, (JMEDragGestureListener)this);
    }

    public void dragEnter(JMEDragSourceEvent jMEDragSourceEvent) {
        this.info.setText("dragEnter");
    }

    public void dragExit(JMEDragSourceEvent jMEDragSourceEvent) {
        this.info.setText("dragExit");
    }

    public void dragDropEnd(JMEDragSourceEvent jMEDragSourceEvent) {
        if (!jMEDragSourceEvent.getDropSuccess()) {
            this.label.setIcon(this.bgIcon);
        }
        this.info.setText("dragDropEnd: " + jMEDragSourceEvent.getDropSuccess());
    }

    public void dragEnter(JMEDropTargetEvent jMEDropTargetEvent) {
        this.info.setText("dragEnter");
    }

    public void dragExit(JMEDropTargetEvent jMEDropTargetEvent) {
        this.info.setText("dragExit");
    }

    public void dragOver(JMEDropTargetEvent jMEDropTargetEvent) {
        this.info.setText("dragOver");
    }

    public void drop(JMEDropTargetEvent jMEDropTargetEvent) {
        try {
            jMEDropTargetEvent.acceptDrop(jMEDropTargetEvent.getAction());
            this.label.setIcon((ImageIcon)jMEDropTargetEvent.getTransferable().getTransferData(TransferableImage.IMAGE_FLAVOR));
            jMEDropTargetEvent.dropComplete(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dragGestureRecognized(JMEDragGestureEvent jMEDragGestureEvent) {
        this.info.setText("dragGestureRecognized");
        ImageIcon imageIcon = (ImageIcon)this.label.getIcon();
        if (imageIcon == null) {
            return;
        }
        TransferableImage transferableImage = new TransferableImage(imageIcon);
        try {
            this.dnd.startDrag(jMEDragGestureEvent, imageIcon, (Transferable)transferableImage, (JMEDragSourceListener)this);
            this.label.setIcon(null);
        }
        catch (JMEDndException jMEDndException) {
            this.log.log(Level.INFO, "invalid dnd action", jMEDndException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

