/*
 * Decompiled with CFR 0.152.
 */
package jmetest.awt.swingui.dnd;

import com.jme.util.LoggingSystem;
import com.jmex.awt.swingui.dnd.JMEDndException;
import com.jmex.awt.swingui.dnd.JMEDragAndDrop;
import com.jmex.awt.swingui.dnd.JMEDragGestureEvent;
import com.jmex.awt.swingui.dnd.JMEDragGestureListener;
import com.jmex.awt.swingui.dnd.JMEDragSourceEvent;
import com.jmex.awt.swingui.dnd.JMEDragSourceListener;
import com.jmex.awt.swingui.dnd.JMEDropTargetEvent;
import com.jmex.awt.swingui.dnd.JMEDropTargetListener;
import com.jmex.awt.swingui.dnd.JMEMouseDragGestureRecognizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import jmetest.awt.swingui.dnd.TransferableText;

public class JMEDndPanel
extends JInternalFrame
implements JMEDragSourceListener,
JMEDropTargetListener,
JMEDragGestureListener {
    private static final long serialVersionUID = -6299259970887193861L;
    private JLabel label;
    private JLabel info;
    private Logger log = LoggingSystem.getLogger();
    private JMEDragAndDrop dnd;

    public JMEDndPanel(JMEDragAndDrop jMEDragAndDrop) {
        this.setLayout(new BorderLayout());
        this.label = new JLabel("x" + new Random().nextInt());
        this.label.setName("label");
        this.add(this.label);
        this.info = new JLabel(" ");
        this.add((Component)this.info, "South");
        this.dnd = jMEDragAndDrop;
        new JMEMouseDragGestureRecognizer(jMEDragAndDrop, (Component)this, 3, (JMEDragGestureListener)this);
    }

    public void dragEnter(JMEDragSourceEvent jMEDragSourceEvent) {
        this.info.setText("drag:dragEnter");
    }

    public void dragExit(JMEDragSourceEvent jMEDragSourceEvent) {
        this.info.setText("drag:dragExit");
    }

    public void dragDropEnd(JMEDragSourceEvent jMEDragSourceEvent) {
        this.info.setText("dragDropEnd: " + jMEDragSourceEvent.getDropSuccess());
    }

    public void dragEnter(JMEDropTargetEvent jMEDropTargetEvent) {
        this.info.setText("drag:dragEnter");
    }

    public void dragExit(JMEDropTargetEvent jMEDropTargetEvent) {
        this.info.setText("drag:dragExit");
    }

    public void dragOver(JMEDropTargetEvent jMEDropTargetEvent) {
        this.info.setText("drap:dragOver");
    }

    public void drop(JMEDropTargetEvent jMEDropTargetEvent) {
        this.info.setText("drop");
        try {
            jMEDropTargetEvent.acceptDrop(jMEDropTargetEvent.getAction());
            Transferable transferable = jMEDropTargetEvent.getTransferable();
            String string = (String)transferable.getTransferData(TransferableText.TEXT_FLAVOR);
            this.repaint();
            this.label.setText("dropped text: " + string);
            jMEDropTargetEvent.dropComplete(true);
        }
        catch (Exception exception) {
            System.err.println("drop: " + exception.toString());
            exception.printStackTrace();
        }
    }

    public void dragGestureRecognized(JMEDragGestureEvent jMEDragGestureEvent) {
        String string = this.label.getText();
        TransferableText transferableText = new TransferableText(string);
        ImageIcon imageIcon = JMEDragAndDrop.createTextIcon((JComponent)this, (String)string);
        try {
            this.dnd.startDrag(jMEDragGestureEvent, imageIcon, (Transferable)transferableText, (JMEDragSourceListener)this);
            this.label.setText("drag: " + string);
        }
        catch (JMEDndException jMEDndException) {
            this.label.setText(jMEDndException.getMessage());
            this.log.log(Level.INFO, "invalid dnd action", jMEDndException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

