/*
 * Decompiled with CFR 0.152.
 */
package jmetest.awt.swingui.dnd;

import com.jme.app.SimpleGame;
import com.jme.input.InputHandler;
import com.jme.input.MouseInput;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Spatial;
import com.jme.util.LoggingSystem;
import com.jmex.awt.swingui.JMEDesktop;
import com.jmex.awt.swingui.dnd.JMEDragAndDrop;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.event.AWTEventListener;
import java.util.logging.Logger;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import jmetest.awt.swingui.dnd.DndImage;
import jmetest.awt.swingui.dnd.JMEDndPanel;

public class TestJMEDragAndDrop
extends SimpleGame {
    private static Logger log = LoggingSystem.getLogger();
    private JMEDesktop desktop;
    private JMEDndPanel dndPanel1;
    private JMEDndPanel dndPanel2;
    private DndImage dndImage1;
    private DndImage dndImage2;
    private JTextPane debugPanel;
    private static TestJMEDragAndDrop instance;

    public static void main(String[] stringArray) {
        TestJMEDragAndDrop testJMEDragAndDrop;
        if (LoggingSystem.getLogger().getUseParentHandlers()) {
            LoggingSystem.getLogger().setUseParentHandlers(false);
        }
        instance = testJMEDragAndDrop = new TestJMEDragAndDrop();
        testJMEDragAndDrop.start();
    }

    protected void simpleUpdate() {
        this.updateBuffer.append(" ").append(this.desktop.getDragAndDropSupport().isDragging() ? "dragging" : "");
        this.fps.print(this.updateBuffer);
    }

    protected void simpleInitGame() {
        this.input = new InputHandler();
        this.desktop = new JMEDesktop("desktop", this.display.getWidth(), this.display.getHeight(), this.input);
        new JMEDragAndDrop(this.desktop);
        this.rootNode.attachChild((Spatial)this.desktop);
        this.desktop.setLightCombineMode(0);
        this.desktop.getJDesktop().setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        this.desktop.setColorBuffer(0, null);
        this.desktop.setDefaultColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.5f));
        this.desktop.setRenderQueueMode(4);
        this.desktop.setCullMode(3);
        this.desktop.getLocalTranslation().set((float)(this.display.getWidth() / 2), (float)(this.display.getHeight() / 2), 0.0f);
        this.desktop.updateGeometricState(0.0f, true);
        this.desktop.updateRenderState();
        this.dndPanel1 = new JMEDndPanel(this.desktop.getDragAndDropSupport());
        this.dndPanel1.setSize(380, 100);
        this.dndPanel1.setVisible(true);
        this.dndPanel1.setLocation(10, 200);
        this.dndPanel1.setName("DndPanel1");
        this.dndPanel2 = new JMEDndPanel(this.desktop.getDragAndDropSupport());
        this.dndPanel2.setSize(380, 100);
        this.dndPanel2.setVisible(true);
        this.dndPanel2.setLocation(400, 200);
        this.dndPanel2.setName("DndPanel2");
        this.dndImage1 = new DndImage(this.desktop.getDragAndDropSupport());
        this.dndImage1.setSize(380, 100);
        this.dndImage1.setVisible(true);
        this.dndImage1.setLocation(10, 80);
        this.dndImage1.setName("dndImage1");
        this.dndImage2 = new DndImage(this.desktop.getDragAndDropSupport());
        this.dndImage2.setSize(380, 100);
        this.dndImage2.setVisible(true);
        this.dndImage2.setLocation(400, 80);
        this.dndImage2.setName("dndImage2");
        this.debugPanel = new JTextPane();
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.debugPanel);
        JInternalFrame jInternalFrame = new JInternalFrame();
        jInternalFrame.add(jScrollPane);
        jInternalFrame.setSize(760, 100);
        jInternalFrame.setResizable(true);
        jInternalFrame.setTitle("Debug");
        jInternalFrame.setLocation(10, 340);
        jInternalFrame.setVisible(true);
        this.desktop.getJDesktop().add(this.dndPanel1);
        this.desktop.getJDesktop().add(this.dndPanel2);
        this.desktop.getJDesktop().add(this.dndImage1);
        this.desktop.getJDesktop().add(this.dndImage2);
        this.desktop.getJDesktop().add(jInternalFrame);
        this.desktop.getJDesktop().repaint();
        this.desktop.getJDesktop().revalidate();
        this.desktop.setVBOInfo(null);
        MouseInput.get().setCursorVisible(true);
        this.desktop.getJDesktop().getToolkit().addAWTEventListener(new AWTEventListener(){

            public void eventDispatched(AWTEvent aWTEvent) {
                log.fine("AWT:" + aWTEvent.toString());
            }
        }, 1048575L);
    }

    public static void addText(String string) {
        int n = TestJMEDragAndDrop.instance.debugPanel.getDocument().getLength();
        AttributeSet attributeSet = SimpleAttributeSet.EMPTY;
        try {
            TestJMEDragAndDrop.instance.debugPanel.getDocument().insertString(n, string + "\n", attributeSet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

