/*
 * Decompiled with CFR 0.152.
 */
package jmetest.curve;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingSphere;
import com.jme.bounding.BoundingVolume;
import com.jme.curve.BezierCurve;
import com.jme.curve.Curve;
import com.jme.curve.CurveController;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Controller;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Box;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.util.TextureManager;
import com.jme.util.geom.BufferUtils;
import java.net.URL;

public class TestBezierCurve
extends SimpleGame {
    private Vector3f up = new Vector3f(0.0f, 1.0f, 0.0f);

    public static void main(String[] stringArray) {
        TestBezierCurve testBezierCurve = new TestBezierCurve();
        testBezierCurve.setDialogBehaviour(2);
        testBezierCurve.start();
    }

    protected void simpleInitGame() {
        this.lightState.setEnabled(false);
        this.display.setTitle("Bezier Curve Test");
        Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(-4.0f, 0.0f, 0.0f), new Vector3f(-2.0f, 3.0f, 2.0f), new Vector3f(2.0f, -3.0f, -2.0f), new Vector3f(4.0f, 0.0f, 0.0f)};
        BezierCurve bezierCurve = new BezierCurve("Curve", vector3fArray);
        ColorRGBA[] colorRGBAArray = new ColorRGBA[]{new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f), new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f), new ColorRGBA(1.0f, 1.0f, 0.0f, 1.0f), new ColorRGBA(0.0f, 0.0f, 1.0f, 1.0f)};
        bezierCurve.setColorBuffer(0, BufferUtils.createFloatBuffer((ColorRGBA[])colorRGBAArray));
        Vector3f vector3f = new Vector3f(-0.1f, -0.1f, -0.1f);
        Vector3f vector3f2 = new Vector3f(0.1f, 0.1f, 0.1f);
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        Box box = new Box("Control 1", vector3f, vector3f2);
        box.setModelBound((BoundingVolume)new BoundingSphere());
        box.updateModelBound();
        box.setLocalTranslation(new Vector3f(vector3fArray[0]));
        Box box2 = new Box("Control 2", vector3f, vector3f2);
        box2.setModelBound((BoundingVolume)new BoundingSphere());
        box2.updateModelBound();
        box2.setLocalTranslation(new Vector3f(vector3fArray[1]));
        Box box3 = new Box("Control 3", vector3f, vector3f2);
        box3.setModelBound((BoundingVolume)new BoundingSphere());
        box3.updateModelBound();
        box3.setLocalTranslation(new Vector3f(vector3fArray[2]));
        Box box4 = new Box("Control 4", vector3f, vector3f2);
        box4.setModelBound((BoundingVolume)new BoundingSphere());
        box4.updateModelBound();
        box4.setLocalTranslation(new Vector3f(vector3fArray[3]));
        Box box5 = new Box("Controlled Box", vector3f.mult(5.0f), vector3f2.mult(5.0f));
        box5.setModelBound((BoundingVolume)new BoundingSphere());
        box5.updateModelBound();
        box5.setLocalTranslation(new Vector3f(vector3fArray[0]));
        CurveController curveController = new CurveController((Curve)bezierCurve, (Spatial)box5);
        box5.addController((Controller)curveController);
        curveController.setRepeatType(2);
        curveController.setUpVector(this.up);
        curveController.setSpeed(0.5f);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setEnabled(true);
        textureState.setTexture(TextureManager.loadTexture((URL)TestBezierCurve.class.getClassLoader().getResource("jmetest/data/images/Monkey.jpg"), (int)2, (int)1));
        box5.setRenderState((RenderState)textureState);
        this.rootNode.setRenderState((RenderState)zBufferState);
        this.rootNode.attachChild((Spatial)box);
        this.rootNode.attachChild((Spatial)box2);
        this.rootNode.attachChild((Spatial)box3);
        this.rootNode.attachChild((Spatial)box4);
        this.rootNode.attachChild((Spatial)box5);
        this.rootNode.attachChild((Spatial)bezierCurve);
    }
}

