/*
 * Decompiled with CFR 0.152.
 */
package jmetest.effects;

import com.jme.image.Texture;
import com.jme.math.FastMath;
import com.jme.math.Quaternion;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Geometry;
import com.jme.scene.Line;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.Text;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.util.GameTaskQueueManager;
import com.jme.util.TextureKey;
import com.jme.util.TextureManager;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.awt.JMECanvas;
import com.jmex.awt.JMECanvasImplementor;
import com.jmex.awt.SimpleCanvasImpl;
import com.jmex.editors.swing.particles.ParticleAppearancePanel;
import com.jmex.editors.swing.particles.ParticleEmissionPanel;
import com.jmex.editors.swing.particles.ParticleFlowPanel;
import com.jmex.editors.swing.particles.ParticleInfluencePanel;
import com.jmex.editors.swing.particles.ParticleOriginPanel;
import com.jmex.editors.swing.particles.ParticleWorldPanel;
import com.jmex.effects.particles.ParticleFactory;
import com.jmex.effects.particles.ParticleGeometry;
import com.jmex.effects.particles.ParticleInfluence;
import com.jmex.effects.particles.SimpleParticleInfluenceFactory;
import com.jmex.effects.particles.SwarmInfluence;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class RenParticleEditor
extends JFrame {
    public static Node particleNode;
    public static ParticleGeometry particleGeom;
    private static final long serialVersionUID = 1L;
    private static final String[] EXAMPLE_NAMES;
    int width = 640;
    int height = 480;
    MyImplementor impl;
    private CameraHandler camhand;
    private Canvas glCanvas;
    private Node root;
    private Geometry grid;
    private Action spawnAction;
    private ParticleAppearancePanel appearancePanel;
    private ParticleFlowPanel flowPanel;
    private ParticleOriginPanel originPanel;
    private ParticleEmissionPanel emissionPanel;
    private ParticleWorldPanel worldPanel;
    private ParticleInfluencePanel influencePanel;
    private LayerTableModel layerModel = new LayerTableModel();
    private JTable layerTable = new JTable(this.layerModel);
    private JButton deleteLayerButton;
    private JList exampleList;
    private JButton exampleButton;
    private JFileChooser fileChooser = new JFileChooser();
    private File openFile;
    private Preferences prefs = Preferences.userNodeForPackage(RenParticleEditor.class);

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        new RenParticleEditor();
    }

    public RenParticleEditor() {
        try {
            this.init();
            this.setLocationRelativeTo(null);
            this.setVisible(true);
            this.initFileChooser();
            while (this.glCanvas == null) {
            }
            new Thread(){
                {
                    this.setDaemon(true);
                }

                public void run() {
                    try {
                        while (true) {
                            if (RenParticleEditor.this.isVisible()) {
                                RenParticleEditor.this.glCanvas.repaint();
                            }
                            Thread.sleep(2L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        return;
                    }
                }
            }.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void init() throws Exception {
        this.updateTitle();
        this.setDefaultCloseOperation(3);
        this.setFont(new Font("Arial", 0, 12));
        this.setJMenuBar(this.createMenuBar());
        this.appearancePanel = new ParticleAppearancePanel(this.prefs){
            private static final long serialVersionUID = 1L;

            protected void requestParticleSystemOverwrite(ParticleGeometry particleGeometry) {
                particleNode.getChildren().set(particleNode.getChildren().indexOf(particleGeom), particleGeometry);
                particleGeom = particleGeometry;
                particleGeom.updateRenderState();
                RenParticleEditor.this.updateFromManager();
            }
        };
        this.flowPanel = new ParticleFlowPanel();
        this.originPanel = new ParticleOriginPanel();
        this.emissionPanel = new ParticleEmissionPanel();
        this.worldPanel = new ParticleWorldPanel();
        this.influencePanel = new ParticleInfluencePanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.add((Component)this.createLayerPanel(), "Layers");
        jTabbedPane.add((Component)this.appearancePanel, "Appearance");
        jTabbedPane.add((Component)this.originPanel, "Origin");
        jTabbedPane.add((Component)this.emissionPanel, "Emission");
        jTabbedPane.add((Component)this.flowPanel, "Flow");
        jTabbedPane.add((Component)this.worldPanel, "World");
        jTabbedPane.add((Component)this.influencePanel, "Influences");
        jTabbedPane.add((Component)this.createExamplesPanel(), "Examples");
        jTabbedPane.setPreferredSize(new Dimension(300, 10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.getGlCanvas(), "Center");
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setOrientation(1);
        jSplitPane.setLeftComponent(jTabbedPane);
        jSplitPane.setRightComponent(jPanel);
        Dimension dimension = new Dimension(100, 50);
        jTabbedPane.setMinimumSize(dimension);
        jPanel.setMinimumSize(dimension);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.setSize(new Dimension(1024, 768));
    }

    private void updateTitle() {
        this.setTitle("Particle System Editor" + (this.openFile == null ? "" : " - " + this.openFile));
    }

    private JMenuBar createMenuBar() {
        AbstractAction abstractAction = new AbstractAction("New"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                RenParticleEditor.this.createNewSystem();
            }
        };
        abstractAction.putValue("MnemonicKey", 78);
        AbstractAction abstractAction2 = new AbstractAction("Open..."){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                RenParticleEditor.this.showOpenDialog();
            }
        };
        abstractAction2.putValue("MnemonicKey", 79);
        AbstractAction abstractAction3 = new AbstractAction("Import Layers..."){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                RenParticleEditor.this.showImportDialog();
            }
        };
        abstractAction3.putValue("MnemonicKey", 73);
        AbstractAction abstractAction4 = new AbstractAction("Save"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                RenParticleEditor.this.saveAs(RenParticleEditor.this.openFile);
            }
        };
        abstractAction4.putValue("MnemonicKey", 83);
        AbstractAction abstractAction5 = new AbstractAction("Save As..."){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                RenParticleEditor.this.saveAs(null);
            }
        };
        abstractAction5.putValue("MnemonicKey", 65);
        AbstractAction abstractAction6 = new AbstractAction("Quit"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        };
        abstractAction6.putValue("MnemonicKey", 81);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenu.add(abstractAction);
        jMenu.add(abstractAction2);
        jMenu.add(abstractAction3);
        jMenu.add(abstractAction4);
        jMenu.add(abstractAction5);
        jMenu.addSeparator();
        jMenu.add(abstractAction6);
        this.spawnAction = new AbstractAction("Force Spawn"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                for (Spatial spatial : particleNode.getChildren()) {
                    if (!(spatial instanceof ParticleGeometry)) continue;
                    ((ParticleGeometry)spatial).forceRespawn();
                }
            }
        };
        this.spawnAction.putValue("MnemonicKey", 70);
        this.spawnAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 0));
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic(69);
        jMenu2.add(this.spawnAction);
        AbstractAction abstractAction7 = new AbstractAction("Show Grid"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                RenParticleEditor.this.grid.setCullMode(RenParticleEditor.this.grid.getCullMode() == 2 ? 1 : 2);
            }
        };
        abstractAction7.putValue("MnemonicKey", 71);
        AbstractAction abstractAction8 = new AbstractAction("Change Background Color..."){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                RenParticleEditor.this.showBackgroundDialog();
            }
        };
        abstractAction8.putValue("MnemonicKey", 66);
        AbstractAction abstractAction9 = new AbstractAction("Recenter Camera"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                RenParticleEditor.this.camhand.recenterCamera();
            }
        };
        abstractAction9.putValue("MnemonicKey", 82);
        JMenu jMenu3 = new JMenu("View");
        jMenu3.setMnemonic(86);
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(abstractAction7);
        jCheckBoxMenuItem.setSelected(true);
        jMenu3.add(jCheckBoxMenuItem);
        jMenu3.add(abstractAction8);
        jMenu3.addSeparator();
        jMenu3.add(abstractAction9);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        return jMenuBar;
    }

    private JPanel createLayerPanel() {
        JLabel jLabel = this.createBoldLabel("Particle Layers:");
        this.layerTable.setColumnSelectionAllowed(false);
        this.layerTable.setRowSelectionAllowed(true);
        this.layerTable.setSelectionMode(0);
        int n = this.layerTable.getTableHeader().getDefaultRenderer().getTableCellRendererComponent((JTable)this.layerTable, (Object)"Visible", (boolean)false, (boolean)false, (int)-1, (int)1).getMinimumSize().width;
        TableColumn tableColumn = this.layerTable.getColumnModel().getColumn(1);
        tableColumn.setMinWidth(n);
        tableColumn.setPreferredWidth(n);
        tableColumn.setMaxWidth(n);
        this.layerTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (RenParticleEditor.this.layerTable.getSelectedRow() != -1) {
                    particleGeom = (ParticleGeometry)particleNode.getChild(RenParticleEditor.this.layerTable.getSelectedRow());
                    RenParticleEditor.this.updateFromManager();
                }
            }
        });
        JButton jButton = new JButton(new AbstractAction("New"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                int n = particleNode.getQuantity();
                RenParticleEditor.this.createNewLayer();
                RenParticleEditor.this.layerModel.fireTableRowsInserted(n, n);
                RenParticleEditor.this.layerTable.setRowSelectionInterval(n, n);
                RenParticleEditor.this.deleteLayerButton.setEnabled(true);
            }
        });
        jButton.setMargin(new Insets(2, 14, 2, 14));
        this.deleteLayerButton = new JButton(new AbstractAction("Delete"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                RenParticleEditor.this.deleteLayer();
            }
        });
        this.deleteLayerButton.setMargin(new Insets(2, 14, 2, 14));
        this.deleteLayerButton.setEnabled(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 5, 10), 0, 0));
        jPanel.add((Component)new JScrollPane(this.layerTable), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)jButton, new GridBagConstraints(0, 2, 1, 1, 0.5, 0.0, 10, 0, new Insets(5, 10, 10, 10), 0, 0));
        jPanel.add((Component)this.deleteLayerButton, new GridBagConstraints(1, 2, 1, 1, 0.5, 0.0, 10, 0, new Insets(5, 10, 10, 10), 0, 0));
        return jPanel;
    }

    private JPanel createExamplesPanel() {
        JLabel jLabel = this.createBoldLabel("Prebuilt Examples:");
        this.exampleList = new JList<String>(EXAMPLE_NAMES);
        this.exampleList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (RenParticleEditor.this.exampleList.getSelectedValue() instanceof String) {
                    RenParticleEditor.this.exampleButton.setEnabled(true);
                } else {
                    RenParticleEditor.this.exampleButton.setEnabled(false);
                }
            }
        });
        this.exampleButton = new JButton(new AbstractAction("Apply"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                RenParticleEditor.this.applyExample();
            }
        });
        this.exampleButton.setMargin(new Insets(2, 14, 2, 14));
        this.exampleButton.setEnabled(false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 10), 0, 0));
        jPanel.add((Component)new JScrollPane(this.exampleList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        jPanel.add((Component)this.exampleButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 10, 10, 10), 0, 0));
        return jPanel;
    }

    private JLabel createBoldLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Arial", 1, 13));
        return jLabel;
    }

    private void createNewSystem() {
        this.layerTable.clearSelection();
        particleNode.detachAllChildren();
        this.createNewLayer();
        this.layerModel.fireTableDataChanged();
        this.layerTable.setRowSelectionInterval(0, 0);
        this.deleteLayerButton.setEnabled(false);
        this.openFile = null;
        this.updateTitle();
    }

    private void showOpenDialog() {
        this.fileChooser.setSelectedFile(new File(""));
        if (this.fileChooser.showOpenDialog(this) != 0) {
            return;
        }
        File file = this.fileChooser.getSelectedFile();
        this.prefs.put("particle_dir", file.getParent().toString());
        try {
            this.setLocationOverride(file.getParentFile());
            Spatial spatial = (Spatial)BinaryImporter.getInstance().load(file);
            if (spatial instanceof Node) {
                Node node = (Node)spatial;
                for (int i = node.getQuantity() - 1; i >= 0; --i) {
                    if (node.getChild(i) instanceof ParticleGeometry) continue;
                    node.detachChildAt(i);
                }
                if (node.getQuantity() == 0) {
                    throw new Exception("Node contains no particle meshes");
                }
                this.layerTable.clearSelection();
                this.root.detachChild((Spatial)particleNode);
                particleNode = node;
                this.root.attachChild((Spatial)particleNode);
                this.deleteLayerButton.setEnabled(true);
            } else {
                particleGeom = (ParticleGeometry)spatial;
                this.layerTable.clearSelection();
                particleNode.detachAllChildren();
                particleNode.attachChild((Spatial)particleGeom);
                this.deleteLayerButton.setEnabled(false);
            }
            particleNode.updateRenderState();
            this.layerModel.fireTableDataChanged();
            this.layerTable.setRowSelectionInterval(0, 0);
            this.openFile = file;
            this.updateTitle();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Couldn't open '" + file + "': " + exception, "File Error", 0);
            exception.printStackTrace();
        }
        TextureKey.setLocationOverride(null);
    }

    private void showImportDialog() {
        this.fileChooser.setSelectedFile(new File(""));
        if (this.fileChooser.showOpenDialog(this) != 0) {
            return;
        }
        File file = this.fileChooser.getSelectedFile();
        this.prefs.put("particle_dir", file.getParent());
        try {
            this.setLocationOverride(file.getParentFile());
            Spatial spatial = (Spatial)BinaryImporter.getInstance().load(file);
            int n = particleNode.getQuantity();
            if (spatial instanceof Node) {
                Node node = (Node)spatial;
                ArrayList<Spatial> arrayList = new ArrayList<Spatial>();
                int n2 = node.getQuantity();
                for (int i = 0; i < n2; ++i) {
                    if (!(node.getChild(i) instanceof ParticleGeometry)) continue;
                    arrayList.add(node.getChild(i));
                }
                if (arrayList.size() == 0) {
                    throw new Exception("Node contains no particle meshes");
                }
                this.layerTable.clearSelection();
                for (Spatial spatial2 : arrayList) {
                    particleNode.attachChild(spatial2);
                }
            } else {
                particleGeom = (ParticleGeometry)spatial;
                this.layerTable.clearSelection();
                particleNode.attachChild((Spatial)particleGeom);
            }
            particleNode.updateRenderState();
            this.layerModel.fireTableRowsInserted(n, particleNode.getQuantity() - 1);
            this.layerTable.setRowSelectionInterval(n, n);
            this.deleteLayerButton.setEnabled(true);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, "Couldn't open '" + file + "': " + exception, "File Error", 0);
            exception.printStackTrace();
        }
        TextureKey.setLocationOverride(null);
    }

    private void setLocationOverride(final File file) {
        TextureKey.setLocationOverride((TextureKey.LocationOverride)new TextureKey.LocationOverride(){

            public URL getLocation(String string) throws MalformedURLException {
                return new URL(file.toURL(), string);
            }
        });
    }

    private void saveAs(File file) {
        if (file == null) {
            this.fileChooser.setSelectedFile(this.openFile == null ? new File("") : this.openFile);
            if (this.fileChooser.showSaveDialog(this) != 0) {
                return;
            }
            file = this.fileChooser.getSelectedFile();
            this.prefs.put("particle_dir", file.getParent().toString());
        }
        this.setTexturePathsRelative((Spatial)particleNode, file.getParentFile(), true);
        try {
            BinaryExporter.getInstance().save((Savable)(particleNode.getQuantity() > 1 ? particleNode : particleGeom), file);
            this.openFile = file;
            this.updateTitle();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Couldn't save '" + file + "': " + iOException, "File Error", 0);
        }
        this.setTexturePathsRelative((Spatial)particleNode, file.getParentFile(), false);
    }

    private void setTexturePathsRelative(Spatial spatial, File file, boolean bl) {
        Texture texture;
        TextureState textureState = (TextureState)spatial.getRenderState(6);
        if (textureState != null && (texture = textureState.getTexture()) != null && texture.getTextureKey() != null && "file".equals(texture.getTextureKey().getLocation().getProtocol())) {
            String string = texture.getTextureKey().getLocation().getFile();
            try {
                if (bl) {
                    String string2 = this.relativize(new File(string), file).replace(File.separatorChar, '/');
                    texture.getTextureKey().setLocation(new URL("file:" + string2));
                } else {
                    texture.getTextureKey().setLocation(new File(file, string).getCanonicalFile().toURL());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (spatial instanceof Node) {
            texture = (Node)spatial;
            int n = texture.getQuantity();
            for (int i = 0; i < n; ++i) {
                this.setTexturePathsRelative(texture.getChild(i), file, bl);
            }
        }
    }

    private String relativize(File file, File file2) {
        String string = file.toString();
        StringBuffer stringBuffer = new StringBuffer();
        while (!string.startsWith(file2.toString())) {
            stringBuffer.append("..").append(File.separatorChar);
            if ((file2 = file2.getParentFile()) != null) continue;
            return string;
        }
        String string2 = file2.toString();
        stringBuffer.append(string.substring(string2.length() + (string2.endsWith(File.separator) ? 0 : 1)));
        return stringBuffer.toString();
    }

    private void showBackgroundDialog() {
        final Color color = JColorChooser.showDialog(this, "Choose Background Color", this.makeColor(this.impl.getRenderer().getBackgroundColor(), false));
        if (color != null) {
            this.prefs.putInt("bg_color", color.getRGB());
            Callable callable = new Callable(){

                public Object call() {
                    RenParticleEditor.this.impl.getRenderer().setBackgroundColor(RenParticleEditor.this.makeColorRGBA(color));
                    return null;
                }
            };
            GameTaskQueueManager.getManager().getQueue("render").enqueue(callable);
        }
    }

    private void createNewLayer() {
        particleGeom = ParticleFactory.buildParticles((String)this.createLayerName(), (int)300);
        particleGeom.addInfluence(SimpleParticleInfluenceFactory.createBasicGravity((Vector3f)new Vector3f(0.0f, -3.0f, 0.0f), (boolean)true));
        particleGeom.setEmissionDirection(new Vector3f(0.0f, 1.0f, 0.0f));
        particleGeom.setMaximumAngle(0.2268928f);
        particleGeom.getParticleController().setSpeed(1.0f);
        particleGeom.setMinimumLifeTime(2000.0f);
        particleGeom.setStartSize(10.0f);
        particleGeom.setEndSize(10.0f);
        particleGeom.setStartColor(new ColorRGBA(0.0f, 0.0625f, 1.0f, 1.0f));
        particleGeom.setEndColor(new ColorRGBA(0.0f, 0.0625f, 1.0f, 0.0f));
        particleGeom.warmUp(120);
        AlphaState alphaState = (AlphaState)particleGeom.getRenderState(0);
        if (alphaState == null) {
            alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
            alphaState.setBlendEnabled(true);
            alphaState.setSrcFunction(4);
            alphaState.setTestEnabled(true);
            alphaState.setTestFunction(4);
            particleGeom.setRenderState((RenderState)alphaState);
            particleGeom.updateRenderState();
        }
        alphaState.setDstFunction(1);
        TextureState textureState = this.impl.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((URL)RenParticleEditor.class.getClassLoader().getResource("jmetest/data/texture/flaresmall.jpg"), (int)1, (int)1));
        particleGeom.setRenderState((RenderState)textureState);
        particleNode.attachChild((Spatial)particleGeom);
        particleGeom.updateRenderState();
    }

    private String createLayerName() {
        int n = -1;
        int n2 = particleNode.getQuantity();
        for (int i = 0; i < n2; ++i) {
            String string = particleNode.getChild(i).getName();
            if (!string.startsWith("Layer #")) continue;
            try {
                n = Math.max(n, Integer.parseInt(string.substring(7)));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return "Layer #" + (n + 1);
    }

    private void deleteLayer() {
        int n = this.layerTable.getSelectedRow();
        int n2 = n == particleNode.getQuantity() - 1 ? n - 1 : n;
        this.layerTable.clearSelection();
        particleNode.detachChildAt(n);
        this.layerModel.fireTableRowsDeleted(n, n);
        this.layerTable.setRowSelectionInterval(n2, n2);
        if (particleNode.getQuantity() == 1) {
            this.deleteLayerButton.setEnabled(false);
        }
    }

    private void applyExample() {
        if (this.exampleList == null || this.exampleList.getSelectedValue() == null) {
            return;
        }
        String string = this.exampleList.getSelectedValue().toString();
        particleGeom.clearInfluences();
        if ("FIRE".equalsIgnoreCase(string)) {
            particleGeom.setEmissionDirection(new Vector3f(0.0f, 1.0f, 0.0f));
            particleGeom.setMaximumAngle(0.20943952f);
            particleGeom.setMinimumAngle(0.0f);
            particleGeom.getParticleController().setSpeed(1.0f);
            particleGeom.setMinimumLifeTime(1000.0f);
            particleGeom.setMaximumLifeTime(1500.0f);
            particleGeom.setStartSize(40.0f);
            particleGeom.setEndSize(40.0f);
            particleGeom.setStartColor(new ColorRGBA(1.0f, 0.312f, 0.121f, 1.0f));
            particleGeom.setEndColor(new ColorRGBA(1.0f, 0.312f, 0.121f, 0.0f));
            particleGeom.getParticleController().setControlFlow(true);
            particleGeom.setReleaseRate(300);
            particleGeom.setReleaseVariance(0.0f);
            particleGeom.setInitialVelocity(0.3f);
            particleGeom.getParticleController().setRepeatType(1);
        } else if ("FOUNTAIN".equalsIgnoreCase(string)) {
            particleGeom.addInfluence(SimpleParticleInfluenceFactory.createBasicGravity((Vector3f)new Vector3f(0.0f, -3.0f, 0.0f), (boolean)true));
            particleGeom.setEmissionDirection(new Vector3f(0.0f, 1.0f, 0.0f));
            particleGeom.setMaximumAngle(0.2268928f);
            particleGeom.setMinimumAngle(0.0f);
            particleGeom.getParticleController().setSpeed(1.0f);
            particleGeom.setMinimumLifeTime(1300.0f);
            particleGeom.setMaximumLifeTime(1950.0f);
            particleGeom.setStartSize(10.0f);
            particleGeom.setEndSize(10.0f);
            particleGeom.setStartColor(new ColorRGBA(0.0f, 0.0625f, 1.0f, 1.0f));
            particleGeom.setEndColor(new ColorRGBA(0.0f, 0.0625f, 1.0f, 0.0f));
            particleGeom.getParticleController().setControlFlow(false);
            particleGeom.setReleaseRate(300);
            particleGeom.setReleaseVariance(0.0f);
            particleGeom.setInitialVelocity(1.1f);
            particleGeom.getParticleController().setRepeatType(1);
        } else if ("LAVA".equalsIgnoreCase(string)) {
            particleGeom.addInfluence(SimpleParticleInfluenceFactory.createBasicGravity((Vector3f)new Vector3f(0.0f, -3.0f, 0.0f), (boolean)true));
            particleGeom.setEmissionDirection(new Vector3f(0.0f, 1.0f, 0.0f));
            particleGeom.setMaximumAngle(0.418f);
            particleGeom.setMinimumAngle(0.0f);
            particleGeom.getParticleController().setSpeed(1.0f);
            particleGeom.setMinimumLifeTime(1057.0f);
            particleGeom.setMaximumLifeTime(1500.0f);
            particleGeom.setStartSize(40.0f);
            particleGeom.setEndSize(40.0f);
            particleGeom.setStartColor(new ColorRGBA(1.0f, 0.18f, 0.125f, 1.0f));
            particleGeom.setEndColor(new ColorRGBA(1.0f, 0.18f, 0.125f, 0.0f));
            particleGeom.getParticleController().setControlFlow(false);
            particleGeom.setReleaseRate(300);
            particleGeom.setReleaseVariance(0.0f);
            particleGeom.setInitialVelocity(1.1f);
            particleGeom.getParticleController().setRepeatType(1);
        } else if ("SMOKE".equalsIgnoreCase(string)) {
            particleGeom.setEmissionDirection(new Vector3f(0.0f, 0.6f, 0.0f));
            particleGeom.setMaximumAngle(0.36651915f);
            particleGeom.setMinimumAngle(0.0f);
            particleGeom.getParticleController().setSpeed(0.2f);
            particleGeom.setMinimumLifeTime(1000.0f);
            particleGeom.setMaximumLifeTime(1500.0f);
            particleGeom.setStartSize(32.5f);
            particleGeom.setEndSize(40.0f);
            particleGeom.setStartColor(new ColorRGBA(0.0f, 0.0f, 0.0f, 1.0f));
            particleGeom.setEndColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 0.0f));
            particleGeom.getParticleController().setControlFlow(false);
            particleGeom.setReleaseRate(300);
            particleGeom.setReleaseVariance(0.0f);
            particleGeom.setInitialVelocity(0.58f);
            particleGeom.setParticleSpinSpeed(0.08f);
        } else if ("RAIN".equalsIgnoreCase(string)) {
            particleGeom.addInfluence(SimpleParticleInfluenceFactory.createBasicGravity((Vector3f)new Vector3f(0.0f, -3.0f, 0.0f), (boolean)true));
            particleGeom.setEmissionDirection(new Vector3f(0.0f, -1.0f, 0.0f));
            particleGeom.setMaximumAngle((float)Math.PI);
            particleGeom.setMinimumAngle(0.0f);
            particleGeom.getParticleController().setSpeed(0.5f);
            particleGeom.setMinimumLifeTime(1626.0f);
            particleGeom.setMaximumLifeTime(2400.0f);
            particleGeom.setStartSize(9.1f);
            particleGeom.setEndSize(13.6f);
            particleGeom.setStartColor(new ColorRGBA(0.16078432f, 0.16078432f, 1.0f, 1.0f));
            particleGeom.setEndColor(new ColorRGBA(0.16078432f, 0.16078432f, 1.0f, 0.15686275f));
            particleGeom.getParticleController().setControlFlow(false);
            particleGeom.setReleaseRate(300);
            particleGeom.setReleaseVariance(0.0f);
            particleGeom.setInitialVelocity(0.58f);
            particleGeom.getParticleController().setRepeatType(1);
        } else if ("SNOW".equalsIgnoreCase(string)) {
            particleGeom.addInfluence(SimpleParticleInfluenceFactory.createBasicGravity((Vector3f)new Vector3f(0.0f, -3.0f, 0.0f), (boolean)true));
            particleGeom.setEmissionDirection(new Vector3f(0.0f, -1.0f, 0.0f));
            particleGeom.setMaximumAngle(1.5707964f);
            particleGeom.setMinimumAngle(0.0f);
            particleGeom.getParticleController().setSpeed(0.2f);
            particleGeom.setMinimumLifeTime(1057.0f);
            particleGeom.setMaximumLifeTime(1500.0f);
            particleGeom.setStartSize(30.0f);
            particleGeom.setEndSize(30.0f);
            particleGeom.setStartColor(new ColorRGBA(0.3764706f, 0.3764706f, 0.3764706f, 1.0f));
            particleGeom.setEndColor(new ColorRGBA(0.3764706f, 0.3764706f, 0.3764706f, 0.1882353f));
            particleGeom.getParticleController().setControlFlow(false);
            particleGeom.setReleaseRate(300);
            particleGeom.setReleaseVariance(0.0f);
            particleGeom.setInitialVelocity(0.59999996f);
            particleGeom.getParticleController().setRepeatType(1);
        } else if ("JET".equalsIgnoreCase(string)) {
            particleGeom.setEmissionDirection(new Vector3f(-1.0f, 0.0f, 0.0f));
            particleGeom.setMaximumAngle((float)Math.PI / 90);
            particleGeom.setMinimumAngle(0.0f);
            particleGeom.getParticleController().setSpeed(1.0f);
            particleGeom.setMinimumLifeTime(100.0f);
            particleGeom.setMaximumLifeTime(150.0f);
            particleGeom.setStartSize(6.6f);
            particleGeom.setEndSize(30.0f);
            particleGeom.setStartColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
            particleGeom.setEndColor(new ColorRGBA(0.6f, 0.2f, 0.0f, 0.0f));
            particleGeom.getParticleController().setControlFlow(false);
            particleGeom.setReleaseRate(300);
            particleGeom.setReleaseVariance(0.0f);
            particleGeom.setInitialVelocity(1.4599999f);
            particleGeom.getParticleController().setRepeatType(1);
        } else if ("EXPLOSION".equalsIgnoreCase(string)) {
            particleGeom.setEmissionDirection(new Vector3f(0.0f, 1.0f, 0.0f));
            particleGeom.setMaximumAngle((float)Math.PI);
            particleGeom.setMinimumAngle(0.0f);
            particleGeom.getParticleController().setSpeed(1.4f);
            particleGeom.setMinimumLifeTime(1000.0f);
            particleGeom.setMaximumLifeTime(1500.0f);
            particleGeom.setStartSize(40.0f);
            particleGeom.setEndSize(40.0f);
            particleGeom.setStartColor(new ColorRGBA(1.0f, 0.312f, 0.121f, 1.0f));
            particleGeom.setEndColor(new ColorRGBA(1.0f, 0.24313726f, 0.03137255f, 0.0f));
            particleGeom.getParticleController().setControlFlow(false);
            particleGeom.getParticleController().setRepeatType(0);
        } else if ("GROUND FOG".equalsIgnoreCase(string)) {
            particleGeom.setEmissionDirection(new Vector3f(0.0f, 0.3f, 0.0f));
            particleGeom.setMaximumAngle(1.5707964f);
            particleGeom.setMinimumAngle(1.5707964f);
            particleGeom.getParticleController().setSpeed(0.5f);
            particleGeom.setMinimumLifeTime(1774.0f);
            particleGeom.setMaximumLifeTime(2800.0f);
            particleGeom.setStartSize(35.4f);
            particleGeom.setEndSize(40.0f);
            particleGeom.setStartColor(new ColorRGBA(0.87058824f, 0.87058824f, 0.87058824f, 1.0f));
            particleGeom.setEndColor(new ColorRGBA(0.0f, 0.8f, 0.8f, 0.0f));
            particleGeom.getParticleController().setControlFlow(false);
            particleGeom.setReleaseRate(300);
            particleGeom.setReleaseVariance(0.0f);
            particleGeom.setInitialVelocity(1.0f);
            particleGeom.setParticleSpinSpeed(0.0f);
        } else if ("FIREFLIES".equalsIgnoreCase(string)) {
            particleGeom.setEmissionDirection(new Vector3f(0.0f, 1.0f, 0.0f));
            particleGeom.setStartSize(3.0f);
            particleGeom.setEndSize(1.5f);
            particleGeom.setOriginOffset(new Vector3f(0.0f, 0.0f, 0.0f));
            particleGeom.setInitialVelocity(0.05f);
            particleGeom.setMinimumLifeTime(5000.0f);
            particleGeom.setMaximumLifeTime(15000.0f);
            particleGeom.setStartColor(new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f));
            particleGeom.setEndColor(new ColorRGBA(0.0f, 1.0f, 0.0f, 1.0f));
            particleGeom.setMaximumAngle((float)Math.PI);
            particleGeom.getParticleController().setControlFlow(false);
            particleGeom.getParticleController().setSpeed(0.75f);
            SwarmInfluence swarmInfluence = new SwarmInfluence(new Vector3f(0.0f, 0.0f, 0.0f), 0.001f);
            swarmInfluence.setMaxSpeed(0.2f);
            swarmInfluence.setSpeedBump(0.025f);
            swarmInfluence.setTurnSpeed((float)Math.PI * 2);
            particleGeom.addInfluence((ParticleInfluence)swarmInfluence);
        }
        particleGeom.warmUp(120);
        this.updateFromManager();
    }

    public void updateFromManager() {
        this.appearancePanel.setEdittedParticles(particleGeom);
        this.appearancePanel.updateWidgets();
        this.flowPanel.setEdittedParticles(particleGeom);
        this.flowPanel.updateWidgets();
        this.originPanel.setEdittedParticles(particleGeom);
        this.originPanel.updateWidgets();
        this.emissionPanel.setEdittedParticles(particleGeom);
        this.emissionPanel.updateWidgets();
        this.worldPanel.setEdittedParticles(particleGeom);
        this.worldPanel.updateWidgets();
        this.influencePanel.setEdittedParticles(particleGeom);
        this.influencePanel.updateWidgets();
        this.validate();
    }

    public void resetManager(int n) {
        particleGeom.recreate(n);
        this.validate();
    }

    private Color makeColor(ColorRGBA colorRGBA, boolean bl) {
        return new Color(colorRGBA.r, colorRGBA.g, colorRGBA.b, bl ? colorRGBA.a : 1.0f);
    }

    private ColorRGBA makeColorRGBA(Color color) {
        return new ColorRGBA((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
    }

    private void initFileChooser() {
        String string = this.prefs.get("particle_dir", null);
        if (string != null) {
            this.fileChooser.setCurrentDirectory(new File(string));
        }
        this.fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.toString().toLowerCase().endsWith(".jme");
            }

            public String getDescription() {
                return "JME Files (*.jme)";
            }
        });
    }

    protected Canvas getGlCanvas() {
        if (this.glCanvas == null) {
            this.glCanvas = DisplaySystem.getDisplaySystem().createCanvas(this.width, this.height);
            this.glCanvas.setMinimumSize(new Dimension(100, 100));
            this.glCanvas.addComponentListener(new ComponentAdapter(){

                public void componentResized(ComponentEvent componentEvent) {
                    RenParticleEditor.this.doResize();
                }
            });
            this.camhand = new CameraHandler();
            this.glCanvas.addMouseWheelListener(this.camhand);
            this.glCanvas.addMouseListener(this.camhand);
            this.glCanvas.addMouseMotionListener(this.camhand);
            this.impl = new MyImplementor(this.width, this.height);
            ((JMECanvas)this.glCanvas).setImplementor((JMECanvasImplementor)this.impl);
            Callable callable = new Callable(){

                public Object call() {
                    RenParticleEditor.this.forceUpdateToSize();
                    return null;
                }
            };
            GameTaskQueueManager.getManager().getQueue("render").enqueue(callable);
        }
        return this.glCanvas;
    }

    public void forceUpdateToSize() {
        this.glCanvas.setSize(this.glCanvas.getWidth(), this.glCanvas.getHeight() + 1);
        this.glCanvas.setSize(this.glCanvas.getWidth(), this.glCanvas.getHeight() - 1);
    }

    protected void doResize() {
        if (this.impl != null) {
            this.impl.resizeCanvas(this.glCanvas.getWidth(), this.glCanvas.getHeight());
            if (this.impl.getCamera() != null) {
                Callable callable = new Callable(){

                    public Object call() {
                        RenParticleEditor.this.impl.getCamera().setFrustumPerspective(45.0f, (float)RenParticleEditor.this.glCanvas.getWidth() / (float)RenParticleEditor.this.glCanvas.getHeight(), 1.0f, 10000.0f);
                        return null;
                    }
                };
                GameTaskQueueManager.getManager().getQueue("render").enqueue(callable);
            }
        }
    }

    static {
        EXAMPLE_NAMES = new String[]{"Fire", "Fountain", "Lava", "Smoke", "Jet", "Snow", "Rain", "Explosion", "Ground Fog", "Fireflies"};
    }

    class MyImplementor
    extends SimpleCanvasImpl {
        private static final int GRID_LINES = 51;
        private static final float GRID_SPACING = 100.0f;
        protected Node fpsNode;
        protected Text fps;
        protected StringBuffer tempBuffer;
        protected StringBuffer updateBuffer;

        public MyImplementor(int n, int n2) {
            super(n, n2);
            this.tempBuffer = new StringBuffer();
            this.updateBuffer = new StringBuffer(30);
        }

        public void simpleSetup() {
            Color color = new Color(RenParticleEditor.this.prefs.getInt("bg_color", 0));
            this.renderer.setBackgroundColor(RenParticleEditor.this.makeColorRGBA(color));
            this.cam.setFrustumPerspective(45.0f, (float)RenParticleEditor.this.glCanvas.getWidth() / (float)RenParticleEditor.this.glCanvas.getHeight(), 1.0f, 10000.0f);
            Vector3f vector3f = new Vector3f(0.0f, 850.0f, -850.0f);
            Vector3f vector3f2 = new Vector3f(1.0f, 0.0f, 0.0f);
            Vector3f vector3f3 = new Vector3f(0.0f, 0.7071f, 0.7071f);
            Vector3f vector3f4 = new Vector3f(0.0f, -0.7071f, 0.7071f);
            this.cam.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
            RenParticleEditor.this.root = this.rootNode;
            this.fps = Text.createDefaultTextLabel((String)"FPS label");
            this.fps.setCullMode(3);
            this.fps.setTextureCombineMode(5);
            this.fpsNode = new Node("FPS node");
            this.fpsNode.setRenderState(this.fps.getRenderState(0));
            this.fpsNode.setRenderState(this.fps.getRenderState(6));
            this.fpsNode.attachChild((Spatial)this.fps);
            this.fpsNode.setCullMode(3);
            this.renderer.enableStatistics(true);
            RenParticleEditor.this.root.attachChild((Spatial)(RenParticleEditor.this.grid = this.createGrid()));
            RenParticleEditor.this.grid.updateRenderState();
            particleNode = new Node("particles");
            RenParticleEditor.this.root.attachChild((Spatial)particleNode);
            ZBufferState zBufferState = this.renderer.createZBufferState();
            zBufferState.setWritable(false);
            zBufferState.setEnabled(true);
            zBufferState.setFunction(3);
            particleNode.setRenderState((RenderState)zBufferState);
            particleNode.updateRenderState();
            this.fpsNode.updateGeometricState(0.0f, true);
            this.fpsNode.updateRenderState();
            RenParticleEditor.this.createNewSystem();
        }

        public void simpleUpdate() {
            this.updateBuffer.setLength(0);
            this.updateBuffer.append("FPS: ").append((int)this.timer.getFrameRate()).append(" - ");
            this.updateBuffer.append(this.renderer.getStatistics(this.tempBuffer));
            this.fps.print(this.updateBuffer);
        }

        public void simpleRender() {
            this.fpsNode.draw(this.renderer);
            this.renderer.clearStatistics();
        }

        private Geometry createGrid() {
            Vector3f[] vector3fArray = new Vector3f[204];
            float f = 2500.0f;
            int n = 0;
            for (int i = 0; i < 51; ++i) {
                float f2 = (float)(i - 25) * 100.0f;
                vector3fArray[n++] = new Vector3f(-f, 0.0f, f2);
                vector3fArray[n++] = new Vector3f(f, 0.0f, f2);
                vector3fArray[n++] = new Vector3f(f2, 0.0f, -f);
                vector3fArray[n++] = new Vector3f(f2, 0.0f, f);
            }
            Line line = new Line("grid", vector3fArray, null, null, null);
            line.getBatch(0).getDefaultColor().set(ColorRGBA.darkGray);
            return line;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LayerTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        LayerTableModel() {
        }

        @Override
        public int getRowCount() {
            return particleNode == null ? 0 : particleNode.getQuantity();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            return n == 0 ? "Name" : "Visible";
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return n == 0 ? String.class : Boolean.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            ParticleGeometry particleGeometry = (ParticleGeometry)particleNode.getChild(n);
            return n2 == 0 ? particleGeometry.getName() : Boolean.valueOf(particleGeometry.getCullMode() != 2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ParticleGeometry particleGeometry = (ParticleGeometry)particleNode.getChild(n);
            if (n2 == 0) {
                particleGeometry.setName((String)object);
            } else {
                particleGeometry.setCullMode((Boolean)object != false ? 1 : 2);
            }
        }
    }

    class CameraHandler
    extends MouseAdapter
    implements MouseMotionListener,
    MouseWheelListener {
        Point last = new Point(0, 0);
        Vector3f focus = new Vector3f();
        private Vector3f vector = new Vector3f();
        private Quaternion rot = new Quaternion();

        CameraHandler() {
        }

        public void mouseDragged(final MouseEvent mouseEvent) {
            Callable callable = new Callable(){

                public Object call() {
                    int n = CameraHandler.this.last.x - mouseEvent.getX();
                    int n2 = CameraHandler.this.last.y - mouseEvent.getY();
                    int n3 = mouseEvent.isShiftDown() ? 10 : 1;
                    CameraHandler.this.last.x = mouseEvent.getX();
                    CameraHandler.this.last.y = mouseEvent.getY();
                    int n4 = mouseEvent.getModifiers();
                    if ((n4 & 0x10) != 0) {
                        CameraHandler.this.rotateCamera(Vector3f.UNIT_Y, (float)n * 0.0025f);
                        CameraHandler.this.rotateCamera(RenParticleEditor.this.impl.getRenderer().getCamera().getLeft(), (float)(-n2) * 0.0025f);
                    }
                    if ((n4 & 8) != 0 && n2 != 0) {
                        CameraHandler.this.zoomCamera(n2 * n3);
                    }
                    if ((n4 & 4) != 0) {
                        CameraHandler.this.panCamera(-n, -n2);
                    }
                    return null;
                }
            };
            GameTaskQueueManager.getManager().getQueue("render").enqueue(callable);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.last.x = mouseEvent.getX();
            this.last.y = mouseEvent.getY();
        }

        public void mouseWheelMoved(final MouseWheelEvent mouseWheelEvent) {
            Callable callable = new Callable(){

                public Object call() {
                    CameraHandler.this.zoomCamera(mouseWheelEvent.getWheelRotation() * (mouseWheelEvent.isShiftDown() ? -100 : -20));
                    return null;
                }
            };
            GameTaskQueueManager.getManager().getQueue("render").enqueue(callable);
        }

        public void recenterCamera() {
            Callable callable = new Callable(){

                public Object call() {
                    Camera camera = RenParticleEditor.this.impl.getRenderer().getCamera();
                    Vector3f.ZERO.subtract(CameraHandler.this.focus, CameraHandler.this.vector);
                    camera.getLocation().addLocal(CameraHandler.this.vector);
                    CameraHandler.this.focus.addLocal(CameraHandler.this.vector);
                    camera.onFrameChange();
                    return null;
                }
            };
            GameTaskQueueManager.getManager().getQueue("render").enqueue(callable);
        }

        private void rotateCamera(Vector3f vector3f, float f) {
            Camera camera = RenParticleEditor.this.impl.getRenderer().getCamera();
            if (vector3f.equals((Object)camera.getLeft())) {
                float f2 = -FastMath.asin((float)camera.getDirection().y);
                f = Math.min(Math.max(f2 + f, -1.5707964f), 1.5707964f) - f2;
            }
            this.rot.fromAngleAxis(f, vector3f);
            camera.getLocation().subtract(this.focus, this.vector);
            this.rot.mult(this.vector, this.vector);
            this.focus.add(this.vector, camera.getLocation());
            this.rot.mult(camera.getLeft(), camera.getLeft());
            this.rot.mult(camera.getUp(), camera.getUp());
            this.rot.mult(camera.getDirection(), camera.getDirection());
            camera.normalize();
            camera.onFrameChange();
        }

        private void panCamera(float f, float f2) {
            Camera camera = RenParticleEditor.this.impl.getRenderer().getCamera();
            camera.getLeft().mult(f, this.vector);
            this.vector.scaleAdd(f2, camera.getUp(), this.vector);
            camera.getLocation().addLocal(this.vector);
            this.focus.addLocal(this.vector);
            camera.onFrameChange();
        }

        private void zoomCamera(float f) {
            Camera camera = RenParticleEditor.this.impl.getRenderer().getCamera();
            float f2 = camera.getLocation().distance(this.focus);
            f = f2 - Math.max(0.0f, f2 - f);
            camera.getLocation().scaleAdd(f, camera.getDirection(), camera.getLocation());
            camera.onFrameChange();
        }
    }
}

