/*
 * Decompiled with CFR 0.152.
 */
package jmetest.effects;

import com.jme.app.SimpleGame;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.input.NodeHandler;
import com.jme.math.Vector3f;
import com.jme.renderer.ColorRGBA;
import com.jme.scene.Geometry;
import com.jme.scene.Node;
import com.jme.scene.Spatial;
import com.jme.scene.shape.Disk;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.util.TextureManager;
import com.jme.util.export.binary.BinaryImporter;
import com.jmex.effects.particles.ParticleFactory;
import com.jmex.effects.particles.ParticleMesh;
import com.jmex.model.XMLparser.Converters.MilkToJme;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class TestDynamicSmoker
extends SimpleGame {
    private Node smokeNode;
    private Vector3f offset = new Vector3f(0.0f, 3.75f, 14.0f);
    private ParticleMesh mesh;

    public static void main(String[] stringArray) {
        TestDynamicSmoker testDynamicSmoker = new TestDynamicSmoker();
        testDynamicSmoker.setDialogBehaviour(2);
        testDynamicSmoker.start();
    }

    protected void simpleInitGame() {
        this.cam.setLocation(new Vector3f(0.0f, 50.0f, 100.0f));
        this.cam.update();
        this.smokeNode = new Node("Smoker Node");
        this.smokeNode.setLocalTranslation(new Vector3f(0.0f, 50.0f, -50.0f));
        this.input = new NodeHandler((Spatial)this.smokeNode, 10.0f, 1.0f);
        this.display.setTitle("Dynamic Smoke box");
        MilkToJme milkToJme = new MilkToJme();
        URL uRL = TestDynamicSmoker.class.getClassLoader().getResource("jmetest/data/model/msascii/camera.ms3d");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            milkToJme.convert(uRL.openStream(), (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            System.out.println("IO problem writting the file!!!");
            System.out.println(iOException.getMessage());
            System.exit(0);
        }
        Spatial spatial = null;
        try {
            spatial = (Spatial)BinaryImporter.getInstance().load((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            spatial.setModelBound((BoundingVolume)new BoundingBox());
            spatial.updateModelBound();
        }
        catch (IOException iOException) {
            System.out.println("darn exceptions:" + iOException.getMessage());
        }
        spatial.setLocalScale(5.0f);
        spatial.setRenderQueueMode(2);
        this.smokeNode.attachChild(spatial);
        Disk disk = new Disk("disc", 6, 6, 1.5f);
        disk.setLocalTranslation(this.offset);
        disk.setCullMode(2);
        this.smokeNode.attachChild((Spatial)disk);
        this.rootNode.attachChild((Spatial)this.smokeNode);
        AlphaState alphaState = this.display.getRenderer().createAlphaState();
        alphaState.setBlendEnabled(true);
        alphaState.setSrcFunction(4);
        alphaState.setDstFunction(1);
        alphaState.setTestEnabled(true);
        alphaState.setTestFunction(4);
        alphaState.setEnabled(true);
        TextureState textureState = this.display.getRenderer().createTextureState();
        textureState.setTexture(TextureManager.loadTexture((URL)TestDynamicSmoker.class.getClassLoader().getResource("jmetest/data/texture/flaresmall.jpg"), (int)6, (int)1));
        textureState.setEnabled(true);
        this.mesh = ParticleFactory.buildParticles((String)"particles", (int)300);
        this.mesh.setEmissionDirection(new Vector3f(0.0f, 0.0f, 1.0f));
        this.mesh.setMaximumAngle(0.0f);
        this.mesh.setSpeed(1.0f);
        this.mesh.setMinimumLifeTime(750.0f);
        this.mesh.setMaximumLifeTime(900.0f);
        this.mesh.setStartSize(1.6f);
        this.mesh.setEndSize(15.0f);
        this.mesh.setStartColor(new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f));
        this.mesh.setEndColor(new ColorRGBA(0.6f, 0.2f, 0.0f, 0.0f));
        this.mesh.setInitialVelocity(0.5f);
        this.mesh.setGeometry((Geometry)disk);
        this.mesh.setRotateWithScene(true);
        this.mesh.forceRespawn();
        this.mesh.warmUp(60);
        this.mesh.setModelBound((BoundingVolume)new BoundingBox());
        this.mesh.updateModelBound();
        ZBufferState zBufferState = this.display.getRenderer().createZBufferState();
        zBufferState.setWritable(false);
        zBufferState.setEnabled(true);
        zBufferState.setFunction(3);
        this.mesh.setRenderState((RenderState)textureState);
        this.mesh.setRenderState((RenderState)alphaState);
        this.mesh.setRenderState((RenderState)zBufferState);
        this.rootNode.attachChild((Spatial)this.mesh);
    }
}

